/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.MultiPartEntity;
import io.github.flemmli97.runecraftory.common.entities.misc.EntitySlashResidue;
import io.github.flemmli97.runecraftory.common.entities.monster.MultiPartContainer;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.particles.DurationalParticleData;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitySkelefang
extends BossMonster {
    public static final byte HEAD_DROP = 70;
    public static final byte HEAD_THROW = 71;
    public static final byte NECK_DROP = 72;
    public static final byte NECK_THROW = 73;
    public static final byte FRONT = 74;
    public static final byte FRONT_RIBS = 75;
    public static final byte LEFT_LEG = 76;
    public static final byte RIGHT_LEG = 77;
    public static final byte BACK = 78;
    public static final byte BACK_RIBS = 79;
    public static final byte TAIL = 80;
    public static final byte TAIL_BASE = 81;
    public static final byte HIT = 82;
    public static final byte SHATTER = 83;
    public static final byte CHARGE_BEAM = 84;
    private static final EntityDataAccessor<Integer> HEAD_BONES = SynchedEntityData.m_135353_(EntitySkelefang.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TAIL_BONES = SynchedEntityData.m_135353_(EntitySkelefang.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEFT_LEG_BONES = SynchedEntityData.m_135353_(EntitySkelefang.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RIGHT_LEG_BONES = SynchedEntityData.m_135353_(EntitySkelefang.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BODY_BONES = SynchedEntityData.m_135353_(EntitySkelefang.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final AnimatedAction TAIL_SLAM = AnimatedAction.builder((double)2.0, (String)"tail_slam").marker("attack_1", new double[]{0.72}).marker("attack_2", new double[]{1.2}).marker("attack_3", new double[]{1.64}).build();
    public static final AnimatedAction NEEDLE_THROW = AnimatedAction.builder((double)1.16, (String)"needle_throw").marker("attack", new double[]{0.8}).build();
    public static final AnimatedAction TAIL_SLAP = AnimatedAction.builder((double)0.84, (String)"tail_slap").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction SLASH = AnimatedAction.builder((double)0.96, (String)"slash").marker("attack", new double[]{0.6}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.5, (String)"charge").marker("attack_start", new double[]{0.0}).marker("attack_end", new double[0]).build();
    public static final AnimatedAction BEAM = AnimatedAction.builder((double)13.0, (String)"beam").marker("charge", new double[]{4.5}).marker("beam", new double[]{6.5}).marker("restore_start", new double[]{11.0}).marker("restore_end", new double[]{12.0}).marker("restore", new double[]{11.5}).build();
    public static final AnimatedAction DEATH = AnimatedAction.builder((double)10.0, (String)"death").infinite().build();
    public static final AnimatedAction ROAR = AnimatedAction.builder((double)2.0, (String)"roar").marker("roar", new double[]{0.28}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)TAIL_SLAM, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{TAIL_SLAP, NEEDLE_THROW, TAIL_SLAM, SLASH, CHARGE, BEAM, DEATH, ROAR, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntitySkelefang>> ATTACK_HANDLER = EntitySkelefang.createAnimationHandler(b -> {
        b.put((Object)TAIL_SLAM, (anim, entity) -> {
            block2: {
                block3: {
                    if (entity.remainingTailBones() <= 10 && !entity.isEnraged()) break block2;
                    if (anim.isAt("attack_1") || anim.isAt("attack_2")) break block3;
                    if (!anim.isAt("attack_3")) break block2;
                }
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, entity.m_5720_(), 2.0f, 0.7f);
            }
        });
        b.put((Object)NEEDLE_THROW, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BONE_NEEDLES.get())))).use((LivingEntity)entity);
                if (entity.remainingHeadBones() > 10) {
                    entity.f_19853_.m_7605_((Entity)entity, (byte)71);
                    entity.setHeadBones(10, false);
                } else if (entity.remainingHeadBones() > 0) {
                    entity.f_19853_.m_7605_((Entity)entity, (byte)73);
                    entity.setHeadBones(0, false);
                }
            }
        });
        b.put((Object)TAIL_SLAP, (anim, entity) -> {
            if ((entity.remainingTailBones() > 10 || entity.isEnraged()) && anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                EntitySlashResidue slash;
                Vec3 side;
                Vec3 dir;
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
                Entity patt7670$temp = entity.m_6688_();
                if (patt7670$temp instanceof Player) {
                    Player player = (Player)patt7670$temp;
                    dir = Vec3.m_82498_((float)0.0f, (float)player.f_20883_);
                    side = Vec3.m_82498_((float)0.0f, (float)(player.f_20883_ + 90.0f));
                } else {
                    dir = Vec3.m_82498_((float)0.0f, (float)entity.f_20883_);
                    side = Vec3.m_82498_((float)0.0f, (float)(entity.f_20883_ + 90.0f));
                }
                dir = dir.m_82490_((double)entity.m_20205_() * 0.5 + 1.0);
                if (entity.remainingLeftLegBones() > 0) {
                    Vec3 leftPos = entity.m_20182_().m_82549_(dir).m_82549_(side.m_82490_(-1.3));
                    slash = new EntitySlashResidue(entity.f_19853_, (LivingEntity)entity);
                    slash.setSize(1.5f);
                    slash.setOneTime();
                    slash.m_6034_(leftPos.f_82479_, leftPos.f_82480_, leftPos.f_82481_);
                    slash.m_146926_(0.0f);
                    slash.m_146922_(entity.f_20883_);
                    entity.f_19853_.m_7967_((Entity)slash);
                }
                if (entity.remainingRightLegBones() > 0) {
                    Vec3 rightPos = entity.m_20182_().m_82549_(dir).m_82549_(side.m_82490_(1.3));
                    slash = new EntitySlashResidue(entity.f_19853_, (LivingEntity)entity);
                    slash.setSize(1.5f);
                    slash.setOneTime();
                    slash.m_6034_(rightPos.f_82479_, rightPos.f_82480_, rightPos.f_82481_);
                    slash.m_146926_(0.0f);
                    slash.m_146922_(entity.f_20883_);
                    entity.f_19853_.m_7967_((Entity)slash);
                }
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (entity.hitEntity == null) {
                entity.hitEntity = new ArrayList<LivingEntity>();
            }
            Vec3 dir = entity.m_5448_() != null ? entity.m_5448_().m_20182_().m_82546_(entity.m_20182_()) : Vec3.m_82498_((float)0.0f, (float)entity.m_146908_());
            if ((dir = new Vec3(dir.m_7096_(), 0.0, dir.m_7094_())).m_82556_() < 0.5) {
                entity.m_20334_(0.0, entity.m_20184_().f_82480_, 0.0);
            } else {
                dir = dir.m_82541_().m_82490_(entity.m_21133_(Attributes.f_22279_) * 1.3);
                entity.m_20334_(dir.m_7096_(), entity.m_20184_().f_82480_, dir.m_7094_());
            }
            if (entity.f_19797_ % 5 == 0) {
                entity.m_5496_((SoundEvent)ModSounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.f_19796_.nextFloat() - entity.f_19796_.nextFloat()) * 0.2f + 1.0f);
                S2CScreenShake.sendAround((Entity)entity, 24.0, 10, 1.0f);
            }
            entity.mobAttack((AnimatedAction)anim, null, e -> {
                if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new CustomDamage.Builder((Entity)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.UP).withChangedAttribute((Attribute)ModAttributes.STUN.get(), 70.0))) {
                    entity.hitEntity.add((LivingEntity)e);
                }
            });
        });
        b.put((Object)BEAM, (anim, entity) -> {
            if (anim.isAt("charge")) {
                entity.f_19853_.m_7605_((Entity)entity, (byte)84);
            }
            if (anim.isAt("beam")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ENERGY_ORB_SPELL.get())))).use((LivingEntity)entity);
            }
            if (anim.isAt("restore")) {
                entity.restoreDragon();
            }
        });
        b.put((Object)ROAR, (anim, entity) -> {
            if (anim.isAt("roar")) {
                entity.m_5496_((SoundEvent)ModSounds.ENTITY_SKELEFANG_ROAR.get(), 1.0f, (entity.f_19796_.nextFloat() - entity.f_19796_.nextFloat()) * 0.2f + 1.0f);
                S2CScreenShake.sendAround((Entity)entity, 32.0, 40, 2.0f);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntitySkelefang>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)new GoalAttackAction(TAIL_SLAM).cooldown(e -> e.animationCooldown(TAIL_SLAM)).withCondition((goal, target, previous) -> ((EntitySkelefang)goal.attacker).remainingTailBones() > 10).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.m_21187_().nextInt(20))), (int)10), WeightedEntry.m_146290_((Object)new GoalAttackAction(NEEDLE_THROW).cooldown(e -> e.animationCooldown(NEEDLE_THROW)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 40 + e.m_21187_().nextInt(20))), (int)9), WeightedEntry.m_146290_((Object)new GoalAttackAction(TAIL_SLAP).cooldown(e -> e.animationCooldown(TAIL_SLAP)).withCondition((goal, target, previous) -> ((EntitySkelefang)goal.attacker).remainingTailBones() > 10).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 3.0), e -> 40 + e.m_21187_().nextInt(20))), (int)12), WeightedEntry.m_146290_((Object)new GoalAttackAction(SLASH).cooldown(e -> e.animationCooldown(SLASH)).withCondition((goal, target, previous) -> ((EntitySkelefang)goal.attacker).remainingRightLegBones() > 0 || ((EntitySkelefang)goal.attacker).remainingLeftLegBones() > 0).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.m_21187_().nextInt(20))), (int)9), WeightedEntry.m_146290_((Object)new GoalAttackAction(CHARGE).cooldown(e -> e.animationCooldown(CHARGE)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 7.0), e -> 20 + e.m_21187_().nextInt(20))), (int)11));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntitySkelefang>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 3.0)), (int)1));
    public final AnimatedAttackGoal<EntitySkelefang> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySkelefang> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (anim != null) {
            this.hitEntity = null;
        }
        if (!this.f_19853_.f_46443_ && anim == null) {
            boolean chain = !this.commanded;
            this.commanded = false;
            if (chain && this.getAnimationHandler().isCurrent(new AnimatedAction[]{NEEDLE_THROW})) {
                if (!this.isEnraged() || this.needleChain >= 2 || this.needleChain == 1 && (double)this.m_21187_().nextFloat() > 0.25) {
                    this.needleChain = 0;
                    return false;
                }
                this.getAnimationHandler().setAnimation(NEEDLE_THROW);
                ++this.needleChain;
                return true;
            }
        }
        return false;
    });
    protected List<LivingEntity> hitEntity;
    private final MultiPartContainer head;
    private final MultiPartContainer back;
    private final MultiPartContainer rightLeg;
    private final MultiPartContainer leftLeg;
    private int hurtResist;
    private boolean ignoreHurt;
    private boolean commanded;
    private int needleChain;

    public EntitySkelefang(EntityType<? extends EntitySkelefang> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
        this.head = new MultiPartContainer(() -> new MultiPartEntity((Entity)this, 1.6f, 1.3f));
        this.back = new MultiPartContainer(() -> new MultiPartEntity((Entity)this, 1.6f, 1.5f));
        this.rightLeg = new MultiPartContainer(() -> new MultiPartEntity((Entity)this, 1.5f, 2.5f));
        this.leftLeg = new MultiPartContainer(() -> new MultiPartEntity((Entity)this, 1.5f, 2.5f));
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.SKELEFANG_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
        super.applyAttributes();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD_BONES, (Object)20);
        this.f_19804_.m_135372_(TAIL_BONES, (Object)20);
        this.f_19804_.m_135372_(LEFT_LEG_BONES, (Object)20);
        this.f_19804_.m_135372_(RIGHT_LEG_BONES, (Object)20);
        this.f_19804_.m_135372_(BODY_BONES, (Object)20);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(BODY_BONES) && !this.hasBones()) {
            this.ignoreHurt = true;
        }
    }

    public void restoreDragon() {
        this.f_19804_.m_135381_(HEAD_BONES, (Object)20);
        this.f_19804_.m_135381_(TAIL_BONES, (Object)20);
        this.f_19804_.m_135381_(LEFT_LEG_BONES, (Object)20);
        this.f_19804_.m_135381_(RIGHT_LEG_BONES, (Object)20);
        this.f_19804_.m_135381_(BODY_BONES, (Object)20);
    }

    public void setHeadBones(int amount) {
        this.setHeadBones(amount, true);
    }

    private void setHeadBones(int amount, boolean withParticle) {
        int pre = (Integer)this.f_19804_.m_135370_(HEAD_BONES);
        this.f_19804_.m_135381_(HEAD_BONES, (Object)Math.min(amount, 20));
        if (withParticle) {
            if (pre > 10 && amount <= 10) {
                this.f_19853_.m_7605_((Entity)this, (byte)70);
            }
            if (amount <= 0) {
                this.f_19853_.m_7605_((Entity)this, (byte)72);
            }
        }
    }

    public int remainingHeadBones() {
        return (Integer)this.f_19804_.m_135370_(HEAD_BONES);
    }

    public void setTailBones(int amount) {
        int pre = (Integer)this.f_19804_.m_135370_(TAIL_BONES);
        this.f_19804_.m_135381_(TAIL_BONES, (Object)Math.min(amount, 20));
        if (pre > 10 && amount <= 10) {
            this.f_19853_.m_7605_((Entity)this, (byte)80);
        }
        if (amount <= 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)81);
        }
    }

    public int remainingTailBones() {
        return (Integer)this.f_19804_.m_135370_(TAIL_BONES);
    }

    public void setLeftLegBones(int amount) {
        this.f_19804_.m_135381_(LEFT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)76);
        }
    }

    public int remainingLeftLegBones() {
        return (Integer)this.f_19804_.m_135370_(LEFT_LEG_BONES);
    }

    public void setRightLegBones(int amount) {
        this.f_19804_.m_135381_(RIGHT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)77);
        }
    }

    public int remainingRightLegBones() {
        return (Integer)this.f_19804_.m_135370_(RIGHT_LEG_BONES);
    }

    public void setBodyBones(int amount) {
        int pre = (Integer)this.f_19804_.m_135370_(BODY_BONES);
        this.f_19804_.m_135381_(BODY_BONES, (Object)Math.min(amount, 20));
        if (pre > 15 && amount <= 15) {
            this.f_19853_.m_7605_((Entity)this, (byte)79);
        }
        if (pre > 10 && amount <= 10) {
            this.f_19853_.m_7605_((Entity)this, (byte)78);
        }
        if (pre > 5 && amount <= 5) {
            this.f_19853_.m_7605_((Entity)this, (byte)75);
        }
        if (amount <= 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)74);
        }
    }

    public boolean checkIgnoreHurtOverlay() {
        if (this.ignoreHurt) {
            this.ignoreHurt = false;
            return true;
        }
        return false;
    }

    public int remainingBodyBones() {
        return (Integer)this.f_19804_.m_135370_(BODY_BONES);
    }

    public boolean hasBones() {
        return this.remainingHeadBones() > 0 || this.remainingTailBones() > 0 || this.remainingLeftLegBones() > 0 || this.remainingRightLegBones() > 0 || this.remainingBodyBones() > 0;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("HeadBones", this.remainingHeadBones());
        compound.m_128405_("TailBones", this.remainingTailBones());
        compound.m_128405_("LeftLegBones", this.remainingLeftLegBones());
        compound.m_128405_("RightLegBones", this.remainingRightLegBones());
        compound.m_128405_("BodyBones", this.remainingBodyBones());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(HEAD_BONES, (Object)compound.m_128451_("HeadBones"));
        this.f_19804_.m_135381_(TAIL_BONES, (Object)compound.m_128451_("TailBones"));
        this.f_19804_.m_135381_(LEFT_LEG_BONES, (Object)compound.m_128451_("LeftLegBones"));
        this.f_19804_.m_135381_(RIGHT_LEG_BONES, (Object)compound.m_128451_("RightLegBones"));
        this.f_19804_.m_135381_(BODY_BONES, (Object)compound.m_128451_("BodyBones"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.hurtResist;
            this.updateParts();
            if (!(this.m_21224_() || this.hasBones() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{BEAM}))) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
            if (this.m_6084_() && !this.getAnimationHandler().hasAnimation() && !this.isTamed() && (double)(this.m_21223_() / this.m_21233_()) < 0.5 && !this.isEnraged()) {
                this.setEnraged(true, false);
            }
        }
    }

    @Override
    public void m_7822_(byte id) {
        switch (id) {
            case 70: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.m_146909_(), this.f_20885_, 1.0f, 0.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 71: {
                Vec3 look = Vec3.m_82498_((float)0.0f, (float)this.f_20883_);
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.m_146909_(), this.f_20885_, -2.0f, 0.0f, 40, false), this.m_20185_(), this.m_20186_(), this.m_20189_(), look.f_82479_, look.f_82480_, look.f_82481_);
                break;
            }
            case 72: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.m_146909_(), this.f_20885_, 1.0f, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 73: {
                Vec3 look = Vec3.m_82498_((float)0.0f, (float)this.f_20883_);
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.m_146909_(), this.f_20885_, -2.0f, 0.0f, 40, false), this.m_20185_(), this.m_20186_(), this.m_20189_(), look.f_82479_, look.f_82480_, look.f_82481_);
                break;
            }
            case 74: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 75: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT_RIBS, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 76: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.LEFT_LEG, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 77: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.RIGHT_LEG, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 78: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 79: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK_RIBS, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 80: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 81: {
                this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL_BASE, this.m_146909_(), this.f_20883_, this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 82: {
                int amount = this.f_19796_.nextInt(6) + 12;
                for (int i = 0; i < amount; ++i) {
                    SkelefangParticleData.SkelefangBoneType type = (double)this.f_19796_.nextFloat() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                    this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(type, this.m_146909_() + (float)this.f_19796_.nextInt(40) - 20.0f, this.f_20885_ + (float)this.f_19796_.nextInt(360), this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20208_(1.3), this.m_20227_(0.5) + (double)this.m_20206_() * 0.5, this.m_20262_(1.3), this.f_19796_.nextGaussian() * 0.11, this.f_19796_.nextGaussian() * 0.11, this.f_19796_.nextGaussian() * 0.11);
                }
                break;
            }
            case 83: {
                int amount = this.f_19796_.nextInt(15) + 35;
                if (this.hasBones()) {
                    for (int i = 0; i < amount; ++i) {
                        SkelefangParticleData.SkelefangBoneType type = (double)this.f_19796_.nextFloat() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                        this.f_19853_.m_7107_((ParticleOptions)new SkelefangParticleData(type, this.m_146909_() + (float)this.f_19796_.nextInt(40) - 20.0f, this.f_20885_ + (float)this.f_19796_.nextInt(360), this.f_19796_.nextInt(2) - 1, this.f_19796_.nextInt(2) - 1), this.m_20208_(1.3), this.m_20227_(0.5) + (double)this.m_20206_() * 0.5, this.m_20262_(1.3), this.f_19796_.nextGaussian() * 0.13, this.f_19796_.nextGaussian() * 0.13, this.f_19796_.nextGaussian() * 0.13);
                    }
                }
                if (this.remainingHeadBones() > 10) {
                    this.m_7822_((byte)70);
                }
                if (this.remainingHeadBones() > 0) {
                    this.m_7822_((byte)72);
                }
                if (this.remainingBodyBones() > 0) {
                    this.m_7822_((byte)74);
                }
                if (this.remainingBodyBones() > 5) {
                    this.m_7822_((byte)75);
                }
                if (this.remainingBodyBones() > 10) {
                    this.m_7822_((byte)78);
                }
                if (this.remainingBodyBones() > 15) {
                    this.m_7822_((byte)79);
                }
                if (this.remainingLeftLegBones() > 0) {
                    this.m_7822_((byte)76);
                }
                if (this.remainingRightLegBones() > 0) {
                    this.m_7822_((byte)77);
                }
                if (this.remainingTailBones() > 0) {
                    this.m_7822_((byte)81);
                }
                if (this.remainingTailBones() <= 10) break;
                this.m_7822_((byte)80);
                break;
            }
            case 84: {
                Vec3 center = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
                ArrayList locations = new ArrayList();
                double speed = (this.m_20205_() + 2.0f) / 40.0f;
                locations.addAll(RayTraceUtils.rotatedVecs((Vec3)MathUtils.NORMAL_X.m_82490_((double)(this.m_20205_() + 2.0f)), (Vec3)MathUtils.NORMAL_Z, (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(RayTraceUtils.rotatedVecs((Vec3)MathUtils.NORMAL_X.m_82490_((double)(this.m_20205_() + 2.0f)), (Vec3)MathUtils.NORMAL_Y, (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(RayTraceUtils.rotatedVecs((Vec3)MathUtils.NORMAL_Y.m_82490_((double)(this.m_20205_() + 2.0f)), (Vec3)MathUtils.NORMAL_X, (float)-180.0f, (float)180.0f, (float)10.0f));
                for (Vector3f vec : locations) {
                    Vec3 pos = center.m_82520_((double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_());
                    Vec3 dir = new Vec3((double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_()).m_82541_().m_82490_(speed);
                    this.f_19853_.m_7107_((ParticleOptions)new DurationalParticleData(0.8509804f, 0.972549f, 0.9882353f, 0.4f, 2.3f, 40, this.m_142049_()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), -dir.m_7096_(), -dir.m_7098_(), -dir.m_7094_());
                }
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
        if (this.f_20917_ == 10 && this.checkIgnoreHurtOverlay()) {
            this.f_20917_ = 0;
        }
    }

    private void updateParts() {
        if (this.remainingTailBones() > 0) {
            Vec3 view = this.m_20171_(0.0f, this.f_20883_);
            Vec3 backPos = this.m_20182_().m_82549_(view.m_82490_(-1.0)).m_82520_(0.0, 1.0, 0.0);
            this.back.updatePositionTo(backPos.m_7096_(), backPos.m_7098_(), backPos.m_7094_(), true);
        } else {
            this.back.removeEntity();
        }
        if (this.remainingHeadBones() > 10) {
            Vec3 headPos = this.m_20182_().m_82549_(this.m_20171_(this.m_146909_() * 0.6f, this.f_20883_).m_82490_(2.9).m_82520_(0.0, 2.15, 0.0));
            this.head.updatePositionTo(headPos.m_7096_(), headPos.m_7098_(), headPos.m_7094_(), true);
        } else {
            this.head.removeEntity();
        }
        Vec3 side = this.m_20171_(0.0f, this.f_20883_ + 90.0f);
        if (this.remainingLeftLegBones() > 0) {
            Vec3 leftLegPos = this.m_20182_().m_82549_(side.m_82490_(-1.0)).m_82520_(0.0, 0.0, 0.0);
            this.leftLeg.updatePositionTo(leftLegPos.m_7096_(), leftLegPos.m_7098_(), leftLegPos.m_7094_(), true);
        } else {
            this.leftLeg.removeEntity();
        }
        if (this.remainingRightLegBones() > 0) {
            Vec3 rightLegPos = this.m_20182_().m_82549_(side.m_82490_(1.0)).m_82520_(0.0, 0.0, 0.0);
            this.rightLeg.updatePositionTo(rightLegPos.m_7096_(), rightLegPos.m_7098_(), rightLegPos.m_7094_(), true);
        } else {
            this.rightLeg.removeEntity();
        }
    }

    @Override
    protected boolean checkRage() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ROAR}) && super.m_6469_(source, amount);
    }

    @Override
    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        if (damageSrc == DamageSource.f_19317_) {
            super.m_6475_(damageSrc, damageAmount);
            if (this.m_21224_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)83);
            }
            return;
        }
        if (this.hurtResist > 0) {
            return;
        }
        this.hurtResist = 2;
        if (this.hasBones()) {
            if (damageAmount > 4.0f) {
                int amount;
                int boneDamage = 7;
                if (this.remainingTailBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingTailBones());
                    boneDamage -= amount;
                    this.setTailBones(this.remainingTailBones() - amount);
                }
                if (this.remainingLeftLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingLeftLegBones());
                    boneDamage -= amount;
                    this.setLeftLegBones(this.remainingLeftLegBones() - amount);
                }
                if (this.remainingRightLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingRightLegBones());
                    boneDamage -= amount;
                    this.setRightLegBones(this.remainingRightLegBones() - amount);
                }
                if (this.remainingHeadBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingHeadBones());
                    boneDamage -= amount;
                    this.setHeadBones(this.remainingHeadBones() - amount);
                }
                if (this.remainingBodyBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingBodyBones());
                    this.setBodyBones(this.remainingBodyBones() - amount);
                }
            }
            if (this.m_21224_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)83);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)82);
            }
            if (!this.hasBones()) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        } else {
            super.m_6475_(damageSrc, damageAmount);
        }
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEATH;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE})) {
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        this.m_21573_().m_26573_();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void mobAttack(AnimatedAction anim, LivingEntity target, Consumer<LivingEntity> cons) {
        if (anim.is(new AnimatedAction[]{CHARGE})) {
            double width = this.m_20205_();
            double speed = Math.max(width, this.m_20184_().m_82553_() - width);
            OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(0.2, 0.0, 0.2).m_82363_(0.0, 0.0, speed), this.m_146908_(), 0.0f, this.m_20182_());
            this.f_19853_.m_6443_(LivingEntity.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.m_142469_())).forEach(cons);
            if (!this.f_19853_.f_46443_) {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
            }
            return;
        }
        ArrayList<OrientedBoundingBox> obbs = new ArrayList<OrientedBoundingBox>();
        if (anim.is(new AnimatedAction[]{TAIL_SLAP})) {
            double range = this.m_20205_() + 5.0f;
            obbs.add(new OrientedBoundingBox(new AABB(-range * 0.75, -0.02, 0.0, range * 0.75, 1.82, range), this.m_146908_(), 0.0f, this.m_20182_()));
        }
        if (anim.is(new AnimatedAction[]{TAIL_SLAM})) {
            float angle = this.f_20885_;
            Entity entity2 = this.m_6688_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                angle = player.f_20885_;
            }
            if (anim.isAt("attack_2")) {
                angle -= 35.0f;
            } else if (anim.isAt("attack_3")) {
                angle += 20.0f;
            }
            obbs.add(new OrientedBoundingBox(new AABB(-1.25, -0.02, 0.0, 1.25, 2.12, 7.0), angle, 0.0f, this.m_20182_()));
        }
        if (anim.is(new AnimatedAction[]{SLASH})) {
            Vec3 side;
            Vec3 dir;
            double reach = 1.0;
            Entity entity3 = this.m_6688_();
            if (entity3 instanceof Player) {
                Player player = (Player)entity3;
                dir = Vec3.m_82498_((float)0.0f, (float)player.f_20883_);
                side = Vec3.m_82498_((float)0.0f, (float)(player.f_20883_ + 90.0f));
            } else {
                dir = Vec3.m_82498_((float)0.0f, (float)this.f_20883_);
                side = Vec3.m_82498_((float)0.0f, (float)(this.f_20883_ + 90.0f));
            }
            dir = dir.m_82490_((double)this.m_20205_() * 0.5 + reach);
            double attackSize = 1.65;
            if (this.remainingLeftLegBones() > 0) {
                Vec3 rightPos = this.m_20182_().m_82549_(dir).m_82549_(side.m_82490_(1.3));
                obbs.add(new OrientedBoundingBox(new AABB(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.m_146908_(), 0.0f, rightPos));
            }
            if (this.remainingRightLegBones() > 0) {
                Vec3 leftPos = this.m_20182_().m_82549_(dir).m_82549_(side.m_82490_(-1.3));
                obbs.add(new OrientedBoundingBox(new AABB(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.m_146908_(), 0.0f, leftPos));
            }
        }
        HashSet targets = new HashSet();
        for (OrientedBoundingBox obb : obbs) {
            targets.addAll(this.f_19853_.m_6443_(LivingEntity.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.m_142469_())));
            if (this.f_19853_.f_46443_) continue;
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
        targets.forEach(cons);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE);
            } else {
                this.getAnimationHandler().setAnimation(TAIL_SLAP);
            }
            this.commanded = true;
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ROAR);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        if (this.hasBones()) {
            return new Vec3(0.0, 2.71875, 0.4375);
        }
        return new Vec3(0.0, 1.875, -0.1875);
    }

    public AnimationHandler<EntitySkelefang> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 27 + this.m_21187_().nextInt(20) : 35 + this.m_21187_().nextInt(25)) + diffAdd;
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return DEATH;
    }

    @Override
    public void playAngrySound() {
    }
}

