/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityThunderbolt
extends BossMonster {
    public static final AnimatedAction BACK_KICK = AnimatedAction.builder((double)0.64, (String)"back_kick").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction LASER_X5 = AnimatedAction.builder((double)1.44, (String)"laser_x5").marker("attack", new double[]{1.2}).build();
    public static final AnimatedAction STOMP = AnimatedAction.builder((double)0.44, (String)"stomp").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction HORN_ATTACK = AnimatedAction.builder((double)0.44, (String)"horn_attack").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction BACK_KICK_HORN = AnimatedAction.copyOf((AnimatedAction)BACK_KICK, (String)"back_kick_horn");
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.64, (String)"charge").marker("attack_start", new double[]{0.44}).marker("attack_end", new double[]{1.12}).build();
    public static final AnimatedAction CHARGE_2 = AnimatedAction.copyOf((AnimatedAction)CHARGE, (String)"charge_2");
    public static final AnimatedAction CHARGE_3 = AnimatedAction.copyOf((AnimatedAction)CHARGE, (String)"charge_3");
    public static final AnimatedAction LASER_AOE = AnimatedAction.copyOf((AnimatedAction)LASER_X5, (String)"laser_aoe");
    public static final AnimatedAction LASER_KICK = AnimatedAction.builder((double)1.2, (String)"laser_kick").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction LASER_KICK_2 = AnimatedAction.copyOf((AnimatedAction)LASER_KICK, (String)"laser_kick_2");
    public static final AnimatedAction WIND_BLADE = AnimatedAction.builder((double)0.72, (String)"wind_blade").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction LASER_KICK_3 = AnimatedAction.copyOf((AnimatedAction)LASER_KICK, (String)"laser_kick_3");
    public static final AnimatedAction FEINT = AnimatedAction.builder((double)2.0, (String)"feint").marker("neigh", new double[]{0.96}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction NEIGH = AnimatedAction.builder((double)1.16, (String)"neigh").marker("neigh", new double[]{0.48}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)STOMP, (String)"interact");
    private static final float RANGE_THRESHOLD = 0.7f;
    private static final float FEINT_THRESHOLD = 0.35f;
    private static final AnimatedAction[] ANIMATED_ACTIONS = new AnimatedAction[]{BACK_KICK, LASER_X5, STOMP, HORN_ATTACK, BACK_KICK_HORN, CHARGE, CHARGE_2, CHARGE_3, LASER_AOE, LASER_KICK, LASER_KICK_2, WIND_BLADE, LASER_KICK_3, FEINT, DEFEAT, NEIGH, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityThunderbolt>> ATTACK_HANDLER = EntityThunderbolt.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityThunderbolt> kick = (anim, entity) -> {
            LivingEntity target = entity.m_5448_();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, e -> {
                    if (entity.m_7327_((Entity)e)) {
                        e.m_20334_(0.0, 0.05, 0.0);
                        e.f_19812_ = true;
                        e.m_147240_((double)0.8f, entity.m_20185_() - e.m_20185_(), entity.m_20189_() - e.m_20189_());
                    }
                });
            }
        };
        b.put((Object)BACK_KICK, kick);
        b.put((Object)BACK_KICK_HORN, kick);
        b.put((Object)HORN_ATTACK, (anim, entity) -> {
            LivingEntity target = entity.m_5448_();
            if (anim.isAt("attack")) {
                AtomicBoolean bool = new AtomicBoolean(false);
                entity.mobAttack((AnimatedAction)anim, target, e -> {
                    if (entity.m_7327_((Entity)e)) {
                        if (!bool.get()) {
                            bool.set(true);
                        }
                        e.m_20334_(0.0, 0.65, 0.0);
                        e.f_19812_ = true;
                    }
                });
                if (bool.get() && !entity.m_20160_()) {
                    entity.hornAttackSuccess = true;
                }
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.m_5448_(), entity::m_7327_);
            }
        });
        b.put((Object)WIND_BLADE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DOUBLE_SONIC.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)LASER_X5, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LASER5.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)LASER_AOE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LASER_AOE.get())))).use((LivingEntity)entity);
            }
        });
        BiConsumer<AnimatedAction, EntityThunderbolt> bigLaser = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BIG_LIGHTNING.get())))).use((LivingEntity)entity);
            }
        };
        b.put((Object)LASER_KICK, bigLaser);
        b.put((Object)LASER_KICK_2, bigLaser);
        b.put((Object)LASER_KICK_3, bigLaser);
        BiConsumer<AnimatedAction, EntityThunderbolt> charge = (anim, entity) -> {
            if (entity.chargeMotion == null) {
                entity.setChargeDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).m_82490_(2.0));
            }
            if (anim.isAt("attack_start")) {
                entity.m_20334_(entity.chargeMotion.m_7096_(), 0.2, entity.chargeMotion.m_7094_());
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end") && !entity.chargeAttackSuccess) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (entity.m_7327_((Entity)e)) {
                        entity.chargeAttackSuccess = true;
                        entity.m_20334_(0.0, entity.m_20184_().f_82480_, 0.0);
                    }
                });
            }
        };
        b.put((Object)CHARGE, charge);
        b.put((Object)CHARGE_2, charge);
        b.put((Object)CHARGE_3, charge);
        b.put((Object)NEIGH, (anim, entity) -> {
            if (anim.isAt("neigh")) {
                entity.m_5496_((SoundEvent)ModSounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
        });
        b.put((Object)FEINT, (anim, entity) -> {
            if (anim.isAt("neigh")) {
                entity.m_5496_((SoundEvent)ModSounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.m_21187_().nextFloat() - entity.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityThunderbolt>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(BACK_KICK).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, BACK_KICK) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(LASER_X5).withCondition((goal, target, previous) -> !((EntityThunderbolt)goal.attacker).isEnraged() && ((EntityThunderbolt)goal.attacker).allowAnimation(previous, LASER_X5) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.2, 4), e -> 35 + e.m_21187_().nextInt(15))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(STOMP).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, STOMP) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)11), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(HORN_ATTACK).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, HORN_ATTACK) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)9), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(CHARGE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, CHARGE) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(LASER_AOE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).isEnraged() && ((EntityThunderbolt)goal.attacker).allowAnimation(previous, LASER_AOE) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.2, 4), e -> 35 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(LASER_KICK).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).isEnraged() && ((EntityThunderbolt)goal.attacker).allowAnimation(previous, LASER_KICK) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)8), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WIND_BLADE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, WIND_BLADE) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.2, 7.0), e -> 35 + e.m_21187_().nextInt(15))), (int)7), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WIND_BLADE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, WIND_BLADE) && !((EntityThunderbolt)goal.attacker).feintedDeath && ((EntityThunderbolt)goal.attacker).m_5448_() != null && ((EntityThunderbolt)goal.attacker).m_5448_().m_20186_() - ((EntityThunderbolt)goal.attacker).m_20186_() > 4.0).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.2, 7.0), e -> 35 + e.m_21187_().nextInt(15))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(LASER_AOE).cooldown(e -> e.animationCooldown(LASER_AOE) + 30).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).afterFeint()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.2, 4), e -> 35 + e.m_21187_().nextInt(15))), (int)4), WeightedEntry.m_146290_((Object)new GoalAttackAction(CHARGE).cooldown(e -> e.animationCooldown(CHARGE) + 40).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).afterFeint()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)20), WeightedEntry.m_146290_((Object)new GoalAttackAction(LASER_KICK).cooldown(e -> e.animationCooldown(LASER_KICK) + 50).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).afterFeint()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.m_21187_().nextInt(15))), (int)17));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityThunderbolt>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(() -> new MoveToTargetRunner(1.1, 0.5)), (int)8), WeightedEntry.m_146290_((Object)new IdleAction(() -> new StrafingRunner(7.0f, 1.1f, 0.2f)), (int)10), WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new).withCondition((goal, target) -> ((EntityThunderbolt)goal.attacker).afterFeint()), (int)6));
    public final AnimatedAttackGoal<EntityThunderbolt> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityThunderbolt> animationHandler = new AnimationHandler((Entity)this, ANIMATED_ACTIONS).withChangeListener(anim -> {
        if (!this.f_19853_.f_46443_) {
            this.setChargeDirection(null);
            if (anim == null) {
                AnimatedAction chainAnim = this.chainAnim(this.getAnimationHandler().getAnimation());
                this.chargeAttackSuccess = false;
                this.hornAttackSuccess = false;
                boolean chain = !this.commanded;
                this.commanded = false;
                if (chain && chainAnim != null) {
                    this.getAnimationHandler().setAnimation(chainAnim);
                    return true;
                }
            }
            return false;
        }
        return false;
    });
    protected boolean feintedDeath;
    protected boolean hornAttackSuccess;
    protected boolean chargeAttackSuccess;
    private Vec3 chargeMotion;
    private boolean commanded;

    public EntityThunderbolt(EntityType<? extends BossMonster> type, Level world) {
        super(type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
        this.f_19793_ = 1.0f;
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.THUNDERBOLT_FIGHT.get());
    }

    private boolean afterFeint() {
        return !this.isTamed() && this.isEnraged() && this.feintedDeath;
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.31);
        super.applyAttributes();
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.f_21345_.m_25363_((Goal)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.f_21345_.m_25352_(6, (Goal)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT, NEIGH})) && super.m_6469_(source, amount);
    }

    @Override
    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT});
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT})) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (anim.is(new AnimatedAction[]{STOMP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82377_(1.7, -0.4, 1.7), this.m_146908_(), 0.0f, this.m_20182_());
        }
        if (anim.is(new AnimatedAction[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82400_(grow + 1.0), this.m_146908_(), 0.0f, this.m_20182_());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimatedAction anim) {
        double width = (double)this.m_20205_() * 1.6;
        double length = (double)this.m_20205_() * 1.5;
        if (anim.is(new AnimatedAction[]{HORN_ATTACK})) {
            width = (double)this.m_20205_() * 1.3;
            length = (double)this.m_20205_() * 1.8;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.m_20206_() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 2 ? (Spell)((Object)ModSpells.LASER5.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LASER_X5);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(STOMP);
            } else {
                this.getAnimationHandler().setAnimation(HORN_ATTACK);
            }
            this.commanded = true;
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11978_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11971_;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 0.8f;
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    @Override
    public void m_8119_() {
        AnimatedAction anim;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_21223_() > 0.0f && this.getAnimationHandler().isCurrent(new AnimatedAction[]{DEFEAT}) && !this.feintedDeath && !this.isTamed() && (anim = this.getAnimationHandler().getAnimation()).done(0)) {
            this.feintDeath();
        }
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT}) && !this.isTamed()) {
            Vec3 delta = this.m_20184_();
            this.m_20334_(0.0, delta.f_82480_, 0.0);
            if (this.getAnimationHandler().getAnimation().is(new AnimatedAction[]{DEFEAT})) {
                int tick = (int)this.getAnimationHandler().getAnimation().getTick(1.0f);
                if (tick < 40) {
                    if (tick % 10 == 0) {
                        this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
                    }
                } else if (tick < 80) {
                    if (tick % 2 == 0) {
                        this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 2.0f), this.m_20186_() + this.f_19796_.nextDouble() * (double)(this.m_20206_() + 1.0f), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 2.0f), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
                    }
                } else {
                    int amount = (tick - 80) / 10;
                    for (int i = 0; i < amount; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 3.0f), this.m_20186_() + this.f_19796_.nextDouble() * (double)(this.m_20206_() + 1.0f), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 3.0f), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
                    }
                }
            }
        }
    }

    protected void feintDeath() {
        this.feintedDeath = true;
        this.getAnimationHandler().setAnimation(FEINT);
        STAT_INCREASE.forEach(att -> {
            AttributeInstance inst = this.m_21051_((Attribute)att.get());
            inst.m_22120_(STAT_INCREASE_ID);
            inst.m_22125_(new AttributeModifier(STAT_INCREASE_ID, "rf.boss_stat_increase", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL));
        });
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return this.chargeMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Feint", this.feintedDeath);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.feintedDeath = compound.m_128471_("Feint");
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        if (flag && !load) {
            if (!this.isEnraged()) {
                this.getAnimationHandler().setAnimation(NEIGH);
                this.m_21573_().m_26573_();
            } else {
                this.getAnimationHandler().setAnimation(DEFEAT);
                this.m_21573_().m_26573_();
                this.bossInfo.m_142711_(0.0f);
            }
        }
        super.setEnraged(flag, load);
    }

    @Override
    protected void updateBossBar() {
        if (!this.feintedDeath) {
            this.bossInfo.m_142711_((this.m_21223_() - this.m_21233_() * 0.35f) / (this.m_21233_() * 0.7f));
        } else {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    @Override
    protected boolean checkRage() {
        if (this.m_21223_() / this.m_21233_() < 0.35f) {
            return !this.feintedDeath;
        }
        if (this.m_21223_() / this.m_21233_() < 0.7f) {
            return !this.isEnraged();
        }
        return false;
    }

    @Override
    protected void fullyHeal() {
        super.fullyHeal();
        this.feintedDeath = false;
    }

    public boolean m_6084_() {
        return super.m_6084_() && (this.getAnimationHandler() == null || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT}));
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!state.m_60767_().m_76332_()) {
            BlockState blockstate = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType soundtype = Platform.INSTANCE.getSoundType(state, this.f_19853_, pos, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = Platform.INSTANCE.getSoundType(blockstate, this.f_19853_, pos, (Entity)this);
            }
            this.m_5496_(SoundEvents.f_11977_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
        }
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 1.6875, -0.25);
    }

    public AnimationHandler<EntityThunderbolt> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (!this.isTamed() && this.isEnraged() && this.feintedDeath) {
            return other.is(new AnimatedAction[]{CHARGE, LASER_KICK, LASER_AOE});
        }
        if (prev.equals(CHARGE_2.getID()) || prev.equals(CHARGE_3.getID())) {
            return !other.getID().equals(CHARGE.getID());
        }
        if (prev.equals(LASER_KICK_2.getID()) || prev.equals(LASER_KICK_3.getID())) {
            return !other.getID().equals(LASER_KICK.getID());
        }
        if (prev.equals(BACK_KICK_HORN.getID())) {
            return !other.getID().equals(HORN_ATTACK.getID());
        }
        return super.allowAnimation(prev, other);
    }

    public AnimatedAction chainAnim(AnimatedAction anim) {
        if (anim == null) {
            return null;
        }
        return switch (anim.getID()) {
            case "laser_kick" -> {
                if (this.isEnraged() && this.feintedDeath) {
                    yield LASER_KICK_2;
                }
                yield null;
            }
            case "laser_kick_2" -> {
                if (this.feintedDeath) {
                    yield LASER_KICK_3;
                }
                yield null;
            }
            case "horn_attack" -> {
                if (this.hornAttackSuccess) {
                    yield BACK_KICK_HORN;
                }
                yield null;
            }
            case "charge" -> {
                if (this.chargeAttackSuccess) {
                    yield null;
                }
                yield CHARGE_2;
            }
            case "charge_2" -> {
                if (this.isEnraged() && !this.chargeAttackSuccess) {
                    yield CHARGE_3;
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public void playAngrySound() {
    }

    protected void setChargeDirection(Vec3 moveDirection) {
        this.chargeMotion = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.chargeMotion = motion;
        });
    }
}

