/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.EntitySanoUno;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntitySano;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;

public class EntityUno
extends EntitySanoUno {
    public static final AnimatedAction WATER_LASER = AnimatedAction.builder((double)2.0, (String)"water_laser").marker("attack_1", new double[]{0.8}).marker("attack_2", new double[]{1.2}).build();
    public static final AnimatedAction WATER_LASER_2 = AnimatedAction.builder((double)2.0, (String)"water_swipe").marker("attack_1", new double[]{0.8}).marker("attack_2", new double[]{1.6}).build();
    public static final AnimatedAction ICEBALLS_5 = AnimatedAction.builder((double)3.0, (String)"iceballs").marker("attack", new double[]{0.8, 1.2, 1.6, 2.0, 2.4}).build();
    public static final AnimatedAction HOMING_WATER_WAVE = AnimatedAction.builder((double)2.0, (String)"water_wave").marker("attack", new double[]{0.8}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{WATER_LASER, WATER_LASER_2, ICEBALLS_5, HOMING_WATER_WAVE, DEFEAT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityUno>> ATTACK_HANDLER = EntityUno.createAnimationHandler(b -> {
        b.put((Object)WATER_LASER, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_LASER_LONG.get())))).use((LivingEntity)entity);
            }
            if (anim.isAt("attack_2")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PARALLEL_LASER_LONG.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)WATER_LASER_2, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                entity.reversedSwipe = false;
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_SWIPE.get())))).use((LivingEntity)entity);
            }
            if (anim.isAt("attack_2")) {
                entity.reversedSwipe = true;
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_SWIPE.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)ICEBALLS_5, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ICE_BALL_DROP.get())))).use((LivingEntity)entity);
            }
        });
        b.put((Object)HOMING_WATER_WAVE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ICE_TRAIL.get())))).use((LivingEntity)entity);
            }
        });
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityUno>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WATER_LASER).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(WATER_LASER_2).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(ICEBALLS_5).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), WeightedEntry.m_146290_((Object)MonsterActionUtils.nonRepeatableAttack(HOMING_WATER_WAVE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityUno>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new).duration(e -> e.m_21187_().nextInt(20) + 35), (int)1));
    public final AnimatedAttackGoal<EntityUno> attack = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityUno> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private EntitySano other;

    public EntityUno(EntityType<? extends EntityUno> type, Level world) {
        super((EntityType<? extends EntitySanoUno>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack);
        }
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.ICE_BALL_DROP.get()))) {
                    this.getAnimationHandler().setAnimation(ICEBALLS_5);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.PARALLEL_LASER.get()))) {
                    this.getAnimationHandler().setAnimation(WATER_LASER_2);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.m_6688_(), (Spell)((Object)ModSpells.WATER_LASER.get()))) {
                this.getAnimationHandler().setAnimation(WATER_LASER);
            }
        }
    }

    public AnimationHandler<EntityUno> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public EntitySano getLinked() {
        List results;
        if (this.other != null && !this.other.m_146910_()) {
            return this.other;
        }
        if (this.getLinkedID() != null && !(results = this.f_19853_.m_142425_(EntityTypeTest.m_156916_(EntitySano.class), this.m_142469_().m_82400_(64.0), e -> this.getLinkedID().equals(e.getLinkedID()))).isEmpty()) {
            this.other = (EntitySano)results.get(0);
        }
        return this.other;
    }
}

