/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaFlower;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaHorseTail;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaPart;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaPitcher;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityRafflesia
extends BossMonster {
    private static final EntityDataAccessor<Optional<UUID>> HORSE_TAIL = SynchedEntityData.m_135353_(EntityRafflesia.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> FLOWER = SynchedEntityData.m_135353_(EntityRafflesia.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> PITCHER = SynchedEntityData.m_135353_(EntityRafflesia.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Direction> SPAWN_DIRECTION = SynchedEntityData.m_135353_(EntityRafflesia.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static final AnimatedAction POISON_BREATH = AnimatedAction.builder((double)1.96, (String)"breath").marker("attack", new double[]{0.56}).build();
    public static final AnimatedAction POISON_BREATH_REV = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"breath_2");
    public static final AnimatedAction PARA_BREATH = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"paralysis_breath");
    public static final AnimatedAction PARA_BREATH_REV = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"paralysis_breath_2");
    public static final AnimatedAction SLEEP_BREATH = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"sleep_breath");
    public static final AnimatedAction SLEEP_BREATH_REV = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"sleep_breath_2");
    public static final AnimatedAction WIND_BLADE_X8 = AnimatedAction.builder((double)0.88, (String)"casting").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction WIND_BLADE_X16 = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"wind_blade_x16");
    public static final AnimatedAction RESUMMON = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"resummon");
    public static final AnimatedAction STATUS_CIRCLE = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"status_circle");
    public static final AnimatedAction DEATH = AnimatedAction.builder((double)10.0, (String)"death").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"roar");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{POISON_BREATH, POISON_BREATH_REV, PARA_BREATH, PARA_BREATH_REV, SLEEP_BREATH, SLEEP_BREATH_REV, WIND_BLADE_X8, WIND_BLADE_X16, RESUMMON, STATUS_CIRCLE, DEATH, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityRafflesia>> ATTACK_HANDLER = EntityRafflesia.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityRafflesia> cons = (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.useAttack((AnimatedAction)anim);
            }
        };
        b.put((Object)POISON_BREATH, cons);
        b.put((Object)PARA_BREATH, cons);
        b.put((Object)SLEEP_BREATH, cons);
        b.put((Object)POISON_BREATH_REV, cons);
        b.put((Object)PARA_BREATH_REV, cons);
        b.put((Object)SLEEP_BREATH_REV, cons);
        b.put((Object)WIND_BLADE_X8, cons);
        b.put((Object)WIND_BLADE_X16, cons);
        b.put((Object)RESUMMON, cons);
        b.put((Object)STATUS_CIRCLE, cons);
    });
    private static final List<WeightedEntry.Wrapper<GoalAttackAction<EntityRafflesia>>> ATTACKS = List.of(WeightedEntry.m_146290_((Object)new GoalAttackAction(POISON_BREATH).cooldown(e -> e.animationCooldown(POISON_BREATH)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(POISON_BREATH_REV).cooldown(e -> e.animationCooldown(POISON_BREATH_REV)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(PARA_BREATH).cooldown(e -> e.animationCooldown(PARA_BREATH)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(PARA_BREATH_REV).cooldown(e -> e.animationCooldown(PARA_BREATH_REV)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(SLEEP_BREATH).cooldown(e -> e.animationCooldown(SLEEP_BREATH)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(SLEEP_BREATH_REV).cooldown(e -> e.animationCooldown(SLEEP_BREATH_REV)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), WeightedEntry.m_146290_((Object)new GoalAttackAction(WIND_BLADE_X8).cooldown(e -> e.animationCooldown(WIND_BLADE_X8)).withCondition((goal, target, previous) -> !((EntityRafflesia)goal.attacker).isEnraged()).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)new GoalAttackAction(WIND_BLADE_X16).cooldown(e -> e.animationCooldown(WIND_BLADE_X16)).withCondition((goal, target, previous) -> ((EntityRafflesia)goal.attacker).isEnraged()).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)new GoalAttackAction(STATUS_CIRCLE).cooldown(e -> e.animationCooldown(STATUS_CIRCLE)).withCondition((goal, target, previous) -> ((EntityRafflesia)goal.attacker).isEnraged()).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), WeightedEntry.m_146290_((Object)new GoalAttackAction(RESUMMON).cooldown(e -> e.animationCooldown(RESUMMON)).withCondition((goal, target, previous) -> ((EntityRafflesia)goal.attacker).getHorseTail() == null || ((EntityRafflesia)goal.attacker).getPitcher() == null || ((EntityRafflesia)goal.attacker).getFlower() == null).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)7));
    private static final List<WeightedEntry.Wrapper<IdleAction<EntityRafflesia>>> IDLE_ACTIONS = List.of(WeightedEntry.m_146290_((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntityRafflesia> attack2 = new AnimatedAttackGoal((PathfinderMob)this, ATTACKS, IDLE_ACTIONS);
    private boolean mirrorAttack;
    private final AnimationHandler<EntityRafflesia> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.f_19853_.f_46443_) {
            this.mirrorAttack = EntityRafflesia.isMirrorAttack(anim);
        }
        return false;
    });
    private EntityRafflesiaPart horseTailEntity;
    private EntityRafflesiaPart flowerEntity;
    private EntityRafflesiaPart pitcherEntity;
    private int summonCooldown = 100;

    public EntityRafflesia(EntityType<? extends EntityRafflesia> type, Level world) {
        super((EntityType<? extends BossMonster>)type, world);
        if (!world.f_46443_) {
            this.f_21345_.m_25352_(1, this.attack2);
        }
    }

    public static Vec3 rotateVec(Direction dir, Vec3 v) {
        return switch (dir) {
            case Direction.NORTH -> v.m_82542_(-1.0, 1.0, -1.0);
            case Direction.EAST -> new Vec3(v.m_7094_(), v.m_7098_(), -v.m_7096_());
            case Direction.WEST -> new Vec3(-v.m_7094_(), v.m_7098_(), -v.m_7096_());
            default -> v;
        };
    }

    public static boolean isMirrorAttack(AnimatedAction anim) {
        return anim != null && anim.is(new AnimatedAction[]{POISON_BREATH_REV, PARA_BREATH_REV, SLEEP_BREATH_REV});
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)ModSounds.RAFFLESIA_FIGHT.get());
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level){

            @Nullable
            protected Path m_148222_(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return null;
            }
        };
    }

    public void useAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{RESUMMON})) {
            this.respawnParts();
        }
        if (anim.is(new AnimatedAction[]{WIND_BLADE_X8})) {
            ((Spell)((Object)ModSpells.WIND_CIRCLE_X8.get())).use((LivingEntity)this);
        }
        if (anim.is(new AnimatedAction[]{WIND_BLADE_X16})) {
            ((Spell)((Object)ModSpells.WIND_CIRCLE_X16.get())).use((LivingEntity)this);
        }
        if (anim.is(new AnimatedAction[]{POISON_BREATH, POISON_BREATH_REV})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_POISON.get())).use((LivingEntity)this);
        }
        if (anim.is(new AnimatedAction[]{PARA_BREATH, PARA_BREATH_REV})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_PARA.get())).use((LivingEntity)this);
        }
        if (anim.is(new AnimatedAction[]{SLEEP_BREATH, SLEEP_BREATH_REV})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_SLEEP.get())).use((LivingEntity)this);
        }
        if (anim.is(new AnimatedAction[]{STATUS_CIRCLE})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_CIRCLE.get())).use((LivingEntity)this);
        }
    }

    @Override
    protected void applyAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        super.applyAttributes();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HORSE_TAIL, Optional.empty());
        this.f_19804_.m_135372_(FLOWER, Optional.empty());
        this.f_19804_.m_135372_(PITCHER, Optional.empty());
        this.f_19804_.m_135372_(SPAWN_DIRECTION, (Object)Direction.NORTH);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ((Optional)this.f_19804_.m_135370_(HORSE_TAIL)).ifPresent(uuid -> compound.m_128362_("HeadBones", uuid));
        ((Optional)this.f_19804_.m_135370_(FLOWER)).ifPresent(uuid -> compound.m_128362_("Flower", uuid));
        ((Optional)this.f_19804_.m_135370_(PITCHER)).ifPresent(uuid -> compound.m_128362_("Pitcher", uuid));
        compound.m_128405_("SpawnDirection", ((Direction)this.f_19804_.m_135370_(SPAWN_DIRECTION)).ordinal());
        compound.m_128405_("SummonCooldown", this.summonCooldown);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("HorseTail")) {
            this.f_19804_.m_135381_(HORSE_TAIL, Optional.of(compound.m_128342_("HorseTail")));
        }
        if (compound.m_128403_("Flower")) {
            this.f_19804_.m_135381_(FLOWER, Optional.of(compound.m_128342_("Flower")));
        }
        if (compound.m_128403_("Pitcher")) {
            this.f_19804_.m_135381_(PITCHER, Optional.of(compound.m_128342_("Pitcher")));
        }
        try {
            this.f_19804_.m_135381_(SPAWN_DIRECTION, (Object)Direction.values()[compound.m_128451_("SpawnDirection")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.summonCooldown = compound.m_128451_("SummonCooldown");
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.f_19804_.m_135381_(SPAWN_DIRECTION, (Object)this.m_6350_());
        this.respawnParts();
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19853_.f_46443_) {
            LivingEntity target = this.m_5448_();
            if (target != null && !this.getAnimationHandler().hasAnimation()) {
                this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            if (this.summonCooldown < 200 && this.getHorseTail() == null || this.getPitcher() == null || this.getFlower() == null) {
                this.summonCooldown = this.f_19796_.nextInt(200) + 300;
            }
            if (this.f_19797_ % 30 == 0) {
                this.f_19853_.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), this.m_142469_().m_82400_(0.3).m_82386_(0.0, (double)this.m_20206_(), 0.0), e -> e != this && this.targetPred.test(e)).forEach(e -> {
                    Vec3 dir = e.m_20182_().m_82546_(this.m_20182_());
                    boolean none = dir.m_7096_() == 0.0 && dir.m_7094_() == 0.0;
                    dir = new Vec3(none ? 1.0 : dir.m_7096_(), 0.0, dir.m_7094_()).m_82541_().m_82490_(1.2);
                    e.m_20256_(e.m_20184_().m_82549_(dir));
                    e.f_19864_ = true;
                });
            }
        }
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.setTargetPosition(target);
        } else {
            this.setTargetPosition(MobAttackExt.TargetPosition.of(this.m_20182_().m_82549_(this.m_20154_().m_82490_(5.0))));
        }
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public Direction getSpawnDirection() {
        return (Direction)this.f_19804_.m_135370_(SPAWN_DIRECTION);
    }

    private void respawnParts() {
        Direction dir = (Direction)this.f_19804_.m_135370_(SPAWN_DIRECTION);
        if (this.getHorseTail() == null) {
            EntityRafflesiaHorseTail horseTail = new EntityRafflesiaHorseTail(this.f_19853_, this);
            horseTail.setSpawnDirection(dir);
            horseTail.m_146884_(this.m_20182_().m_82549_(EntityRafflesia.rotateVec(dir, horseTail.offset())));
            this.f_19853_.m_7967_((Entity)horseTail);
            this.f_19804_.m_135381_(HORSE_TAIL, Optional.of(horseTail.m_142081_()));
        }
        if (this.getFlower() == null) {
            EntityRafflesiaFlower flower = new EntityRafflesiaFlower(this.f_19853_, this);
            flower.setSpawnDirection(dir);
            flower.m_146884_(this.m_20182_().m_82549_(EntityRafflesia.rotateVec(dir, flower.offset())));
            this.f_19853_.m_7967_((Entity)flower);
            this.f_19804_.m_135381_(FLOWER, Optional.of(flower.m_142081_()));
        }
        if (this.getPitcher() == null) {
            EntityRafflesiaPitcher pitcher = new EntityRafflesiaPitcher(this.f_19853_, this);
            pitcher.setSpawnDirection(dir);
            pitcher.m_146884_(this.m_20182_().m_82549_(EntityRafflesia.rotateVec(dir, pitcher.offset())));
            this.f_19853_.m_7967_((Entity)pitcher);
            this.f_19804_.m_135381_(PITCHER, Optional.of(pitcher.m_142081_()));
        }
        this.summonCooldown = this.f_19796_.nextInt(200) + 300;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY}) && super.m_6469_(source, amount);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEATH;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.m_6688_(), command == 1 ? (Spell)((Object)ModSpells.RAFFLESIA_POISON.get()) : (Spell)((Object)ModSpells.RAFFLESIA_PARA.get()))) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(POISON_BREATH);
            } else {
                this.getAnimationHandler().setAnimation(PARA_BREATH);
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public boolean m_5829_() {
        return true;
    }

    public AnimationHandler<EntityRafflesia> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return DEATH;
    }

    public EntityRafflesiaPart getHorseTail() {
        UUID uuid = ((Optional)this.f_19804_.m_135370_(HORSE_TAIL)).orElse(null);
        if (uuid != null) {
            if (this.horseTailEntity == null) {
                this.horseTailEntity = (EntityRafflesiaPart)EntityUtil.findFromUUID(EntityRafflesiaPart.class, (Level)this.f_19853_, (UUID)uuid);
            } else if (this.horseTailEntity.m_146910_()) {
                this.horseTailEntity = null;
                this.f_19804_.m_135381_(HORSE_TAIL, Optional.empty());
            }
        } else {
            this.horseTailEntity = null;
        }
        return this.horseTailEntity;
    }

    public EntityRafflesiaPart getFlower() {
        UUID uuid = ((Optional)this.f_19804_.m_135370_(FLOWER)).orElse(null);
        if (uuid != null) {
            if (this.flowerEntity == null) {
                this.flowerEntity = (EntityRafflesiaPart)EntityUtil.findFromUUID(EntityRafflesiaPart.class, (Level)this.f_19853_, (UUID)uuid);
            } else if (this.flowerEntity.m_146910_()) {
                this.flowerEntity = null;
                this.f_19804_.m_135381_(FLOWER, Optional.empty());
            }
        } else {
            this.flowerEntity = null;
        }
        return this.flowerEntity;
    }

    public EntityRafflesiaPart getPitcher() {
        UUID uuid = ((Optional)this.f_19804_.m_135370_(PITCHER)).orElse(null);
        if (uuid != null) {
            if (this.pitcherEntity == null) {
                this.pitcherEntity = (EntityRafflesiaPart)EntityUtil.findFromUUID(EntityRafflesiaPart.class, (Level)this.f_19853_, (UUID)uuid);
            } else if (this.pitcherEntity.m_146910_()) {
                this.pitcherEntity = null;
                this.f_19804_.m_135381_(PITCHER, Optional.empty());
            }
        } else {
            this.pitcherEntity = null;
        }
        return this.pitcherEntity;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENTITY_RAFFLESIA_DEATH.get();
    }

    @Override
    public void playAngrySound() {
        this.m_5496_((SoundEvent)ModSounds.ENTITY_RAFFLESIA_ANGRY.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean mirrorAttack() {
        return this.mirrorAttack;
    }

    @Override
    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, 2.6875, 0.21875);
    }
}

