/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import io.github.flemmli97.runecraftory.common.entities.ai.RafflesiaPartAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesia;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class EntityRafflesiaPart
extends Mob
implements IAnimated,
OwnableEntity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT = SynchedEntityData.m_135353_(EntityRafflesiaPart.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Direction> SPAWN_DIRECTION = SynchedEntityData.m_135353_(EntityRafflesiaPart.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static final AnimatedAction HORSE_TAIL_ACTION = AnimatedAction.builder((double)1.28, (String)"horse_tail_action").marker("attack", new double[]{0.56}).build();
    public static final AnimatedAction FLOWER_ACTION = AnimatedAction.builder((double)1.0, (String)"flower_action").marker("attack", new double[]{0.4456}).build();
    public static final AnimatedAction PITCHER_ACTION = AnimatedAction.builder((double)0.96, (String)"pitcher_action").marker("attack", new double[]{0.4}).build();
    public final RafflesiaPartAttackGoal attack = new RafflesiaPartAttackGoal(this);
    private EntityRafflesia parent;

    public EntityRafflesiaPart(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        if (!level.f_46443_) {
            this.f_21345_.m_25352_(1, (Goal)this.attack);
        }
    }

    public EntityRafflesiaPart(EntityType<? extends Mob> entityType, Level level, EntityRafflesia parent) {
        this(entityType, level);
        this.parent = parent;
        this.f_19804_.m_135381_(PARENT, Optional.of(this.parent.m_142081_()));
        this.m_21204_().m_22168_(parent.m_21204_().m_22180_());
        double health = parent.m_21133_(Attributes.f_22276_) * 0.5;
        this.m_21051_(Attributes.f_22276_).m_22100_(health);
        this.m_21153_(this.m_21233_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder map = Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 32.0);
        for (RegistryEntrySupplier<Attribute> att : ModAttributes.ENTITY_ATTRIBUTES) {
            map.m_22266_((Attribute)att.get());
        }
        return map;
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation(this, level){

            @Nullable
            protected Path m_148222_(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return null;
            }
        };
    }

    public void m_6075_() {
        if (!this.f_19853_.f_46443_ && !this.f_19803_) {
            if (this.getOwner() != null) {
                if (this.getOwner().m_21224_() || this.getPartType().getPart.apply(this.getOwner()) != this) {
                    this.m_146870_();
                } else {
                    if (this.m_5448_() != this.getOwner().m_5448_()) {
                        this.m_6710_(this.getOwner().m_5448_());
                    }
                    this.m_146884_(this.getOwner().m_20182_().m_82549_(EntityRafflesia.rotateVec((Direction)this.f_19804_.m_135370_(SPAWN_DIRECTION), this.offset())));
                }
            } else if (this.m_142504_() == null) {
                this.m_146870_();
            }
        }
        super.m_6075_();
        this.getAnimationHandler().tick();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARENT, Optional.empty());
        this.f_19804_.m_135372_(SPAWN_DIRECTION, (Object)Direction.NORTH);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ((Optional)this.f_19804_.m_135370_(PARENT)).ifPresent(uuid -> compound.m_128362_("Parent", uuid));
        compound.m_128405_("SpawnDirection", ((Direction)this.f_19804_.m_135370_(SPAWN_DIRECTION)).ordinal());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Parent")) {
            this.f_19804_.m_135381_(PARENT, Optional.of(compound.m_128342_("Parent")));
        }
        try {
            this.f_19804_.m_135381_(SPAWN_DIRECTION, (Object)Direction.values()[compound.m_128451_("SpawnDirection")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setSpawnDirection(Direction direction) {
        this.f_19804_.m_135381_(SPAWN_DIRECTION, (Object)direction);
    }

    public boolean m_5829_() {
        return true;
    }

    @Nullable
    public UUID m_142504_() {
        return ((Optional)this.f_19804_.m_135370_(PARENT)).orElse(null);
    }

    @Nullable
    public EntityRafflesia getOwner() {
        UUID uuid = this.m_142504_();
        if (uuid != null) {
            if (this.parent == null || !this.parent.m_6084_()) {
                this.parent = (EntityRafflesia)EntityUtil.findFromUUID(EntityRafflesia.class, (Level)this.f_19853_, (UUID)uuid);
            }
        } else {
            this.parent = null;
        }
        return this.parent;
    }

    public abstract Vec3 offset();

    public abstract AnimatedAction attackAnim();

    public int cooldown() {
        return this.m_21187_().nextInt(40) + 100;
    }

    public abstract PartType getPartType();

    public static enum PartType {
        FLOWER(EntityRafflesia::getFlower),
        HORSETAIL(EntityRafflesia::getHorseTail),
        PITCHER(EntityRafflesia::getPitcher);

        private final Function<EntityRafflesia, Entity> getPart;

        private PartType(Function<EntityRafflesia, Entity> getPart) {
            this.getPart = getPart;
        }
    }
}

