/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesia;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaPart;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;

public class EntityRafflesiaPitcher
extends EntityRafflesiaPart {
    private static final Vec3 OFFSET = new Vec3(-1.0, 0.0, 0.2);
    private final AnimationHandler<EntityRafflesiaPitcher> animationHandler = new AnimationHandler((Entity)this, new AnimatedAction[]{EntityRafflesiaPart.PITCHER_ACTION});

    public EntityRafflesiaPitcher(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public EntityRafflesiaPitcher(Level level, EntityRafflesia parent) {
        super((EntityType<? extends Mob>)((EntityType)ModEntities.RAFFLESIA_PITCHER.get()), level, parent);
    }

    public static void rafflesiaSpawning(EntityRafflesiaPart part) {
        if (part.f_19853_.f_46443_ || part.getOwner() == null) {
            return;
        }
        List nearby = part.f_19853_.m_142425_(EntityTypeTest.m_156916_(Mob.class), part.getOwner().arenaAABB(), m -> {
            if (!m.m_6095_().m_204039_(RunecraftoryTags.RAFFLESIA_SUMMONS)) {
                return false;
            }
            if (m instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)m;
                Player player = null;
                if (part.getOwner() != null) {
                    if (part.getOwner().m_142504_() == null) {
                        return true;
                    }
                    player = part.getOwner().getOwner();
                }
                if (player != null) {
                    return player.m_142081_().equals(ownableEntity.m_142504_());
                }
            }
            return true;
        });
        if (nearby.size() < 5) {
            int rand = 1 + (part.m_21187_().nextBoolean() ? 1 : 0);
            BlockPos summonPos = part.m_142538_();
            for (int i = 0; i < rand; ++i) {
                BlockPos pos = summonPos.m_142082_(part.m_21187_().nextInt(8) - 4, part.m_21187_().nextInt(2), part.m_21187_().nextInt(8) - 4);
                Optional opt = Registry.f_122826_.m_203431_(RunecraftoryTags.RAFFLESIA_SUMMONS).flatMap(named -> named.m_203450_(part.m_21187_()).map(Holder::m_203334_));
                opt.ifPresent(type -> {
                    ServerLevel serverLevel = (ServerLevel)part.f_19853_;
                    Entity e = type.m_20655_(serverLevel, null, null, null, pos, MobSpawnType.MOB_SUMMONED, true, true);
                    if (e != null) {
                        Object mob;
                        EntityRafflesia owner = part.getOwner();
                        if (e instanceof Mob) {
                            mob = (Mob)e;
                            mob.m_6710_(part.m_5448_());
                            if (owner != null && owner.m_21536_()) {
                                mob.m_21446_(owner.m_142538_(), (int)owner.m_21535_() + 1);
                            }
                        }
                        if (e instanceof IBaseMob) {
                            mob = (IBaseMob)e;
                            if (owner != null) {
                                int level = part.getOwner().level().getLevel();
                                mob.setLevel(level + (int)((part.m_21187_().nextDouble() - 0.5) * (double)level * 0.1));
                            }
                        }
                        for (int p = 0; p < 5; ++p) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, e.m_20208_(1.0), e.m_20187_(), e.m_20262_(1.0), 1, serverLevel.m_5822_().nextGaussian() * 0.1, serverLevel.m_5822_().nextGaussian() * 0.1, serverLevel.m_5822_().nextGaussian() * 0.1, 0.0);
                        }
                        part.f_19853_.m_7967_(e);
                    }
                });
            }
        }
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19853_.f_46443_) {
            this.getAnimationHandler().runIfNotNull(anim -> {
                if (anim.isAt("attack")) {
                    EntityRafflesiaPitcher.rafflesiaSpawning(this);
                }
            });
        }
    }

    @Override
    public Vec3 offset() {
        return OFFSET;
    }

    @Override
    public AnimatedAction attackAnim() {
        return EntityRafflesiaPart.PITCHER_ACTION;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public int cooldown() {
        return this.m_21187_().nextInt(60) + 120;
    }

    @Override
    public EntityRafflesiaPart.PartType getPartType() {
        return EntityRafflesiaPart.PartType.PITCHER;
    }
}

