/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.utils.DailyEntityUpdater;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class DailyNPCUpdater
extends DailyEntityUpdater<EntityNPCBase> {
    private int bread;
    private final Set<UUID> acceptedRandomQuest = new HashSet<UUID>();

    public DailyNPCUpdater(EntityNPCBase entity) {
        super(entity);
        this.bread = entity.m_21187_().nextInt(4) + 1;
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        this.bread = ((EntityNPCBase)this.entity).m_21187_().nextInt(4) + 1;
        this.acceptedRandomQuest.clear();
    }

    public void acceptRandomQuest(ServerPlayer player) {
        this.acceptedRandomQuest.add(player.m_142081_());
    }

    public boolean alreadyAcceptedRandomquest(ServerPlayer player) {
        return this.acceptedRandomQuest.contains(player.m_142081_());
    }

    public int getBreadToBuy() {
        return this.bread;
    }

    public void onBuyBread() {
        --this.bread;
    }

    @Override
    public CompoundTag save() {
        CompoundTag tag = super.save();
        tag.m_128405_("Bread", this.bread);
        ListTag quests = new ListTag();
        this.acceptedRandomQuest.forEach(uuid -> quests.add((Object)StringTag.m_129297_((String)uuid.toString())));
        tag.m_128365_("AcceptedRandomQuests", (Tag)quests);
        return tag;
    }

    @Override
    public void read(CompoundTag compound) {
        super.read(compound);
        this.bread = compound.m_128451_("Bread");
        ListTag quests = compound.m_128437_("AcceptedRandomQuests", 8);
        quests.forEach(t -> this.acceptedRandomQuest.add(UUID.fromString(t.m_7916_())));
    }
}

