/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCDataManager;
import io.github.flemmli97.runecraftory.common.entities.ai.AvoidWhenNotFollowing;
import io.github.flemmli97.runecraftory.common.entities.ai.LookAtAliveGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.LookAtInteractingPlayerGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.RandomLookGoalAlive;
import io.github.flemmli97.runecraftory.common.entities.ai.StayGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCFindPOI;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCFollowGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.actions.NPCAttackActions;
import io.github.flemmli97.runecraftory.common.entities.npc.DailyNPCUpdater;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityWeaponHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCFriendPoints;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCRelationManager;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCSchedule;
import io.github.flemmli97.runecraftory.common.entities.npc.PlaceHolderComponent;
import io.github.flemmli97.runecraftory.common.entities.npc.QuestConversationContext;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SizeFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.entities.pathing.NPCWalkNodeEvaluator;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShop;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerShop;
import io.github.flemmli97.runecraftory.common.items.BabySpawnEgg;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemObjectX;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.network.S2CEntityLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CNPCLook;
import io.github.flemmli97.runecraftory.common.network.S2CNpcDialogue;
import io.github.flemmli97.runecraftory.common.network.S2COpenNPCGui;
import io.github.flemmli97.runecraftory.common.network.S2CUpdateNPCData;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.NPCTalkTracker;
import io.github.flemmli97.runecraftory.common.registry.ModActivities;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.NPCHandler;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.family.FamilyEntry;
import io.github.flemmli97.runecraftory.common.world.family.FamilyHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.quest.QuestState;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EntityNPCBase
extends AgeableMob
implements Npc,
IBaseMob,
IAnimated,
TargetableOpponent,
MobAttackExt {
    public static final float PATH_FIND_LENGTH = 100.0f;
    private static final EntityDataAccessor<Boolean> PLAY_DEATH_STATE = SynchedEntityData.m_135353_(EntityNPCBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHOP_SYNC = SynchedEntityData.m_135353_(EntityNPCBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.m_135353_(EntityNPCBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BEHAVIOUR_DATA = SynchedEntityData.m_135353_(EntityNPCBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26360_, (Object)MemoryModuleType.f_26362_, (Object)MemoryModuleType.f_26379_, (Object)MemoryModuleType.f_26324_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_);
    public static final AnimatedAction[] ANIMS = PlayerModelAnimations.getAll().toArray(new AnimatedAction[0]);
    private final AnimationHandler<EntityNPCBase> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (this.m_5448_() != null) {
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 90.0f);
            this.targetPosition = MobAttackExt.TargetPosition.of(this.m_5448_());
        }
        return false;
    });
    public final Predicate<LivingEntity> targetPred = e -> {
        if (e != this) {
            OwnableEntity ownable;
            if (this.followEntity() == null) {
                return false;
            }
            if (e instanceof OwnableEntity && (ownable = (OwnableEntity)e).m_142504_() != null) {
                return false;
            }
            if (e instanceof Mob && this == ((Mob)e).m_5448_()) {
                return true;
            }
            return e instanceof Enemy;
        }
        return false;
    };
    public final Predicate<LivingEntity> hitPred = e -> {
        if (e != this) {
            Mob mob;
            if (e == this.m_5448_() || e instanceof Mob && this == (mob = (Mob)e).m_5448_()) {
                return true;
            }
            if (this.m_20363_((Entity)e) || !e.m_142066_()) {
                return false;
            }
            Player follow = this.followEntity();
            if (follow != null && e instanceof OwnableEntity) {
                OwnableEntity ownable = (OwnableEntity)e;
                if (follow.m_142081_().equals(ownable.m_142504_())) {
                    return false;
                }
            }
            return e instanceof Enemy;
        }
        return false;
    };
    public NearestAttackableTargetGoal<Mob> targetMobs = new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, this.targetPred);
    public NPCWanderGoal wander = new NPCWanderGoal(this);
    public HurtByTargetGoal hurt = new HurtByTargetGoal((PathfinderMob)this, new Class[0]);
    private final LevelExpPair levelPair = new LevelExpPair();
    private NPCJob shop = (NPCJob)ModNPCJobs.NONE.getSecond();
    public boolean ignoreInit;
    private NPCData data = NPCData.DEFAULT_DATA;
    private NPCLook look = NPCLook.DEFAULT_LOOK;
    public final NPCFeatureContainer lookFeatures = new NPCFeatureContainer();
    private NPCAttackActions attackActions = NPCAttackActions.DEFAULT;
    private Pair<EnumSeason, Integer> birthday = Pair.of((Object)((Object)EnumSeason.SPRING), (Object)1);
    private Map<String, GiftData> gifts;
    private final Random dataRandom = new Random();
    private Activity activity = Activity.f_37979_;
    private int foodBuffTick;
    private int playDeathTick;
    private final NPCRelationManager relationManager = new NPCRelationManager();
    private int procreationCooldown;
    private int procreationProgress;
    private Entity procreationEntity;
    private Behaviour behaviour = Behaviour.WANDER;
    private Player entityToFollow;
    private UUID entityToFollowUUID;
    private int sleepCooldown;
    private int tpCooldown;
    private final List<ServerPlayer> interactingPlayers = new ArrayList<ServerPlayer>();
    private int interactionMoveCooldown;
    private final NPCSchedule schedule;
    private BlockPos prevRestriction = BlockPos.f_121853_;
    private int prevRestrictionRadius = -1;
    public final DailyNPCUpdater updater = new DailyNPCUpdater(this);
    public final AttackActionHandler weaponHandler = new EntityWeaponHandler<EntityNPCBase>(this);
    private MobAttackExt.TargetPosition targetPosition;

    public EntityNPCBase(EntityType<? extends EntityNPCBase> type, Level level) {
        super(type, level);
        this.levelPair.setLevel(1, LevelCalc::xpAmountForLevelUp);
        this.applyAttributes(true);
        if (!level.f_46443_) {
            this.addGoal();
        }
        this.schedule = new NPCSchedule(this, this.m_21187_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder map = Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22277_, 32.0);
        for (RegistryEntrySupplier<Attribute> att : ModAttributes.ENTITY_ATTRIBUTES) {
            map.m_22266_((Attribute)att.get());
        }
        for (RegistryEntrySupplier<Attribute> att : ModAttributes.PLAYER_ATTRIBUTES) {
            map.m_22266_((Attribute)att.get());
        }
        map.m_22268_((Attribute)ModAttributes.ATTACK_RANGE.get(), 1.5);
        return map;
    }

    protected void applyAttributes(boolean regenHealth) {
        if (this.data != null && this.data.baseStats() != null) {
            this.data.baseStats().forEach((att, d) -> {
                AttributeInstance inst = this.m_21051_((Attribute)att);
                if (inst != null) {
                    inst.m_22100_(d.doubleValue());
                    if (regenHealth && att == Attributes.f_22276_) {
                        this.m_21153_(this.m_21233_());
                    }
                }
            });
            return;
        }
        AttributeInstance inst = this.m_21051_(Attributes.f_22276_);
        if (inst != null) {
            inst.m_22100_(20.0);
            if (regenHealth) {
                this.m_21153_(this.m_21233_());
            }
        }
        if ((inst = this.m_21051_(Attributes.f_22281_)) != null) {
            inst.m_22100_(1.0);
        }
        if ((inst = this.m_21051_((Attribute)ModAttributes.DEFENCE.get())) != null) {
            inst.m_22100_(0.0);
        }
        if ((inst = this.m_21051_((Attribute)ModAttributes.MAGIC.get())) != null) {
            inst.m_22100_(5.0);
        }
        if ((inst = this.m_21051_((Attribute)ModAttributes.MAGIC_DEFENCE.get())) != null) {
            inst.m_22100_(0.0);
        }
    }

    public void recalcStatsFull() {
        this.applyAttributes(true);
    }

    public void addGoal() {
        this.f_21346_.m_25352_(1, this.targetMobs);
        this.f_21346_.m_25352_(0, (Goal)this.hurt);
        this.f_21345_.m_25352_(0, (Goal)new NPCFindPOI(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, new StayGoal<EntityNPCBase>(this, StayGoal.CANSTAYNPC));
        this.f_21345_.m_25352_(1, (Goal)new AvoidWhenNotFollowing(this, LivingEntity.class, 8.0f, 1.3, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new LookAtInteractingPlayerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtAliveGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookGoalAlive((Mob)this));
        this.f_21345_.m_25352_(2, new NPCAttackGoal<EntityNPCBase>(this));
        this.f_21345_.m_25352_(3, (Goal)new NPCFollowGoal(this, 1.15, 9.0f, 3.0f, 20.0f));
        this.f_21345_.m_25352_(4, (Goal)this.wander);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLAY_DEATH_STATE, (Object)false);
        this.f_19804_.m_135372_(SHOP_SYNC, (Object)0);
        this.f_19804_.m_135372_(MALE, (Object)false);
        this.f_19804_.m_135372_(BEHAVIOUR_DATA, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_) {
            if (key.equals(SHOP_SYNC)) {
                try {
                    this.shop = ModNPCJobs.getFromSyncID((Integer)this.f_19804_.m_135370_(SHOP_SYNC));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (key.equals(BEHAVIOUR_DATA)) {
                try {
                    this.behaviour = Behaviour.values()[(Integer)this.f_19804_.m_135370_(BEHAVIOUR_DATA)];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    protected Brain.Provider<?> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, (Collection)ImmutableList.of());
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation nav = new GroundPathNavigation((Mob)this, level){

            @Nullable
            protected Path m_26551_(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy) {
                return this.m_148222_(targets, regionOffset, offsetUpward, accuracy, 100.0f);
            }

            protected PathFinder m_5532_(int i) {
                this.f_26508_ = new NPCWalkNodeEvaluator();
                this.f_26508_.m_77351_(true);
                return new PathFinder(this.f_26508_, i);
            }
        };
        nav.m_26477_(true);
        return nav;
    }

    public void m_8119_() {
        if (this.f_19803_ && this.m_20194_() != null) {
            NPCHandler handler = WorldHandler.get((MinecraftServer)this.m_20194_()).npcHandler;
            handler.addNPC(this);
            handler.playersToReset(this.m_142081_()).forEach(pair -> this.relationManager.resetQuest((UUID)pair.getFirst(), (ResourceLocation)pair.getSecond()));
        }
        super.m_8119_();
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.f_19853_.f_46443_ && (double)this.m_21223_() > 0.02) {
                this.setPlayDeath(false);
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 10 == 0) {
                this.interactingPlayers.removeIf(p -> p.m_20280_((Entity)this) > 100.0);
            }
            --this.interactionMoveCooldown;
            this.updater.tick();
            this.updateActivity();
            this.foodBuffTick = Math.max(-1, --this.foodBuffTick);
            if (this.foodBuffTick == 0) {
                this.removeFoodEffect();
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            --this.sleepCooldown;
            if (this.m_21257_().map(pos -> !pos.m_203195_((Position)this.m_20182_(), 1.0) || this.getActivity() != Activity.f_37982_).orElse(false).booleanValue()) {
                this.m_5796_();
            }
        }
        if (this.getAnimationHandler().getAnimation() == null) {
            this.targetPosition = null;
        }
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
        this.getAnimationHandler().tick();
        this.weaponHandler.tick();
        boolean teleported = false;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            Player follow;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.behaviourState().following && --this.tpCooldown <= 0 && (follow = this.followEntity()) != null) {
                serverLevel.m_7726_().m_8387_(WorldUtils.ENTITY_LOADER, this.m_146902_(), 3, (Object)this.m_146902_());
                if (follow.f_19853_.m_46472_() != this.f_19853_.m_46472_()) {
                    TeleportUtils.safeDimensionTeleport((Mob)this, (ServerLevel)follow.f_19853_, follow.m_142538_());
                    teleported = true;
                    this.tpCooldown = 20;
                } else if (follow.m_20280_((Entity)this) > 450.0) {
                    TeleportUtils.tryTeleportAround((Mob)this, (Entity)follow);
                    teleported = true;
                    this.tpCooldown = 20;
                }
            }
            --this.procreationCooldown;
            if (this.procreationProgress > 0) {
                this.m_21573_().m_26573_();
                --this.procreationProgress;
                if (this.f_19797_ % 10 == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.procreationProgress == 0) {
                    if (this.spawnBaby()) {
                        this.procreationCooldown = MobConfig.procreationCooldown;
                    }
                    this.procreationEntity = null;
                }
            }
        }
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.f_19853_.f_46443_) {
                if (teleported) {
                    this.m_5634_(1.0f);
                }
                if ((double)this.m_21223_() > 0.02) {
                    this.setPlayDeath(false);
                }
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (this.m_20194_() != null) {
            this.getFamily().updateName((Entity)this);
            WorldHandler.get((MinecraftServer)this.m_20194_()).npcHandler.addNPC(this);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.m_5803_()) {
            return InteractionResult.CONSUME;
        }
        if (this.getEntityToFollowUUID() != null && this.getEntityToFollowUUID().equals(serverPlayer.m_142081_())) {
            EntityUtils.sendAttributesTo((LivingEntity)this, serverPlayer);
        }
        Platform.INSTANCE.sendToClient(new S2CUpdateNPCData(this, this.relationManager.getFriendPointData(player.m_142081_()).save()), serverPlayer);
        Platform.INSTANCE.sendToClient(new S2COpenNPCGui(this, serverPlayer), serverPlayer);
        this.interactWithPlayer(serverPlayer);
        this.m_21391_((Entity)serverPlayer, 30.0f, 30.0f);
        return InteractionResult.CONSUME;
    }

    @Nullable
    public ItemStack m_142340_() {
        return SpawnEgg.fromType((EntityType)this.m_6095_()).map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    public void m_7822_(byte id) {
        if (id == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        } else if (id == 15) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123810_);
        } else {
            super.m_7822_(id);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions particleData) {
        for (int i = 0; i < 5; ++i) {
            double d = this.f_19796_.nextGaussian() * 0.02;
            double e = this.f_19796_.nextGaussian() * 0.02;
            double f = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_(particleData, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d, e, f);
        }
    }

    public void giftItem(Player player, ItemStack stack) {
        EquipmentSlot slot;
        SoundEvent sound;
        this.m_21391_((Entity)player, 30.0f, 30.0f);
        int count = stack.m_41613_();
        switch (stack.m_41780_()) {
            case DRINK: {
                SoundEvent soundEvent = stack.m_41615_();
                break;
            }
            case EAT: {
                SoundEvent soundEvent = stack.m_41616_();
                break;
            }
            default: {
                SoundEvent soundEvent = sound = SoundEvents.f_12216_;
            }
        }
        if (stack.m_41720_() == ModItems.DIVORCE_PAPER.get()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FamilyEntry family = this.getFamily();
                if (player.m_142081_().equals(family.getPartner())) {
                    this.speak(serverPlayer, ConversationContext.DIVORCE);
                    family.updateRelationship(FamilyEntry.Relationship.NONE, null);
                    this.relationManager.getFriendPointData((UUID)player.m_142081_()).points.addXP(-2000.0f, 10, LevelCalc::friendPointsForNext, () -> {});
                } else {
                    this.speak(serverPlayer, ConversationContext.DIVORCE_ERROR);
                }
                stack.m_41774_(1);
            }
            return;
        }
        if (stack.m_41720_() == ModItems.LOVE_LETTER.get()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FamilyHandler families = FamilyHandler.get(this.m_20194_());
                FamilyEntry playerEntry = families.getOrCreateEntry((Player)serverPlayer);
                FamilyEntry family = families.getOrCreateEntry(this);
                boolean success = false;
                if (playerEntry.getRelationship() != FamilyEntry.Relationship.NONE || family.getRelationship() != FamilyEntry.Relationship.NONE) {
                    this.speak(serverPlayer, ConversationContext.DATING_DENY);
                } else {
                    float chance;
                    float f = chance = this.friendPoints(player) >= 7 ? 0.33f * (float)(this.friendPoints(player) - 6) : 0.0f;
                    if (chance > 0.0f && this.updater.getDailyRandom().nextFloat() < chance) {
                        this.speak(serverPlayer, ConversationContext.DATING_ACCEPT);
                        family.updateRelationship(FamilyEntry.Relationship.DATING, player.m_142081_());
                        success = true;
                    } else {
                        this.speak(serverPlayer, ConversationContext.DATING_DENY);
                    }
                }
                if (!success) {
                    player.m_36356_(stack);
                } else {
                    stack.m_41774_(1);
                }
            }
            return;
        }
        if (stack.m_41720_() == ModItems.ENGAGEMENT_RING.get()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FamilyHandler families = FamilyHandler.get(this.m_20194_());
                FamilyEntry playerEntry = families.getOrCreateEntry((Player)serverPlayer);
                FamilyEntry family = families.getOrCreateEntry(this);
                boolean success = false;
                if (playerEntry.getRelationship() != FamilyEntry.Relationship.NONE && !this.m_142081_().equals(playerEntry.getPartner()) || family.getPartner() == null || !family.getPartner().equals(player.m_142081_())) {
                    this.speak(serverPlayer, ConversationContext.MARRIAGE_DENY);
                } else if (family.getRelationship() == FamilyEntry.Relationship.DATING) {
                    float chance;
                    float f = chance = this.friendPoints(player) >= 10 ? 0.2f * (float)(this.friendPoints(player) - 9) : 0.0f;
                    if (chance > 0.0f && this.relationManager.getCompletedQuests(player.m_142081_()).containsAll(this.data.questHandler().requiredQuests()) && this.updater.getDailyRandom().nextFloat() < chance) {
                        this.speak(serverPlayer, ConversationContext.MARRIAGE_ACCEPT);
                        family.updateRelationship(FamilyEntry.Relationship.MARRIED, player.m_142081_());
                        success = true;
                        this.procreationCooldown = MobConfig.initialProcreationCooldown;
                    } else {
                        this.speak(serverPlayer, ConversationContext.MARRIAGE_DENY);
                    }
                }
                if (!success) {
                    player.m_36356_(stack);
                } else {
                    stack.m_41774_(1);
                }
            }
            return;
        }
        float mult = 1.0f;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WorldHandler handler = WorldHandler.get(serverPlayer.m_20194_());
            if (handler.currentSeason() == this.birthday.getFirst() && handler.date() == ((Integer)this.birthday.getSecond()).intValue()) {
                mult = 3.0f;
            }
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(sound, SoundSource.NEUTRAL, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.7f, 1.0f));
        }
        if ((slot = ItemUtils.slotOf(stack)) != EquipmentSlot.MAINHAND || ItemNBT.isWeapon(stack) || stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.m_8061_(slot, copy);
        }
        this.applyFoodEffect(stack);
        stack.m_41764_(count);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NPCData.Gift gift = this.giftOf(stack);
            if (gift != null) {
                if (this.relationManager.getFriendPointData(player.m_142081_()).giftXP(this.f_19853_, (int)((float)gift.xp() * mult))) {
                    this.tellDialogue(serverPlayer, null, null, (Component)new TranslatableComponent(gift.responseKey()), List.of());
                }
            } else if (this.relationManager.getFriendPointData(player.m_142081_()).giftXP(this.f_19853_, (int)(5.0f * mult))) {
                this.tellDialogue(serverPlayer, null, null, (Component)new TranslatableComponent(this.data.neutralGiftResponse()), List.of());
            }
        }
        stack.m_41774_(1);
    }

    public void talkTo(ServerPlayer player) {
        ConversationContext ctx = ConversationContext.TALK;
        NPCFriendPoints fp = this.relationManager.getFriendPointData(player.m_142081_());
        boolean talkedTo = fp.talked();
        boolean doGreet = fp.talkTo(this.f_19853_, 15);
        if (!talkedTo) {
            ctx = ConversationContext.FIRST_TALK;
        } else if (doGreet) {
            ctx = ConversationContext.GREETING;
        }
        this.speak(player, ctx);
    }

    public void speak(ServerPlayer player, ConversationContext convCtx) {
        int heart = this.relationManager.getFriendPointData((UUID)player.m_142081_()).points.getLevel();
        ConversationSet conversations = this.data.getConversation(convCtx);
        LootContext ctx = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19796_).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootCtxParameters.UUID_CONTEXT, (Object)player.m_142081_()).m_78963_(player.m_36336_()).m_78975_(LootCtxParameters.NPC_INTERACTION);
        List filtered = conversations.conversations().entrySet().stream().filter(c -> {
            if (((ConversationSet.Conversation)c.getValue()).actions().stream().anyMatch(h -> h.action() == ConversationSet.ConversationAction.QUEST) && QuestHandler.questForExists(player, this) != null && !this.updater.alreadyAcceptedRandomquest(player)) {
                return false;
            }
            return ((ConversationSet.Conversation)c.getValue()).startingConversation() && ((ConversationSet.Conversation)c.getValue()).test(heart, ctx);
        }).collect(Collectors.toList());
        Collections.shuffle(filtered, this.updater.getDailyRandom());
        int size = Math.min(filtered.size(), 2 + this.updater.getDailyRandom().nextInt(2));
        if (size > 0) {
            Map.Entry randomLine = (Map.Entry)filtered.get(this.f_19796_.nextInt(size));
            this.tellDialogue(player, convCtx, (String)randomLine.getKey(), (ConversationSet.Conversation)randomLine.getValue());
        } else {
            TranslatableComponent dialog = conversations.missing() != null ? new TranslatableComponent(conversations.fallbackKey(), new Object[]{conversations.missing()}) : new TranslatableComponent(conversations.fallbackKey());
            this.tellDialogue(player, convCtx, null, (Component)dialog, List.of());
        }
    }

    public void respondToQuest(ServerPlayer player, ResourceLocation quest) {
        QuestHandler.getData(player).trigger(NPCTalkTracker.KEY, this);
        QuestState result = QuestHandler.checkCompletionQuest(player, this);
        int questState = this.relationManager.questStateFor(player.m_142081_(), quest);
        QuestConversationContext questCtx = QuestConversationContext.NOT_STARTED;
        if (questState != -1) {
            questCtx = QuestConversationContext.IN_PROGRESS;
            if (result == QuestState.COMPLETE) {
                this.relationManager.endQuest(player.m_142081_(), quest);
                questState = -2;
                questCtx = QuestConversationContext.COMPLETED;
            } else if (result == QuestState.PARTIAL_COMPLETE) {
                questState = this.relationManager.advanceQuest(player.m_142081_(), quest);
                questCtx = QuestConversationContext.NOT_STARTED;
            }
        } else {
            this.relationManager.advanceQuest(player.m_142081_(), quest);
        }
        int heart = this.relationManager.getFriendPointData((UUID)player.m_142081_()).points.getLevel();
        ConversationSet conversations = this.data.getFromQuest(quest, questCtx, questState);
        LootContext ctx = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19796_).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootCtxParameters.UUID_CONTEXT, (Object)player.m_142081_()).m_78963_(player.m_36336_()).m_78975_(LootCtxParameters.NPC_INTERACTION);
        List filtered = conversations.conversations().entrySet().stream().filter(c -> ((ConversationSet.Conversation)c.getValue()).startingConversation() && ((ConversationSet.Conversation)c.getValue()).test(heart, ctx)).collect(Collectors.toList());
        Collections.shuffle(filtered, this.updater.getDailyRandom());
        int size = Math.min(filtered.size(), 2 + this.updater.getDailyRandom().nextInt(2));
        if (size > 0) {
            Map.Entry randomLine = (Map.Entry)filtered.get(this.f_19796_.nextInt(size));
            this.tellDialogue(player, null, (String)randomLine.getKey(), (ConversationSet.Conversation)randomLine.getValue());
        } else {
            TranslatableComponent dialog = conversations.missing() != null ? new TranslatableComponent(conversations.fallbackKey(), new Object[]{conversations.missing()}) : new TranslatableComponent(conversations.fallbackKey());
            this.tellDialogue(player, null, null, (Component)dialog, List.of());
        }
    }

    private void tellDialogue(ServerPlayer player, ConversationContext convCtx, String conversationID, ConversationSet.Conversation conversation) {
        List<Component> actions = conversation.actions().stream().map(e -> new TranslatableComponent(e.translationKey())).toList();
        this.tellDialogue(player, convCtx, conversationID, (Component)new TranslatableComponent(conversation.translationKey()), actions);
    }

    private void tellDialogue(ServerPlayer player, ConversationContext convCtx, String conversationID, Component component, List<Component> actions) {
        this.interactWithPlayer(player);
        Platform.INSTANCE.sendToClient(new S2CNpcDialogue(this.m_142049_(), convCtx, conversationID, component, this.conversationData(player), actions), player);
    }

    private Map<String, Component> conversationData(ServerPlayer player) {
        HashMap<String, Component> map = new HashMap<String, Component>();
        map.put(PlaceHolderComponent.NPC, this.m_5446_());
        map.put(PlaceHolderComponent.PLAYER, player.m_5446_());
        this.randomGiftContext(15, Integer.MAX_VALUE).ifPresent(comp -> map.put(PlaceHolderComponent.FAVORITE, (Component)comp));
        this.randomGiftContext(7, 14).ifPresent(comp -> map.put(PlaceHolderComponent.LIKE, (Component)comp));
        this.randomGiftContext(-14, -1).ifPresent(comp -> map.put(PlaceHolderComponent.DISLIKE, (Component)comp));
        this.randomGiftContext(Integer.MIN_VALUE, -15).ifPresent(comp -> map.put(PlaceHolderComponent.HATE, (Component)comp));
        return map;
    }

    public void handleDialogueAction(ServerPlayer sender, ConversationContext convCtx, String conversationID, int actionIdx) {
        ConversationSet.ConversationActionHolder action;
        ConversationSet conversations = this.data.getConversation(convCtx);
        ConversationSet.Conversation conversation = conversations.conversations().get(conversationID);
        if (conversation != null && actionIdx < conversation.actions().size() && (action = conversation.actions().get(actionIdx)) != null) {
            switch (action.action()) {
                case ANSWER: {
                    ConversationSet.Conversation answer = conversations.conversations().get(action.actionValue());
                    if (answer == null) break;
                    this.relationManager.getFriendPointData(sender.m_142081_()).answer(conversationID, action.friendXP());
                    this.tellDialogue(sender, convCtx, action.actionValue(), answer);
                    break;
                }
                case QUEST: {
                    QuestHandler.acceptQuestRandom(sender, this, new ResourceLocation(action.actionValue()));
                }
            }
        }
    }

    public void closedDialogue(ServerPlayer sender) {
        this.decreaseInteractingPlayers(sender);
    }

    public void closedQuestDialogue(ServerPlayer sender) {
        this.closedDialogue(sender);
        ResourceLocation quest = QuestHandler.questForExists(sender, this);
        if (quest != null && this.relationManager.questStateFor(sender.m_142081_(), quest) == -2) {
            QuestHandler.getData(sender).submit(this);
        }
    }

    public void resetQuestProcess(ServerPlayer player, ResourceLocation quest) {
        this.relationManager.resetQuest(player.m_142081_(), quest);
    }

    public void completeNPCQuest(ServerPlayer player, NPCQuest quest) {
        this.relationManager.completeQuest(player.m_142081_(), quest.getOriginID());
    }

    public boolean canAcceptNPCQuest(ServerPlayer player, NPCQuest quest) {
        return this.relationManager.getCompletedQuests(player.m_142081_()).containsAll(quest.neededParentQuests);
    }

    @Nullable
    public FamilyEntry getFamily() {
        if (this.m_20194_() != null) {
            return FamilyHandler.get(this.m_20194_()).getOrCreateEntry(this);
        }
        return null;
    }

    @Nullable
    public Player getPartner() {
        FamilyEntry family = this.getFamily();
        if (family != null && family.getPartner() != null && family.hasPlayerRelationShip()) {
            return this.m_20194_().m_6846_().m_11259_(family.getPartner());
        }
        return null;
    }

    public FamilyEntry.Relationship relationFor(UUID player) {
        FamilyEntry entry = this.getFamily();
        if (entry != null && player.equals(entry.getPartner())) {
            return entry.getRelationship();
        }
        return FamilyEntry.Relationship.NONE;
    }

    public boolean m_7327_(Entity entity) {
        return EntityNPCBase.attack((LivingEntity)this, entity);
    }

    public static boolean attack(LivingEntity attacker, Entity target) {
        ItemStack stack = attacker.m_21205_();
        CustomDamage.Builder source = new CustomDamage.Builder((Entity)attacker).hurtResistant(0).element(ItemNBT.getElement(stack));
        return CombatUtils.mobAttack(attacker, target, source);
    }

    @Override
    public LevelExpPair level() {
        return this.levelPair;
    }

    @Override
    public void setLevel(int level) {
        this.level().setLevel(Mth.m_14045_((int)level, (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void increaseLevel() {
        this.level().setLevel(Mth.m_14045_((int)(this.level().getLevel() + 1), (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void addXp(float amount) {
        boolean res = this.level().addXP(amount, 10000, LevelCalc::xpAmountForLevelUp, () -> {});
        Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (Entity)this);
        if (res) {
            this.updateStatsToLevel();
        }
    }

    public void updateStatsToLevel() {
        float multiplier;
        if (!this.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (Entity)this);
        }
        float preHealthDiff = this.m_21233_() - this.m_21223_();
        ((AttributeMapAccessor)this.m_21204_()).getAttributes().forEach((att, inst) -> inst.m_22120_(LibConstants.ATTRIBUTE_LEVEL_MOD));
        if (this.data != null) {
            Map<Attribute, Double> gain = this.data.statIncrease() != null ? this.data.statIncrease() : NPCData.DEFAULT_GAIN;
            gain.forEach((att, val) -> {
                val = val * 0.01;
                AttributeInstance inst = this.m_21051_((Attribute)att);
                if (inst != null) {
                    float multiplier = 1.0f;
                    multiplier = att == Attributes.f_22276_ ? (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.12f) * 0.015f) : (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.0f) * 0.01f);
                    inst.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - 1) * val * (double)multiplier, AttributeModifier.Operation.ADDITION));
                    if (att == Attributes.f_22276_) {
                        this.m_21153_(this.m_21233_() - preHealthDiff);
                    }
                }
            });
            return;
        }
        int levelOffset = 1;
        AttributeInstance inst2 = this.m_21051_(Attributes.f_22276_);
        if (inst2 != null) {
            multiplier = 1.0f;
            inst2.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 5.0 * (double)multiplier, AttributeModifier.Operation.ADDITION));
            this.m_21153_(this.m_21233_() - preHealthDiff);
        }
        if ((inst2 = this.m_21051_(Attributes.f_22281_)) != null) {
            multiplier = 1.0f;
            inst2.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, AttributeModifier.Operation.ADDITION));
        }
        if ((inst2 = this.m_21051_((Attribute)ModAttributes.DEFENCE.get())) != null) {
            multiplier = 1.0f;
            inst2.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, AttributeModifier.Operation.ADDITION));
        }
        if ((inst2 = this.m_21051_((Attribute)ModAttributes.MAGIC.get())) != null) {
            multiplier = 1.0f;
            inst2.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, AttributeModifier.Operation.ADDITION));
        }
        if ((inst2 = this.m_21051_((Attribute)ModAttributes.MAGIC_DEFENCE.get())) != null) {
            multiplier = 1.0f;
            inst2.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public int friendPoints(UUID uuid) {
        return this.relationManager.getFriendPointData((UUID)uuid).points.getLevel();
    }

    public int talkCount(UUID uuid) {
        return this.relationManager.getFriendPointData(uuid).getTalkCount();
    }

    public void updateFriendPointsFrom(Player player, CompoundTag tag) {
        this.relationManager.getFriendPointData(player.m_142081_()).load(tag);
    }

    @Override
    public int baseXP() {
        return 0;
    }

    @Override
    public int baseMoney() {
        return 0;
    }

    @Override
    public boolean applyFoodEffect(ItemStack stack) {
        io.github.flemmli97.runecraftory.api.datapack.FoodProperties food;
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (stack.m_41720_() == ModItems.OBJECT_X.get()) {
            ItemObjectX.applyEffect((LivingEntity)this, stack);
        }
        if ((food = DataPackHandler.INSTANCE.foodManager().get(stack.m_41720_())) == null) {
            FoodProperties mcFood = stack.m_41720_().m_41473_();
            this.m_5584_(this.f_19853_, stack);
            if (mcFood != null) {
                this.m_5634_((float)mcFood.m_38744_() * 0.5f);
                return true;
            }
            return false;
        }
        this.m_5584_(this.f_19853_, stack);
        Pair<Map<Attribute, Double>, Map<Attribute, Double>> foodStats = ItemNBT.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            AttributeInstance inst;
            this.removeFoodEffect();
            for (Map.Entry entry : ((Map)foodStats.getSecond()).entrySet()) {
                inst = this.m_21051_((Attribute)entry.getKey());
                if (inst == null) continue;
                inst.m_22120_(LibConstants.FOOD_UUID_MULTI);
                inst.m_22125_(new AttributeModifier(LibConstants.FOOD_UUID_MULTI, "foodBuffMulti_" + ((Attribute)entry.getKey()).m_22087_(), ((Double)entry.getValue()).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE));
            }
            for (Map.Entry entry : ((Map)foodStats.getFirst()).entrySet()) {
                inst = this.m_21051_((Attribute)entry.getKey());
                if (inst == null) continue;
                inst.m_22120_(LibConstants.FOOD_UUID);
                inst.m_22125_(new AttributeModifier(LibConstants.FOOD_UUID, "foodBuff_" + ((Attribute)entry.getKey()).m_22087_(), ((Double)entry.getValue()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            this.foodBuffTick = food.duration();
        }
        EntityUtils.foodHealing((LivingEntity)this, food.getHPGain());
        EntityUtils.foodHealing((LivingEntity)this, this.m_21233_() * (float)food.getHpPercentGain() * 0.01f);
        if (food.potionHeals() != null) {
            for (MobEffect mobEffect : food.potionHeals()) {
                this.m_21195_(mobEffect);
            }
        }
        if (food.potionApply() != null) {
            for (SimpleEffect simpleEffect : food.potionApply()) {
                this.m_7292_(simpleEffect.create());
            }
        }
        return true;
    }

    @Override
    public void removeFoodEffect() {
        ((AttributeMapAccessor)this.m_21204_()).getAttributes().values().forEach(inst -> {
            inst.m_22120_(LibConstants.FOOD_UUID);
            inst.m_22120_(LibConstants.FOOD_UUID_MULTI);
        });
    }

    @Override
    public boolean onGivingItem(Player player, ItemStack stack) {
        this.giftItem(player, stack);
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_6667_(DamageSource cause) {
        RuneCraftory.LOGGER.info("NPC {} died, message: '{}'", (Object)this, (Object)cause.m_6157_((LivingEntity)this).getString());
        if (!this.f_19853_.f_46443_) {
            this.getAnimationHandler().setAnimation(null);
        }
        super.m_6667_(cause);
    }

    public void m_141960_(EntityInLevelCallback levelCallback) {
        super.m_141960_(WorldUtils.wrappedCallbackFor(this, this::followEntity, levelCallback));
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.releasePOI(this.getBedPos());
        this.releasePOI(this.getWorkPlace());
        this.releasePOI(this.getMeetingPos());
        super.m_142687_(reason);
        if (this.m_20194_() != null) {
            NPCHandler handler = WorldHandler.get((MinecraftServer)this.m_20194_()).npcHandler;
            if (reason.m_146965_() && this.data != null && this.data.unique() > 0) {
                handler.removeUniqueNPC(this.m_142081_(), this.data);
            }
            handler.removeNPC(this, reason);
        }
    }

    protected void m_6153_() {
        super.m_6153_();
    }

    public boolean playDeath() {
        return (Boolean)this.f_19804_.m_135370_(PLAY_DEATH_STATE);
    }

    public void setPlayDeath(boolean flag) {
        this.f_19804_.m_135381_(PLAY_DEATH_STATE, (Object)flag);
        if (flag) {
            Player partner;
            if (!this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.followEntity() == null && (partner = this.getPartner()) instanceof ServerPlayer) {
                partner.m_6352_(this.getKnockoutMessage(), Util.f_137441_);
            }
            this.f_19853_.m_142425_(EntityTypeTest.m_156916_(Mob.class), this.m_142469_().m_82400_(32.0), e -> this.equals(e.m_5448_())).forEach(m -> m.m_6710_(null));
            this.m_21573_().m_26573_();
            this.m_20260_(false);
            this.m_6858_(false);
            this.m_19877_();
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    private Component getKnockoutMessage() {
        DamageSource source = this.m_21225_();
        if (source instanceof EntityDamageSource && source.m_7639_() != null) {
            return new TranslatableComponent("runecraftory.tamed.monster.knockout.by", new Object[]{this.m_5446_(), this.m_142538_().m_123341_(), this.m_142538_().m_123342_(), this.m_142538_().m_123343_(), source.m_7639_().m_5446_()});
        }
        return new TranslatableComponent("runecraftory.tamed.monster.knockout", new Object[]{this.m_5446_(), this.m_142538_().m_123341_(), this.m_142538_().m_123342_(), this.m_142538_().m_123343_()});
    }

    public int getPlayDeathTick() {
        return this.playDeathTick;
    }

    public boolean m_142066_() {
        return super.m_142066_() && !this.playDeath();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player follow;
        if (this.playDeath() && source != DamageSource.f_19317_) {
            return false;
        }
        if (this.followEntity() != null && source.m_7639_() != null && ((follow = this.followEntity()).equals((Object)source.m_7639_()) || Platform.INSTANCE.getPlayerData(follow).map(d -> d.party.isPartyMember(source.m_7639_())).orElse(false).booleanValue())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        FamilyEntry family;
        super.m_6475_(damageSrc, damageAmount);
        if (damageSrc != DamageSource.f_19317_ && this.m_21223_() <= 0.0f && (this.followEntity() != null || (family = this.getFamily()) != null && family.getPartner() != null && FamilyHandler.get(this.m_20194_()).getFamily(family.getPartner()).map(FamilyEntry::isPlayer).orElse(false).booleanValue())) {
            this.m_21153_(0.01f);
            this.setPlayDeath(true);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.m_20160_() || this.playDeath();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("MobLevel", (Tag)this.level().save());
        compound.m_128405_("FoodBuffTick", this.foodBuffTick);
        compound.m_128379_("PlayDeath", ((Boolean)this.f_19804_.m_135370_(PLAY_DEATH_STATE)).booleanValue());
        compound.m_128365_("RelationManager", (Tag)this.relationManager.save());
        if (this.entityToFollowUUID != null) {
            compound.m_128362_("EntityToFollow", this.entityToFollowUUID);
        }
        compound.m_128405_("Behaviour", this.behaviourState().ordinal());
        compound.m_128365_("NPCData", (Tag)this.saveNPCData());
        compound.m_128365_("DailyUpdater", (Tag)this.updater.save());
        compound.m_128405_("ProcreationCooldown", this.procreationCooldown);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.levelPair.read((Tag)compound.m_128469_("MobLevel"));
        this.foodBuffTick = compound.m_128451_("FoodBuffTick");
        this.setPlayDeath(compound.m_128471_("PlayDeath"));
        this.relationManager.load(compound.m_128469_("RelationManager"));
        if (compound.m_128403_("EntityToFollow")) {
            this.entityToFollowUUID = compound.m_128342_("EntityToFollow");
        }
        try {
            this.setBehaviour(Behaviour.values()[compound.m_128451_("Behaviour")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (compound.m_128441_("NPCData")) {
            this.loadNpcData(compound.m_128469_("NPCData"));
        }
        this.updater.read(compound.m_128469_("DailyUpdater"));
        this.procreationCooldown = compound.m_128451_("ProcreationCooldown");
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (!this.ignoreInit) {
            this.randomizeData(null, true);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void handleAttack(AnimatedAction anim) {
        this.m_21573_().m_26573_();
    }

    public void npcAttack(Consumer<LivingEntity> cons) {
        this.attackableEntites().forEach(cons);
    }

    public List<LivingEntity> attackableEntites() {
        ItemStack held = this.m_21205_();
        Item item = held.m_41720_();
        if (item instanceof IAOEWeapon) {
            IAOEWeapon weapon = (IAOEWeapon)item;
            return RayTraceUtils.getEntitiesIn((LivingEntity)this, (OrientedBoundingBox)weapon.attackOBB((LivingEntity)this, held, false), (boolean)true, (EntityTypeTest)EntityTypeTest.m_156916_(LivingEntity.class), this.hitPred);
        }
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return List.of();
        }
        double range = this.m_142593_(target);
        if (this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_()) <= range) {
            return List.of(target);
        }
        return List.of();
    }

    public double m_142593_(LivingEntity target) {
        double reachSqr;
        ItemStack held = this.m_21205_();
        if (held.m_41720_() instanceof IAOEWeapon) {
            reachSqr = this.m_21133_((Attribute)ModAttributes.ATTACK_RANGE.get()) - 0.3 + (double)target.m_20205_() * 0.5;
            reachSqr *= reachSqr;
        } else {
            Item item = held.m_41720_();
            if (item instanceof IExtendedWeapon) {
                IExtendedWeapon weapon = (IExtendedWeapon)item;
                float weaponRange = weapon.getRange((LivingEntity)this, held);
                reachSqr = (double)weaponRange + (double)target.m_20205_() * 0.5;
                reachSqr *= reachSqr;
            } else {
                reachSqr = super.m_142593_(target);
            }
        }
        return reachSqr;
    }

    public void m_5802_(BlockPos pos) {
        if (this.sleepCooldown <= 0) {
            super.m_5802_(pos);
        }
    }

    public void m_5796_() {
        super.m_5796_();
        this.sleepCooldown = 60;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean m_21536_() {
        return super.m_21536_() && this.getEntityToFollowUUID() == null;
    }

    public EntityDimensions m_6972_(Pose pose) {
        SizeFeatureType.SizeFeature feat = (SizeFeatureType.SizeFeature)this.lookFeatures.getFeature((NPCFeatureType)((Object)ModNPCLooks.SIZE.get()));
        if (feat != null) {
            return super.m_6972_(pose).m_20388_(feat.size);
        }
        return super.m_6972_(pose);
    }

    public NPCJob getShop() {
        return this.shop;
    }

    public void setShop(NPCJob shop) {
        this.shop = shop;
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(SHOP_SYNC, (Object)ModNPCJobs.getSyncIDFrom(shop));
        }
    }

    public boolean isShopDefined() {
        return !this.data.profession().isEmpty();
    }

    public boolean updateActivity() {
        Level level;
        if (this.f_19797_ % 20 == 0 && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.interactingPlayers.isEmpty()) {
                Activity prev = this.activity;
                this.activity = this.getActivityForTime(serverLevel);
                if (this.activity == ModActivities.EARLYIDLE.get() && this.getBedPos() != null && this.getBedPos().m_122640_() == this.f_19853_.m_46472_()) {
                    if (!this.m_21534_().equals((Object)this.getBedPos().m_122646_())) {
                        this.prevRestriction = this.m_21534_();
                        this.prevRestrictionRadius = (int)this.m_21535_();
                        this.m_21446_(this.getBedPos().m_122646_(), 10);
                    }
                } else if (this.prevRestrictionRadius >= 0) {
                    this.m_21446_(this.prevRestriction, this.prevRestrictionRadius);
                    this.prevRestriction = BlockPos.f_121853_;
                    this.prevRestrictionRadius = -1;
                }
                return prev != this.activity;
            }
        }
        return false;
    }

    public void syncActivity(CompoundTag tag) {
        if (this.f_19853_.f_46443_) {
            this.schedule.load(tag);
        }
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Activity getActivityForTime(ServerLevel serverLevel) {
        return this.schedule.getActivity(serverLevel);
    }

    public NPCSchedule getSchedule() {
        return this.schedule;
    }

    public GlobalPos getWorkPlace() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26360_).orElse(null);
    }

    public void setWorkPlace(GlobalPos pos) {
        if (pos != null) {
            this.f_19853_.m_7605_((Entity)this, (byte)15);
        }
        this.m_6274_().m_21879_(MemoryModuleType.f_26360_, (Object)pos);
    }

    public GlobalPos getBedPos() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26359_).orElse(null);
    }

    public void setBedPos(GlobalPos pos) {
        if (pos != null) {
            this.f_19853_.m_7605_((Entity)this, (byte)14);
        }
        this.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)pos);
    }

    public GlobalPos getMeetingPos() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26362_).orElse(null);
    }

    public void setMeetingPos(GlobalPos pos) {
        this.m_6274_().m_21879_(MemoryModuleType.f_26362_, (Object)pos);
    }

    public ShopState canTrade() {
        if (this.m_6162_() || !this.shop.hasShop && !this.shop.hasWorkSchedule) {
            return ShopState.NOTWORKER;
        }
        if (!this.shop.hasWorkSchedule) {
            return ShopState.OPEN;
        }
        if (this.getWorkPlace() == null) {
            return ShopState.NOWORKPLACE;
        }
        if (this.getBedPos() == null) {
            return ShopState.NOBED;
        }
        if (this.getActivity() != Activity.f_37980_) {
            return ShopState.CLOSED;
        }
        if (!this.nearWorkPlace(this.getWorkPlace(), 4)) {
            return ShopState.TOOFAR;
        }
        return ShopState.OPEN;
    }

    public boolean nearWorkPlace(GlobalPos pos, int range) {
        if (this.followEntity() == null) {
            if (this.f_19853_.m_46472_() != pos.m_122640_()) {
                return false;
            }
            return pos.m_122646_().m_203195_((Position)this.m_20182_(), (double)range);
        }
        return false;
    }

    public void releasePOI(GlobalPos globalPos) {
        ServerLevel serverLevel;
        if (globalPos == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel = globalPos.m_122640_() != this.f_19853_.m_46472_() ? this.f_19853_.m_142572_().m_129880_(globalPos.m_122640_()) : (ServerLevel)this.f_19853_;
        if (serverLevel == null) {
            return;
        }
        PoiManager poiManager = serverLevel.m_8904_();
        if (poiManager.m_27091_(globalPos.m_122646_(), p -> true)) {
            poiManager.m_27154_(globalPos.m_122646_());
            DebugPackets.m_133719_((ServerLevel)serverLevel, (BlockPos)globalPos.m_122646_());
        }
    }

    public Player followEntity() {
        if (!(this.entityToFollowUUID == null || this.entityToFollow != null && this.entityToFollow.m_6084_())) {
            this.entityToFollow = this.f_19853_.f_46443_ ? this.f_19853_.m_46003_(this.entityToFollowUUID) : this.f_19853_.m_142572_().m_6846_().m_11259_(this.entityToFollowUUID);
        }
        return this.entityToFollow;
    }

    public UUID getEntityToFollowUUID() {
        return this.entityToFollowUUID;
    }

    public boolean followEntity(ServerPlayer player) {
        if (player == null) {
            this.setBehaviour(Behaviour.WANDER);
        }
        if (player != null) {
            float chance;
            FamilyEntry family = this.getFamily();
            int points = this.friendPoints((Player)player);
            float f = chance = points < 3 ? -0.1f + 0.1f * (float)points : 0.5f + 0.15f * (float)points;
            if (!player.m_7500_() && family != null && family.hasPlayerRelationShip() && !family.getPartner().equals(player.m_142081_()) && this.updater.getDailyRandom().nextFloat() < chance) {
                this.speak(player, ConversationContext.FOLLOW_NO);
                return false;
            }
            this.speak(player, ConversationContext.FOLLOW_YES);
            this.entityToFollowUUID = player.m_142081_();
        } else {
            Player player2 = this.followEntity();
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                this.speak(serverPlayer, ConversationContext.FOLLOW_STOP);
            }
            this.entityToFollowUUID = null;
        }
        this.entityToFollow = player;
        if (player != null) {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        return true;
    }

    public void setBehaviour(Behaviour behaviour) {
        this.f_19804_.m_135381_(BEHAVIOUR_DATA, (Object)behaviour.ordinal());
        this.behaviour = behaviour;
        if (!this.f_19853_.f_46443_) {
            this.onSetBehaviour();
        }
    }

    private void onSetBehaviour() {
        if (this.behaviourState().following) {
            if (this.followEntity() != null) {
                Platform.INSTANCE.getPlayerData(this.followEntity()).ifPresent(d -> d.party.addPartyMember((Entity)this));
            }
        } else {
            if (this.followEntity() != null) {
                Platform.INSTANCE.getPlayerData(this.followEntity()).ifPresent(d -> d.party.removePartyMember((Entity)this));
            }
            this.m_6710_(null);
        }
        this.m_21573_().m_26573_();
    }

    public Behaviour behaviourState() {
        return this.behaviour;
    }

    public boolean isStaying() {
        return !this.interactingPlayers.isEmpty() || this.interactionMoveCooldown > 0 || this.behaviourState() == Behaviour.STAY;
    }

    public void interactWithPlayer(ServerPlayer player) {
        this.interactingPlayers.add(player);
        this.m_21573_().m_26573_();
    }

    public void decreaseInteractingPlayers(ServerPlayer player) {
        this.interactingPlayers.remove(player);
        this.interactionMoveCooldown = 40;
    }

    public ServerPlayer getLastInteractedPlayer() {
        if (this.interactingPlayers.isEmpty()) {
            return null;
        }
        return this.interactingPlayers.get(this.interactingPlayers.size() - 1);
    }

    public boolean procreateWith(Entity other) {
        FamilyEntry family = this.getFamily();
        if (family == null || !family.getPartner().equals(other.m_142081_()) || this.procreationProgress > 0) {
            return false;
        }
        if (!this.canProcreate()) {
            if (other instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)other;
                this.speak(player, ConversationContext.PROCREATION_COOLDOWN);
            }
            return false;
        }
        this.procreationProgress = 60;
        this.procreationEntity = other;
        return true;
    }

    public void tryUpdateName(Component component) {
        if (this.data.name() == null) {
            this.m_6593_(component);
        }
    }

    public boolean hasDataName() {
        return this.data.name() != null;
    }

    public boolean canProcreate() {
        return this.procreationCooldown < 0;
    }

    private boolean spawnBaby() {
        UUID mother;
        UUID father;
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EntityNPCBase baby = (EntityNPCBase)((EntityType)ModEntities.NPC.get()).m_20655_(serverLevel, null, null, null, this.m_142538_(), MobSpawnType.BREEDING, false, false);
        if (baby == null) {
            return false;
        }
        baby.m_6863_(true);
        ArrayList<ResourceLocation> childIDs = new ArrayList<ResourceLocation>(this.data.possibleChildren());
        NPCDataManager manager = DataPackHandler.INSTANCE.npcDataManager();
        Entity entity = this.procreationEntity;
        if (entity instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)entity;
            childIDs.addAll(npc.data.possibleChildren());
        }
        childIDs.removeIf(r -> !manager.has((ResourceLocation)r));
        if (childIDs.isEmpty()) {
            baby.randomizeData(null, true);
        } else {
            baby.setLevel(1);
            baby.setNPCData(DataPackHandler.INSTANCE.npcDataManager().get((ResourceLocation)childIDs.get(this.f_19796_.nextInt(childIDs.size()))), false);
        }
        if (this.isMale()) {
            father = this.m_142081_();
            mother = this.getFamily().getPartner();
        } else {
            mother = this.m_142081_();
            father = this.getFamily().getPartner();
        }
        Entity entity2 = this.procreationEntity;
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            player.m_36356_(BabySpawnEgg.createBabyFrom(baby, player.m_7755_(), father, mother));
        } else {
            baby.getFamily().setFather(father);
            baby.getFamily().setMother(mother);
            serverLevel.m_7967_((Entity)baby);
        }
        return true;
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(MALE);
    }

    public void setMale(boolean flag) {
        this.f_19804_.m_135381_(MALE, (Object)flag);
    }

    public NPCLook getLook() {
        if (this.look == null) {
            if (this.data == NPCData.DEFAULT_DATA) {
                this.look = NPCLook.DEFAULT_LOOK;
            } else {
                List looks = this.data.look() == null ? List.of() : this.data.look().stream().filter(e -> e.gender() == NPCData.Gender.UNDEFINED || e.gender() == NPCData.Gender.MALE == this.isMale()).map(NPCData.NPCLookId::id).toList();
                this.look = !looks.isEmpty() ? DataPackHandler.INSTANCE.npcLookManager().get((ResourceLocation)looks.get(this.f_19796_.nextInt(looks.size()))) : DataPackHandler.INSTANCE.npcLookManager().getRandom(this.f_19796_, this.isMale());
            }
        }
        return this.look;
    }

    public NPCAttackActions getAttackActions() {
        if (this.attackActions == null) {
            if (this.data == NPCData.DEFAULT_DATA) {
                this.attackActions = NPCAttackActions.DEFAULT;
            } else {
                List<ResourceLocation> actions = this.data.combatActions();
                this.attackActions = DataPackHandler.INSTANCE.npcActionsManager().get(actions.isEmpty() ? null : actions.get(this.f_19796_.nextInt(actions.size())));
            }
        }
        return this.attackActions;
    }

    public Pair<EnumSeason, Integer> getBirthday() {
        if (this.birthday == null) {
            if (this.data == NPCData.DEFAULT_DATA) {
                this.birthday = Pair.of((Object)((Object)EnumSeason.SPRING), (Object)1);
            } else if (this.data.birthday() != null) {
                this.birthday = this.data.birthday();
            } else {
                EnumSeason randSeason = EnumSeason.values()[this.f_19796_.nextInt(EnumSeason.values().length)];
                int day = this.f_19796_.nextInt(30) + 1;
                this.birthday = Pair.of((Object)((Object)randSeason), (Object)day);
            }
        }
        return this.birthday;
    }

    public void setClientLook(NPCLook look) {
        if (this.f_19853_.f_46443_) {
            this.look = look;
            this.m_6210_();
        }
    }

    public NPCData.Gift giftOf(ItemStack stack) {
        this.calcGifts();
        for (Map.Entry<String, NPCData.Gift> e : this.data.giftItems().entrySet()) {
            if (!this.gifts.get(e.getKey()).is(stack)) continue;
            return e.getValue();
        }
        return null;
    }

    protected Optional<Component> randomGiftContext(int min, int max) {
        this.calcGifts();
        ArrayList gifts = new ArrayList();
        this.data.giftItems().forEach((key, gift) -> {
            if (gift.xp() >= min && gift.xp() <= max) {
                gifts.add(this.gifts.get(key));
            }
        });
        if (gifts.isEmpty()) {
            return Optional.empty();
        }
        GiftData gift2 = (GiftData)gifts.get(this.updater.getDailyRandom().nextInt(gifts.size()));
        return Optional.of(new TranslatableComponent(gift2.translation(this.updater.getDailyRandom())));
    }

    private void calcGifts() {
        if (this.gifts == null) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            this.data.giftItems().forEach((s, g) -> {
                GiftData giftData;
                GiftData giftData2 = giftData = g.giftID() == null ? DataPackHandler.INSTANCE.giftManager().getRandomGift(this.updater.getDailyRandom(), g.xp()) : DataPackHandler.INSTANCE.giftManager().get(g.giftID());
                if (giftData != null) {
                    b.put(s, (Object)giftData);
                }
            });
            this.gifts = b.build();
        }
    }

    public void openShopForPlayer(ServerPlayer player) {
        if (this.canTrade() == ShopState.OPEN) {
            this.interactWithPlayer(player);
            Platform.INSTANCE.getPlayerData((Player)player).map(d -> {
                if (this.getShop().hasShop) {
                    return d.getShop(this.getShop());
                }
                return null;
            }).ifPresent(shopList -> Platform.INSTANCE.openGuiMenu(player, new MenuProvider(){
                final /* synthetic */ NonNullList val$shopList;
                {
                    this.val$shopList = nonNullList;
                }

                public Component m_5446_() {
                    return new TranslatableComponent(EntityNPCBase.this.getShop().getTranslationKey());
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                    return new ContainerShop(i, inventory, new InventoryShop(EntityNPCBase.this, (NonNullList<ItemStack>)this.val$shopList));
                }
            }, buf -> {
                buf.writeInt(this.m_142049_());
                buf.writeInt(shopList.size());
                shopList.forEach(s -> buf.m_130059_(ItemStack.f_41582_, s));
            }));
        }
    }

    public void randomizeData(@Nullable ResourceLocation job) {
        this.randomizeData(ModNPCJobs.getFromID(job), false);
    }

    public void randomizeData(NPCJob job, boolean overwrite) {
        if (this.m_20194_() != null) {
            this.setNPCData(DataPackHandler.INSTANCE.npcDataManager().getRandom(this.f_19796_, d -> (d.profession().isEmpty() || d.profession().stream().anyMatch(j -> j.equals(job))) && WorldHandler.get((MinecraftServer)this.m_20194_()).npcHandler.canAssignNPC((NPCData)d), job == null ? null : d -> d.profession().stream().anyMatch(j -> j.equals(job))), !overwrite);
            if (job != null) {
                this.setShop(job);
            }
        }
    }

    public ResourceLocation getDataID() {
        return DataPackHandler.INSTANCE.npcDataManager().getId(this.data);
    }

    public void setNPCData(NPCData data, boolean load) {
        if (this.m_20194_() != null) {
            if (this.data != null) {
                WorldHandler.get((MinecraftServer)this.m_20194_()).npcHandler.removeUniqueNPC(this.m_142081_(), this.data);
            }
            WorldHandler.get((MinecraftServer)this.m_20194_()).npcHandler.addUniqueNPC(this.m_142081_(), data);
        }
        this.data = data;
        this.dataRandom.setSeed(this.m_142081_().hashCode());
        if (!load) {
            this.setShop(!this.data.profession().isEmpty() ? this.data.profession().get(this.dataRandom.nextInt(this.data.profession().size())) : ModNPCJobs.getRandomJob(this.f_19796_));
            this.setMale(this.data.gender() == NPCData.Gender.UNDEFINED ? this.f_19796_.nextBoolean() : this.data.gender() != NPCData.Gender.FEMALE);
            if (this.data.name() == null) {
                String name = DataPackHandler.INSTANCE.nameManager().getRandomFullName(this.f_19796_, this.isMale());
                if (name != null) {
                    this.m_6593_((Component)new TextComponent(name));
                }
            } else {
                Object name = this.data.name();
                if (this.data.surname() != null) {
                    name = (String)name + " " + this.data.surname();
                }
                this.m_6593_((Component)new TextComponent((String)name));
            }
            this.birthday = null;
            this.getBirthday();
            this.look = null;
            this.getLook();
            this.attackActions = null;
            this.getAttackActions();
            if (data.schedule() == null) {
                this.schedule.load(new NPCSchedule(this, this.f_19796_).save());
            } else {
                this.schedule.with(data.schedule());
            }
            this.lookFeatures.buildFromLooks(this, this.look.additionalFeatures().values());
            this.gifts = null;
            this.calcGifts();
        } else {
            if (this.data.look() != null && !this.data.look().isEmpty()) {
                this.look = null;
                this.getLook();
            }
            if (!this.data.profession().isEmpty() && !this.data.profession().contains(this.getShop())) {
                this.setShop(!this.data.profession().isEmpty() ? this.data.profession().get(this.dataRandom.nextInt(this.data.profession().size())) : ModNPCJobs.getRandomJob(this.f_19796_));
            }
            if (this.data.gender() != NPCData.Gender.UNDEFINED && this.data.gender() == NPCData.Gender.MALE != this.isMale()) {
                this.setMale(this.data.gender() == NPCData.Gender.UNDEFINED ? this.f_19796_.nextBoolean() : this.data.gender() != NPCData.Gender.FEMALE);
            }
            if (this.data.name() != null) {
                Object name = this.data.name();
                if (this.data.surname() != null) {
                    name = (String)name + " " + this.data.surname();
                }
                this.m_6593_((Component)new TextComponent((String)name));
            }
            if (this.data.birthday() != null) {
                this.birthday = null;
                this.getBirthday();
            }
            if (this.data.combatActions() != null && !this.data.combatActions().isEmpty()) {
                this.attackActions = null;
            }
            if (data.schedule() != null) {
                this.schedule.with(data.schedule());
            }
        }
        this.applyAttributes(!load);
        if (this.level().getLevel() < this.data.baseLevel()) {
            this.setLevel(this.data.baseLevel());
        }
        this.m_6210_();
        if (!this.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CNPCLook(this.m_142049_(), this.look, this.lookFeatures), (Entity)this);
        }
    }

    private CompoundTag saveNPCData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Data", DataPackHandler.INSTANCE.npcDataManager().getId(this.data).toString());
        tag.m_128359_("Look", DataPackHandler.INSTANCE.npcLookManager().getId(this.getLook()).toString());
        tag.m_128359_("Profession", ModNPCJobs.getIDFrom(this.getShop()).toString());
        tag.m_128379_("Male", this.isMale());
        tag.m_128405_("BirthdayMonth", ((EnumSeason)((Object)this.getBirthday().getFirst())).ordinal());
        tag.m_128405_("Birthday", ((Integer)this.getBirthday().getSecond()).intValue());
        tag.m_128359_("Combat", DataPackHandler.INSTANCE.npcActionsManager().getId(this.getAttackActions()).toString());
        tag.m_128365_("Schedule", (Tag)this.schedule.save());
        tag.m_128365_("LookFeatures", (Tag)this.lookFeatures.save());
        CompoundTag gifts = new CompoundTag();
        this.gifts.forEach((s, g) -> gifts.m_128359_(s, DataPackHandler.INSTANCE.giftManager().getId((GiftData)g).toString()));
        tag.m_128365_("GiftData", (Tag)gifts);
        return tag;
    }

    private void loadNpcData(CompoundTag tag) {
        NPCData data = DataPackHandler.INSTANCE.npcDataManager().get(new ResourceLocation(tag.m_128461_("Data")));
        this.look = DataPackHandler.INSTANCE.npcLookManager().get(new ResourceLocation(tag.m_128461_("Look")));
        this.setShop(ModNPCJobs.getFromID(new ResourceLocation(tag.m_128461_("Profession"))));
        this.setMale(tag.m_128471_("Male"));
        try {
            EnumSeason month = EnumSeason.values()[tag.m_128451_("BirthdayMonth")];
            this.birthday = Pair.of((Object)((Object)month), (Object)tag.m_128451_("Birthday"));
        }
        catch (IllegalArgumentException e) {
            this.getBirthday();
        }
        this.attackActions = DataPackHandler.INSTANCE.npcActionsManager().get(new ResourceLocation(tag.m_128461_("Combat")));
        this.schedule.load(tag.m_128469_("Schedule"));
        try {
            this.lookFeatures.read(tag.m_128469_("LookFeatures"));
        }
        catch (Exception e) {
            this.lookFeatures.buildFromLooks(this, this.look.additionalFeatures().values());
        }
        CompoundTag gifts = tag.m_128469_("GiftData");
        ImmutableMap.Builder b = ImmutableMap.builder();
        gifts.m_128431_().forEach(key -> {
            GiftData giftData = DataPackHandler.INSTANCE.giftManager().get(new ResourceLocation(gifts.m_128461_(key)));
            if (giftData != null) {
                b.put(key, (Object)giftData);
            }
        });
        this.gifts = b.build();
        this.setNPCData(data, true);
    }

    public void m_6457_(ServerPlayer player) {
        Platform.INSTANCE.sendToClient(new S2CNPCLook(this.m_142049_(), this.look, this.lookFeatures), player);
        Platform.INSTANCE.sendToClient(S2CEntityLevelPkt.create(this), player);
    }

    @Override
    public Predicate<LivingEntity> validTargetPredicate() {
        return this.hitPred;
    }

    @Override
    public MobAttackExt.TargetPosition getTargetPosition() {
        return this.targetPosition;
    }

    public static enum Behaviour {
        WANDER("runecraftory.npc.interact.home", false),
        FOLLOW("runecraftory.npc.interact.follow", true),
        FOLLOW_DISTANCE("runecraftory.npc.interact.follow.distance", true),
        STAY("runecraftory.npc.interact.stay", true);

        public final String interactKey;
        public final boolean following;

        private Behaviour(String interactKey, boolean following) {
            this.interactKey = interactKey;
            this.following = following;
        }
    }
}

