/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EntityWeaponHandler<T extends LivingEntity>
implements AttackActionHandler {
    private final T entity;
    private AttackAction currentAction = (AttackAction)((Object)ModAttackActions.NONE.get());
    private int comboCount;
    private final Set<LivingEntity> hitEntityTracker = new HashSet<LivingEntity>();
    private boolean scheduledAction;
    private final Map<DataKey<?>, Object> dataMap = new HashMap();

    public EntityWeaponHandler(T entity) {
        this.entity = entity;
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public boolean doWeaponAttack(AttackAction action, ItemStack stack, @Nullable Spell spell) {
        AttackAction.OverrideType overrideType = this.checkOverride(action, true);
        if (!((LivingEntity)this.entity).f_19853_.f_46443_ && overrideType != AttackAction.OverrideType.NONE) {
            if (overrideType == AttackAction.OverrideType.SCHEDULE) {
                this.scheduledAction = true;
                return true;
            }
            action.onSetup((LivingEntity)this.entity, this);
            this.setAnimationBasedOnState(action, -1);
            this.store(DataKey.USED_WEAPON, stack);
            this.store(DataKey.USED_SPELL, spell);
            return true;
        }
        return false;
    }

    private AttackAction.OverrideType checkOverride(AttackAction action, boolean allowNone) {
        if (allowNone && (this.currentAction == ModAttackActions.NONE.get() || this.getAnimation() == null)) {
            return AttackAction.OverrideType.REPLACE;
        }
        if (this.entity.m_20202_() != null && !action.usableOnMounts(this.comboCount + 1)) {
            return AttackAction.OverrideType.NONE;
        }
        if (this.currentAction == action && action.combos() != null) {
            ComboContainer.ComboHandler combo = action.combos().get(this.comboCount - 1);
            return combo != null && combo.canExecute().test(this) ? AttackAction.OverrideType.SCHEDULE : AttackAction.OverrideType.NONE;
        }
        return AttackAction.OverrideType.NONE;
    }

    private void setAnimationBasedOnState(AttackAction action, int comboIdx) {
        AttackAction change = this.currentAction.onChange((LivingEntity)this.entity, this);
        if (change != null) {
            action = change;
        }
        if (comboIdx != -1) {
            this.comboCount = comboIdx;
        }
        if (action == ModAttackActions.NONE.get()) {
            this.resetStates();
        }
        this.currentAction = action;
        this.scheduledAction = false;
        AnimatedAction anim = action.getAnimation((LivingEntity)this.entity, this.getComboCount());
        if (this.currentAction != ModAttackActions.NONE.get()) {
            ++this.comboCount;
        }
        ((LivingEntity)this.entity).f_20883_ = ((LivingEntity)this.entity).f_20885_;
        this.resetHitEntityTracker();
        this.currentAction.onStart((LivingEntity)this.entity, this);
        if (!((LivingEntity)this.entity).f_19853_.f_46443_) {
            if (anim == null) {
                ((IAnimated)this.entity).getAnimationHandler().setAnimation(null);
            } else {
                ((IAnimated)this.entity).getAnimationHandler().setAnimation(anim, anim.getStartTransition(), anim.getEndTransitionTime(), anim.getTick(1.0f));
            }
        }
    }

    private void resetStates() {
        this.comboCount = 0;
        this.hitEntityTracker.clear();
        Set.copyOf(this.dataMap.keySet()).forEach(this::clear);
    }

    @Override
    public void tick() {
        if (this.currentAction != ModAttackActions.NONE.get()) {
            boolean changedItem;
            ComboContainer.ComboHandler handler = this.currentAction.combos() != null ? this.currentAction.combos().get(this.comboCount - 1) : null;
            ItemStack weapon = this.get(DataKey.USED_WEAPON);
            boolean bl = changedItem = this.entity.m_21205_() != weapon;
            if (changedItem) {
                this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1);
                return;
            }
            if (this.getAnimation() == null) {
                this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1);
            } else {
                this.currentAction.run((LivingEntity)this.entity, weapon, this, this.getAnimation());
            }
            if (this.scheduledAction && handler != null && handler.canAdvance().test(this)) {
                this.setAnimationBasedOnState(this.currentAction, handler.advanceTo().get(this));
            }
        }
    }

    @Override
    public <T> void store(DataKey<T> key, T value) {
        this.dataMap.put(key, value);
    }

    @Override
    public <T> T get(DataKey<T> key) {
        return (T)this.dataMap.getOrDefault(key, key.defaultValue());
    }

    @Override
    public <T> void clearWith(DataKey<T> key, @Nullable Consumer<T> apply) {
        if (apply == null) {
            this.dataMap.remove(key);
        } else {
            apply.accept(this.dataMap.remove(key));
        }
    }

    @Override
    public AttackAction getCurrentAction() {
        return this.currentAction;
    }

    @Override
    public float getCurrentTransitionProgress(float partialTicks) {
        return ((IAnimated)this.entity).getAnimationHandler().getCurrentTransitionProgress(partialTicks);
    }

    @Override
    public float getLastTransitionProgress(float partialTicks) {
        return ((IAnimated)this.entity).getAnimationHandler().getLastTransitionProgress(partialTicks);
    }

    @Override
    public AnimatedAction getAnimation() {
        return ((IAnimated)this.entity).getAnimationHandler().getAnimation();
    }

    @Override
    public AnimatedAction getLastAnimation() {
        return ((IAnimated)this.entity).getAnimationHandler().getLastAnimation();
    }

    @Override
    public void setComboCount(int count) {
        this.comboCount = count;
    }

    @Override
    public int getComboCount() {
        return this.comboCount;
    }

    @Override
    public boolean isScheduledAction() {
        return this.scheduledAction;
    }

    @Override
    public Set<LivingEntity> getHitEntityTracker() {
        return this.hitEntityTracker;
    }
}

