/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class NPCFriendPoints {
    private int lastUpdateTalk = -1;
    private int lastUpdateGift = -1;
    private final Set<String> answeredConversations = new HashSet<String>();
    public final LevelExpPair points = new LevelExpPair();
    private int talkCount;

    public boolean talked() {
        return this.lastUpdateTalk != -1;
    }

    public boolean talkTo(Level level, int xp) {
        int day = WorldUtils.day(level);
        if (day != this.lastUpdateTalk) {
            this.points.addXP(xp, 10, LevelCalc::friendPointsForNext, () -> {});
            this.lastUpdateTalk = day;
            this.answeredConversations.clear();
            ++this.talkCount;
            return true;
        }
        return false;
    }

    public boolean giftXP(Level level, int xp) {
        int day = WorldUtils.day(level);
        if (day != this.lastUpdateGift) {
            this.points.addXP(xp, 20, LevelCalc::friendPointsForNext, () -> {});
            this.lastUpdateGift = day;
            return true;
        }
        return false;
    }

    public boolean answer(String conversation, int xp) {
        if (!this.answeredConversations.contains(conversation)) {
            this.points.addXP(xp, 20, LevelCalc::friendPointsForNext, () -> {});
            this.answeredConversations.add(conversation);
            return true;
        }
        return false;
    }

    public int getTalkCount() {
        return this.talkCount;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("FriendPoints", (Tag)this.points.save());
        tag.m_128405_("LastTalk", this.lastUpdateTalk);
        tag.m_128405_("LastGift", this.lastUpdateGift);
        tag.m_128405_("TalkCount", this.talkCount);
        ListTag answers = new ListTag();
        this.answeredConversations.forEach(s -> answers.add((Object)StringTag.m_129297_((String)s)));
        tag.m_128365_("Answered", (Tag)answers);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.points.read((Tag)tag.m_128469_("FriendPoints"));
        this.lastUpdateTalk = tag.m_128451_("LastTalk");
        this.lastUpdateGift = tag.m_128451_("LastGift");
        this.talkCount = tag.m_128451_("TalkCount");
        ListTag answers = tag.m_128437_("Answered", 8);
        answers.forEach(t -> this.answeredConversations.add(t.m_7916_()));
    }
}

