/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import com.google.common.collect.ImmutableSet;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCFriendPoints;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class NPCRelationManager {
    public static final int QUEST_COMPLETED = -2;
    public static final int QUEST_NOT_STARTED = -1;
    private final Map<UUID, NPCFriendPoints> playerHearts = new HashMap<UUID, NPCFriendPoints>();
    private final Map<UUID, Set<ResourceLocation>> completedQuests = new HashMap<UUID, Set<ResourceLocation>>();
    private final Map<UUID, Map<ResourceLocation, Integer>> questTracker = new HashMap<UUID, Map<ResourceLocation, Integer>>();

    public boolean talkedTo(UUID uuid) {
        return this.playerHearts.containsKey(uuid);
    }

    public NPCFriendPoints getFriendPointData(UUID uuid) {
        return this.playerHearts.computeIfAbsent(uuid, key -> new NPCFriendPoints());
    }

    public void completeQuest(UUID uuid, ResourceLocation questID) {
        this.completedQuests.computeIfAbsent(uuid, key -> new HashSet()).add(questID);
    }

    public Set<ResourceLocation> getCompletedQuests(UUID uuid) {
        return ImmutableSet.copyOf((Collection)this.completedQuests.computeIfAbsent(uuid, key -> new HashSet()));
    }

    public int questStateFor(UUID uuid, ResourceLocation questID) {
        return this.questTracker.computeIfAbsent(uuid, key -> new HashMap()).getOrDefault(questID, -1);
    }

    public int advanceQuest(UUID uuid, ResourceLocation questID) {
        int newState = this.questStateFor(uuid, questID) + 1;
        Map map = this.questTracker.computeIfAbsent(uuid, key -> new HashMap());
        map.put(questID, newState);
        return newState;
    }

    public void endQuest(UUID uuid, ResourceLocation questID) {
        Map map = this.questTracker.computeIfAbsent(uuid, key -> new HashMap());
        map.put(questID, -2);
    }

    public void resetQuest(UUID uuid, ResourceLocation questID) {
        Map<ResourceLocation, Integer> map = this.questTracker.get(uuid);
        if (map != null) {
            map.remove(questID);
            if (map.isEmpty()) {
                this.questTracker.remove(uuid);
            }
        }
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        CompoundTag heartsTag = new CompoundTag();
        this.playerHearts.forEach((uuid, hearts) -> heartsTag.m_128365_(uuid.toString(), (Tag)hearts.save()));
        compound.m_128365_("PlayerHearts", (Tag)heartsTag);
        CompoundTag quests = new CompoundTag();
        this.completedQuests.forEach((uuid, hearts) -> {
            ListTag list = new ListTag();
            hearts.forEach(res -> list.add((Object)StringTag.m_129297_((String)res.toString())));
            quests.m_128365_(uuid.toString(), (Tag)list);
        });
        compound.m_128365_("CompletedQuests", (Tag)quests);
        CompoundTag questsTracker = new CompoundTag();
        this.questTracker.forEach((uuid, tracker) -> {
            CompoundTag states = new CompoundTag();
            tracker.forEach((id, state) -> states.m_128405_(id.toString(), state.intValue()));
            questsTracker.m_128365_(uuid.toString(), (Tag)states);
        });
        compound.m_128365_("QuestStates", (Tag)questsTracker);
        return compound;
    }

    public void load(CompoundTag compound) {
        CompoundTag heartsTag = compound.m_128469_("PlayerHearts");
        heartsTag.m_128431_().forEach(key -> {
            NPCFriendPoints points = new NPCFriendPoints();
            points.load(heartsTag.m_128469_(key));
            this.playerHearts.put(UUID.fromString(key), points);
        });
        CompoundTag quests = compound.m_128469_("CompletedQuests");
        quests.m_128431_().forEach(key -> {
            ListTag listTag = quests.m_128437_(key, 8);
            HashSet set = new HashSet();
            listTag.forEach(t -> set.add(new ResourceLocation(t.m_7916_())));
            this.completedQuests.put(UUID.fromString(key), set);
        });
        CompoundTag questsTracker = compound.m_128469_("QuestStates");
        questsTracker.m_128431_().forEach(key -> {
            CompoundTag states = questsTracker.m_128469_(key);
            HashMap map = new HashMap();
            states.m_128431_().forEach(id -> map.put(new ResourceLocation(id), states.m_128451_(id)));
            this.questTracker.put(UUID.fromString(key), map);
        });
    }
}

