/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.enums.EnumDay;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModActivities;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public class NPCSchedule {
    private final EntityNPCBase npc;
    private Schedule schedule;
    private List<Component> view;

    public NPCSchedule(EntityNPCBase npc, Schedule schedule) {
        this.npc = npc;
        this.schedule = schedule;
    }

    public NPCSchedule(EntityNPCBase npc, Random random) {
        this(npc, new Schedule(random));
    }

    public Activity getActivity(ServerLevel level) {
        if (!this.npc.getShop().hasSchedule) {
            return Activity.f_37979_;
        }
        int dayTime = WorldUtils.dayTime((Level)level);
        EnumDay day = WorldHandler.get(level.m_142572_()).currentDay();
        if (dayTime < this.schedule.wakeUpTime) {
            return Activity.f_37982_;
        }
        if (!this.npc.m_6162_() && this.schedule.workDays.contains((Object)day) && this.npc.getShop().hasWorkSchedule) {
            if (dayTime < this.schedule.workTime) {
                return (Activity)ModActivities.EARLYIDLE.get();
            }
            if (dayTime < this.schedule.breakTime) {
                return Activity.f_37980_;
            }
            if (dayTime < this.schedule.workTimeAfter) {
                return Activity.f_37983_;
            }
            if (dayTime < this.schedule.doneWorkTime) {
                return Activity.f_37980_;
            }
        } else {
            if (dayTime < this.schedule.meetTime) {
                return Activity.f_37979_;
            }
            if (dayTime < this.schedule.meetTimeAfter) {
                return Activity.f_37983_;
            }
        }
        if (dayTime < this.schedule.sleepTime) {
            return Activity.f_37979_;
        }
        return Activity.f_37982_;
    }

    public CompoundTag save() {
        return (CompoundTag)Schedule.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.schedule).getOrThrow(true, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
    }

    public void load(CompoundTag tag) {
        this.schedule = Schedule.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(s -> RuneCraftory.LOGGER.error("Couldn't load schedule for {}. {}", (Object)this.npc, s)).orElse(new Schedule(this.npc.m_21187_()));
        this.view = null;
    }

    public void with(Schedule schedule) {
        this.schedule = schedule;
        this.view = null;
    }

    public List<Component> viewSchedule() {
        if (this.view == null) {
            if (!this.npc.getShop().hasSchedule || !this.npc.getShop().hasWorkSchedule) {
                this.view = ImmutableList.of();
                return this.view;
            }
            ArrayList<TranslatableComponent> newList = new ArrayList<TranslatableComponent>();
            boolean noBreaks = this.schedule.breakTime == this.schedule.workTimeAfter;
            newList.add(new TranslatableComponent("runecraftory.npc.schedule.work", new Object[]{this.formatTime(this.schedule.workTime), noBreaks ? this.formatTime(this.schedule.doneWorkTime) : this.formatTime(this.schedule.breakTime)}));
            if (!noBreaks) {
                newList.add(new TranslatableComponent("runecraftory.npc.schedule.work.2", new Object[]{this.formatTime(this.schedule.workTimeAfter), this.formatTime(this.schedule.doneWorkTime)}));
            }
            newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.header"));
            ArrayList<EnumDay> weekDayCounts = new ArrayList<EnumDay>();
            for (EnumDay day2 : EnumDay.values()) {
                if (day2 == EnumDay.SATURDAY || day2 == EnumDay.SUNDAY || this.schedule.workDays.contains((Object)day2)) continue;
                weekDayCounts.add(day2);
            }
            if (this.schedule.workDays.size() == EnumDay.values().length) {
                newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.all"));
            } else {
                switch (weekDayCounts.size()) {
                    case 0: {
                        newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.0"));
                        break;
                    }
                    case 1: {
                        newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.1", new Object[]{new TranslatableComponent(((EnumDay)((Object)weekDayCounts.get(0))).translationFull())}));
                        break;
                    }
                    case 2: {
                        newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.2", new Object[]{new TranslatableComponent(((EnumDay)((Object)weekDayCounts.get(0))).translationFull()), new TranslatableComponent(((EnumDay)((Object)weekDayCounts.get(1))).translationFull())}));
                        break;
                    }
                    default: {
                        newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.with", this.schedule.workDays.stream().filter(day -> day != EnumDay.SATURDAY && day != EnumDay.SUNDAY).map(e -> new TranslatableComponent(e.translationFull())).toArray()));
                    }
                }
                if (this.schedule.workDays.contains((Object)EnumDay.SATURDAY)) {
                    if (this.schedule.workDays.contains((Object)EnumDay.SUNDAY)) {
                        newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.weekend.2", new Object[]{new TranslatableComponent(EnumDay.SATURDAY.translationFull()), new TranslatableComponent(EnumDay.SUNDAY.translationFull())}));
                    } else {
                        newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.weekend.1", new Object[]{new TranslatableComponent(EnumDay.SATURDAY.translationFull())}));
                    }
                } else if (this.schedule.workDays.contains((Object)EnumDay.SUNDAY)) {
                    newList.add(new TranslatableComponent("runecraftory.npc.schedule.days.weekend.1", new Object[]{new TranslatableComponent(EnumDay.SUNDAY.translationFull())}));
                }
            }
            this.view = ImmutableList.copyOf(newList);
        }
        return this.view;
    }

    private String formatTime(int timeInTicks) {
        int hour = (timeInTicks + 6000) % 24000 / 1000;
        int min = (int)((double)(timeInTicks % 1000) * 0.06);
        String minS = (min < 10 ? "0" : "") + min;
        return String.format("%s:%s", hour, minS);
    }

    public static class Schedule {
        public static final Codec<Schedule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.f_144628_.fieldOf("wake_up_time").forGetter(d -> d.wakeUpTime), (App)ExtraCodecs.f_144629_.fieldOf("work_time").forGetter(d -> d.workTime), (App)ExtraCodecs.f_144629_.fieldOf("break_time").forGetter(d -> d.breakTime), (App)ExtraCodecs.f_144629_.fieldOf("work_time_after").forGetter(d -> d.workTimeAfter), (App)ExtraCodecs.f_144629_.fieldOf("done_work_time").forGetter(d -> d.doneWorkTime), (App)ExtraCodecs.f_144629_.fieldOf("meet_time").forGetter(d -> d.meetTime), (App)ExtraCodecs.f_144629_.fieldOf("meet_time_after").forGetter(d -> d.meetTimeAfter), (App)ExtraCodecs.f_144629_.fieldOf("sleep_time").forGetter(d -> d.sleepTime), (App)CodecUtils.stringEnumCodec(EnumDay.class, null).listOf().fieldOf("work_days").forGetter(d -> d.workDays.stream().toList())).apply((Applicative)inst, Schedule::new));
        public final int wakeUpTime;
        public final int workTime;
        public final int breakTime;
        public final int workTimeAfter;
        public final int doneWorkTime;
        public final int meetTime;
        public final int meetTimeAfter;
        public final int sleepTime;
        private final EnumSet<EnumDay> workDays;

        public Schedule(int wakeUpTime, int workTime, int breakTime, int workTimeAfter, int doneWorkTime, int sleepTime, int meetTimeOffday, int meetTimeAfterOffday, EnumSet<EnumDay> workDays) {
            this.wakeUpTime = wakeUpTime;
            this.workTime = Math.max(this.wakeUpTime + 500, workTime);
            this.breakTime = Math.max(this.workTime, breakTime);
            this.workTimeAfter = Math.max(this.breakTime, workTimeAfter);
            this.doneWorkTime = Math.max(this.workTimeAfter, doneWorkTime);
            this.meetTime = Math.max(this.wakeUpTime, meetTimeOffday);
            this.meetTimeAfter = Math.max(this.meetTime, meetTimeAfterOffday);
            this.sleepTime = Math.max(this.meetTimeAfter, Math.max(this.doneWorkTime, sleepTime));
            this.workDays = workDays;
        }

        private Schedule(int wakeUpTime, int workTime, int breakTime, int workTimeAfter, int doneWorkTime, int sleepTime, int meetTimeOffday, int meetTimeAfterOffday, List<EnumDay> workDays) {
            this(wakeUpTime, workTime, breakTime, workTimeAfter, doneWorkTime, sleepTime, meetTimeOffday, meetTimeAfterOffday, workDays.isEmpty() ? EnumSet.noneOf(EnumDay.class) : EnumSet.copyOf(workDays));
        }

        public Schedule(Random random) {
            this(Schedule.randomizedTime(random, 6, 9), Schedule.randomizedTime(random, 8, 10), Schedule.randomizedTime(random, 11, 13), Schedule.randomizedTime(random, 12, 15), Schedule.randomizedTime(random, 16, 18), Schedule.randomizedTime(random, 20, 22), Schedule.randomizedTime(random, 9, 12), Schedule.randomizedTime(random, 13, 15), Schedule.randomizedWorkDays(random));
        }

        private static int randomizedTime(Random random, int min, int max) {
            float hourAdd = (float)random.nextInt((max - min) * 2) * 0.5f;
            float hour = (float)min + hourAdd - 6.0f;
            return (int)(hour * 10.0f) * 100;
        }

        private static EnumSet<EnumDay> randomizedWorkDays(Random random) {
            EnumSet<EnumDay> set = EnumSet.noneOf(EnumDay.class);
            for (EnumDay day : EnumDay.values()) {
                if (day == EnumDay.SATURDAY) {
                    if (!(random.nextFloat() < 0.4f)) continue;
                    set.add(day);
                    continue;
                }
                if (day == EnumDay.SUNDAY) {
                    if (!(random.nextFloat() < 0.15f)) continue;
                    set.add(day);
                    continue;
                }
                if (!(random.nextFloat() < 0.85f)) continue;
                set.add(day);
            }
            return set;
        }

        public Collection<EnumDay> getWorkDays() {
            return ImmutableSet.copyOf(this.workDays);
        }
    }
}

