/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.client.NPCDialogueLanguageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class PlaceHolderComponent {
    private static final List<String> PLACEHOLDERS = new ArrayList<String>();
    public static final String PLAYER = PlaceHolderComponent.addReplacement("%player%");
    public static final String NPC = PlaceHolderComponent.addReplacement("%npc%");
    public static final String FAVORITE = PlaceHolderComponent.addReplacement("%favorite%");
    public static final String LIKE = PlaceHolderComponent.addReplacement("%like%");
    public static final String DISLIKE = PlaceHolderComponent.addReplacement("%dislike%");
    public static final String HATE = PlaceHolderComponent.addReplacement("%hate%");

    private static String addReplacement(String pattern) {
        PLACEHOLDERS.add(pattern);
        return pattern;
    }

    public static Component parseDialogueComponent(Component component, Map<String, Component> replacements) {
        MutableComponent parse;
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            String translation = NPCDialogueLanguageManager.INSTANCE.getOrDefault(translatable.m_131328_());
            if (translation.equals(translatable.m_131328_())) {
                Language language = Language.m_128107_();
                translation = language.m_6834_(translatable.m_131328_());
            }
            ArrayList<Object> args = new ArrayList<Object>(List.of(translatable.m_131329_()));
            for (String pattern : PLACEHOLDERS) {
                Component replacement = replacements.get(pattern);
                if (replacement == null) continue;
                translation = translation.replace(pattern, "%" + (args.size() + 1) + "$s");
                if (replacement instanceof MutableComponent) {
                    MutableComponent mut = (MutableComponent)replacement;
                    mut.m_130940_(ChatFormatting.AQUA);
                }
                args.add(replacement);
            }
            parse = new TranslatableComponent(translation, args.toArray());
        } else {
            parse = component.m_6879_();
        }
        List<Component> children = component.m_7360_().stream().map(c -> PlaceHolderComponent.parseDialogueComponent(c, replacements)).toList();
        parse.m_7360_().addAll(children);
        return parse;
    }
}

