/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public record FaceFeaturesType(IndexedColorSetting irisSetting, IndexedColorSetting scleraSetting, IndexedColorSetting eyebrowSetting, Map<String, ExpressionFeature> expressionMap) implements NPCFeatureHolder<FaceFeatures>
{
    public static final Codec<FaceFeaturesType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)IndexedColorSetting.CODEC.fieldOf("iris").forGetter(d -> d.irisSetting), (App)IndexedColorSetting.CODEC.fieldOf("sclera").forGetter(d -> d.scleraSetting), (App)IndexedColorSetting.CODEC.fieldOf("eyebrow").forGetter(d -> d.eyebrowSetting), (App)Codec.unboundedMap((Codec)Codec.STRING, ExpressionFeature.CODEC).fieldOf("expressions").forGetter(d -> d.expressionMap)).apply((Applicative)inst, FaceFeaturesType::new));
    public static final Map<String, ExpressionFeature> DEFAULT_EXPRESSIONS = Map.of("eyes_closed", new ExpressionFeature(new TextureType("closed", true), new TextureType("closed", true), "closed"), "angry", new ExpressionFeature(TextureType.NONE, TextureType.NONE, "angry"));

    @Override
    public FaceFeatures create(EntityNPCBase npc) {
        return new FaceFeatures(this.irisSetting.resolve(npc.m_21187_()), this.scleraSetting.resolve(npc.m_21187_()), this.eyebrowSetting.resolve(npc.m_21187_()), this.expressionMap);
    }

    @Override
    public NPCFeatureType<FaceFeatures> getType() {
        return (NPCFeatureType)((Object)ModNPCLooks.FACE.get());
    }

    public static class FaceFeatures
    implements NPCFeature {
        public final IndexedColorSetting.ResolvedIndexColor iris;
        public final IndexedColorSetting.ResolvedIndexColor sclera;
        public final IndexedColorSetting.ResolvedIndexColor eyebrow;
        public final Map<String, ExpressionFeature> expressionMap;

        public FaceFeatures(FriendlyByteBuf buf) {
            this(new IndexedColorSetting.ResolvedIndexColor(buf), new IndexedColorSetting.ResolvedIndexColor(buf), new IndexedColorSetting.ResolvedIndexColor(buf), buf.m_178368_(FriendlyByteBuf::m_130277_, b -> new ExpressionFeature(new TextureType(b.m_130277_(), b.readBoolean()), new TextureType(b.m_130277_(), b.readBoolean()), b.m_130277_())));
        }

        public FaceFeatures(Tag tag) {
            this(new IndexedColorSetting.ResolvedIndexColor(((CompoundTag)tag).m_128469_("Iris")), new IndexedColorSetting.ResolvedIndexColor(((CompoundTag)tag).m_128469_("Sclera")), new IndexedColorSetting.ResolvedIndexColor(((CompoundTag)tag).m_128469_("Eyebrow")), FaceFeatures.fromTag(((CompoundTag)tag).m_128469_("Expressions")));
        }

        public FaceFeatures(IndexedColorSetting.ResolvedIndexColor iris, IndexedColorSetting.ResolvedIndexColor sclera, IndexedColorSetting.ResolvedIndexColor eyebrow, Map<String, ExpressionFeature> expressionMap) {
            this.iris = iris;
            this.sclera = sclera;
            this.eyebrow = eyebrow;
            this.expressionMap = expressionMap;
        }

        private static Map<String, ExpressionFeature> fromTag(CompoundTag tag) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            tag.m_128431_().forEach(k -> {
                CompoundTag expTag = tag.m_128469_(k);
                builder.put(k, (Object)new ExpressionFeature(new TextureType(expTag.m_128461_("IrisSuffix"), expTag.m_128471_("IrisColor")), new TextureType(expTag.m_128461_("ScleraSuffix"), expTag.m_128471_("ScleraColor")), expTag.m_128461_("Eyebrow")));
            });
            return builder.build();
        }

        @Nullable
        public String expressionTexture(NPCFeatureContainer features, String expression, ExpressionType type) {
            FaceFeatures feat = (FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
            ExpressionFeature exp = feat.expressionMap.get(expression);
            if (exp != null) {
                return switch (type) {
                    default -> throw new IncompatibleClassChangeError();
                    case ExpressionType.IRIS -> exp.iris().suffix();
                    case ExpressionType.SCLERA -> exp.sclera().suffix();
                    case ExpressionType.EYEBROWS -> exp.eyebrow();
                };
            }
            return null;
        }

        public boolean useSkinColor(NPCFeatureContainer features, String expression, ExpressionType type) {
            if (type == ExpressionType.EYEBROWS) {
                return false;
            }
            FaceFeatures feat = (FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
            ExpressionFeature exp = feat.expressionMap.get(expression);
            if (exp != null) {
                if (type == ExpressionType.IRIS) {
                    return exp.iris().useSkinColor();
                }
                return exp.sclera().useSkinColor();
            }
            return false;
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buf) {
            this.iris.writeToBuffer(buf);
            this.sclera.writeToBuffer(buf);
            this.eyebrow.writeToBuffer(buf);
            buf.m_178355_(this.expressionMap, FriendlyByteBuf::m_130070_, (b, exp) -> {
                b.m_130070_(exp.iris.suffix());
                b.writeBoolean(exp.iris.useSkinColor());
                b.m_130070_(exp.sclera.suffix());
                b.writeBoolean(exp.sclera.useSkinColor());
                b.m_130070_(exp.eyebrow);
            });
        }

        @Override
        public Tag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Iris", (Tag)this.iris.save());
            tag.m_128365_("Sclera", (Tag)this.sclera.save());
            tag.m_128365_("Eyebrow", (Tag)this.eyebrow.save());
            CompoundTag expMap = new CompoundTag();
            this.expressionMap.forEach((s, e) -> {
                CompoundTag expTag = new CompoundTag();
                expTag.m_128359_("IrisSuffix", e.iris.suffix());
                expTag.m_128379_("IrisColor", e.iris.useSkinColor());
                expTag.m_128359_("ScleraSuffix", e.sclera.suffix());
                expTag.m_128379_("ScleraColor", e.iris.useSkinColor());
                expTag.m_128359_("Eyebrow", e.eyebrow);
                expMap.m_128365_(s, (Tag)expTag);
            });
            tag.m_128365_("Expressions", (Tag)expMap);
            return tag;
        }

        public NPCFeatureType<HairFeatureType.HairFeature> getType() {
            return (NPCFeatureType)((Object)ModNPCLooks.HAIR.get());
        }
    }

    public record ExpressionFeature(TextureType iris, TextureType sclera, String eyebrow) {
        public static final Codec<ExpressionFeature> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TextureType.CODEC.fieldOf("iris").forGetter(d -> d.iris), (App)TextureType.CODEC.fieldOf("sclera").forGetter(d -> d.sclera), (App)Codec.STRING.fieldOf("eyebrow").forGetter(d -> d.eyebrow)).apply((Applicative)inst, ExpressionFeature::new));
    }

    public record TextureType(String suffix, boolean useSkinColor) {
        public static TextureType NONE = new TextureType("", false);
        public static final Codec<TextureType> CODEC = Codec.either((Codec)Codec.STRING, (Codec)RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("suffix").forGetter(d -> d.suffix), (App)Codec.BOOL.fieldOf("use_skin_color").forGetter(d -> d.useSkinColor)).apply((Applicative)inst, TextureType::new))).xmap(e -> (TextureType)e.map(s -> new TextureType((String)s, false), t -> t), t -> !t.useSkinColor ? Either.left((Object)t.suffix()) : Either.right((Object)t));
    }

    public static enum ExpressionType {
        IRIS,
        SCLERA,
        EYEBROWS;

    }
}

