/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.TypedIndexRange;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public record HairFeatureType(TypedIndexRange types, ColorSetting color) implements NPCFeatureHolder<HairFeature>
{
    public static final Codec<HairFeatureType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TypedIndexRange.CODEC.fieldOf("styles").forGetter(d -> d.types), (App)ColorSetting.CODEC.fieldOf("colors").forGetter(d -> d.color)).apply((Applicative)inst, HairFeatureType::new));

    @Override
    public HairFeature create(EntityNPCBase npc) {
        Pair<String, Integer> style = this.types.getRandom(npc.m_21187_());
        return new HairFeature((String)style.getFirst(), (Integer)style.getSecond(), this.color.getRandom(npc.m_21187_()));
    }

    @Override
    public NPCFeatureType<HairFeature> getType() {
        return (NPCFeatureType)((Object)ModNPCLooks.HAIR.get());
    }

    public static class HairFeature
    implements NPCFeature {
        public final String type;
        public final int index;
        public final int color;

        public HairFeature(FriendlyByteBuf buf) {
            this(buf.m_130277_(), buf.readInt(), buf.readInt());
        }

        public HairFeature(Tag tag) {
            this(((CompoundTag)tag).m_128461_("Type"), ((CompoundTag)tag).m_128451_("Index"), ((CompoundTag)tag).m_128451_("Color"));
        }

        public HairFeature(String type, int index, int color) {
            this.type = type;
            this.index = index;
            this.color = color;
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.m_130070_(this.type);
            buf.writeInt(this.index);
            buf.writeInt(this.color);
        }

        @Override
        public Tag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Type", this.type);
            tag.m_128405_("Index", this.index);
            tag.m_128405_("Color", this.color);
            return tag;
        }

        public NPCFeatureType<HairFeature> getType() {
            return (NPCFeatureType)((Object)ModNPCLooks.HAIR.get());
        }
    }
}

