/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ExtraCodecs;

public interface IndexRange {
    public static final Codec<IndexRange> CODEC = CodecUtils.stringEnumCodec(Type.class, (Enum)Type.FIRST_N).dispatch("type", IndexRange::getType, type -> switch (type) {
        default -> throw new IncompatibleClassChangeError();
        case Type.FIRST_N -> FirstNIndices.CODEC;
        case Type.RANGE -> RangeIndices.CODEC;
        case Type.SELECTED -> SelectedIndices.CODEC;
    });

    public Type getType();

    public int getRandom(Random var1);

    public static enum Type {
        FIRST_N,
        RANGE,
        SELECTED;

    }

    public record FirstNIndices(int n) implements IndexRange
    {
        public static final Codec<FirstNIndices> CODEC = ExtraCodecs.f_144629_.fieldOf("amount").xmap(FirstNIndices::new, FirstNIndices::n).codec();

        @Override
        public Type getType() {
            return Type.FIRST_N;
        }

        @Override
        public int getRandom(Random random) {
            if (this.n <= 0) {
                return 0;
            }
            return random.nextInt(this.n);
        }
    }

    public record RangeIndices(int min, int max) implements IndexRange
    {
        public static final Codec<RangeIndices> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("min").forGetter(d -> d.min), (App)Codec.INT.fieldOf("max").forGetter(d -> d.max)).apply((Applicative)inst, RangeIndices::new));

        @Override
        public Type getType() {
            return Type.FIRST_N;
        }

        @Override
        public int getRandom(Random random) {
            return random.nextInt(this.max - this.min) + this.min;
        }
    }

    public record SelectedIndices(List<Integer> indices) implements IndexRange
    {
        public static final Codec<SelectedIndices> CODEC = Codec.INT.listOf().fieldOf("indices").xmap(SelectedIndices::new, SelectedIndices::indices).codec();

        @Override
        public Type getType() {
            return Type.FIRST_N;
        }

        @Override
        public int getRandom(Random random) {
            return this.indices.isEmpty() ? 0 : this.indices.get(random.nextInt(this.indices.size()));
        }
    }
}

