/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public record IndexedColorSetting(List<Integer> indices, ColorSetting color) {
    public static final Codec<IndexedColorSetting> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.listOf().fieldOf("indices").forGetter(d -> d.indices), (App)ColorSetting.CODEC.fieldOf("colors").forGetter(d -> d.color)).apply((Applicative)inst, IndexedColorSetting::new));

    public ResolvedIndexColor resolve(Random random) {
        int index = this.indices.isEmpty() ? 0 : this.indices.get(random.nextInt(this.indices.size()));
        return new ResolvedIndexColor(index, this.color.getRandom(random));
    }

    public record ResolvedIndexColor(int index, int color) {
        public ResolvedIndexColor(FriendlyByteBuf buf) {
            this(buf.readInt(), buf.readInt());
        }

        public ResolvedIndexColor(CompoundTag tag) {
            this(tag.m_128451_("Type"), tag.m_128451_("Color"));
        }

        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.writeInt(this.index);
            buf.writeInt(this.color);
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Index", this.index);
            tag.m_128405_("Color", this.color);
            return tag;
        }
    }
}

