/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class IndexedColorSettingType
implements NPCFeatureHolder<IndexedColorFeature> {
    public static final Function<Supplier<NPCFeatureType<IndexedColorFeature>>, Codec<IndexedColorSettingType>> CODEC = type -> RecordCodecBuilder.create(arg_0 -> IndexedColorSettingType.lambda$static$3((Supplier)type, arg_0));
    private final List<Integer> indices;
    private final ColorSetting color;
    private final Supplier<NPCFeatureType<IndexedColorFeature>> type;

    public IndexedColorSettingType(List<Integer> indices, ColorSetting setting, Supplier<NPCFeatureType<IndexedColorFeature>> type) {
        this.indices = indices;
        this.color = setting;
        this.type = type;
    }

    @Override
    public IndexedColorFeature create(EntityNPCBase npc) {
        int index = this.indices.isEmpty() ? 0 : this.indices.get(npc.m_21187_().nextInt(this.indices.size()));
        return new IndexedColorFeature(index, this.color.getRandom(npc.m_21187_())){

            @Override
            public NPCFeatureType<?> getType() {
                return IndexedColorSettingType.this.type.get();
            }
        };
    }

    @Override
    public NPCFeatureType<IndexedColorFeature> getType() {
        return this.type.get();
    }

    public static NPCFeatureType<IndexedColorFeature> createSimple(final Supplier<NPCFeatureType<IndexedColorFeature>> type) {
        return new NPCFeatureType<IndexedColorFeature>(CODEC.apply(type), buf -> new IndexedColorFeature((FriendlyByteBuf)buf){

            @Override
            public NPCFeatureType<?> getType() {
                return (NPCFeatureType)((Object)type.get());
            }
        }, tag -> new IndexedColorFeature((Tag)tag){

            @Override
            public NPCFeatureType<?> getType() {
                return (NPCFeatureType)((Object)type.get());
            }
        });
    }

    private static /* synthetic */ App lambda$static$3(Supplier type, RecordCodecBuilder.Instance inst) {
        return inst.group((App)Codec.INT.listOf().fieldOf("indices").forGetter(d -> d.indices), (App)ColorSetting.CODEC.fieldOf("colors").forGetter(d -> d.color)).apply((Applicative)inst, (arg_0, arg_1) -> IndexedColorSettingType.lambda$static$2((Supplier)type, arg_0, arg_1));
    }

    private static /* synthetic */ IndexedColorSettingType lambda$static$2(Supplier type, List indices, ColorSetting color) {
        return new IndexedColorSettingType(indices, color, type);
    }

    public static abstract class IndexedColorFeature
    implements NPCFeature {
        public final int index;
        public final int color;

        public IndexedColorFeature(FriendlyByteBuf buf) {
            this(buf.readInt(), buf.readInt());
        }

        public IndexedColorFeature(Tag tag) {
            this(((CompoundTag)tag).m_128451_("Type"), ((CompoundTag)tag).m_128451_("Color"));
        }

        public IndexedColorFeature(int index, int color) {
            this.index = index;
            this.color = color;
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.writeInt(this.index);
            buf.writeInt(this.color);
        }

        @Override
        public Tag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Index", this.index);
            tag.m_128405_("Color", this.color);
            return tag;
        }
    }
}

