/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.TypedIndexRange;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public record OutfitFeatureType(TypedIndexRange types) implements NPCFeatureHolder<OutfitFeature>
{
    public static final Codec<OutfitFeatureType> CODEC = TypedIndexRange.CODEC.fieldOf("outfits").xmap(OutfitFeatureType::new, OutfitFeatureType::types).codec();

    @Override
    public OutfitFeature create(EntityNPCBase npc) {
        Pair<String, Integer> style = this.types.getRandom(npc.m_21187_());
        return new OutfitFeature((String)style.getFirst(), (Integer)style.getSecond());
    }

    @Override
    public NPCFeatureType<OutfitFeature> getType() {
        return (NPCFeatureType)((Object)ModNPCLooks.OUTFIT.get());
    }

    public static class OutfitFeature
    implements NPCFeature {
        public final String type;
        public final int index;

        public OutfitFeature(FriendlyByteBuf buf) {
            this(buf.m_130277_(), buf.readInt());
        }

        public OutfitFeature(Tag tag) {
            this(((CompoundTag)tag).m_128461_("Type"), ((CompoundTag)tag).m_128451_("Index"));
        }

        public OutfitFeature(String type, int index) {
            this.type = type;
            this.index = index;
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.m_130070_(this.type);
            buf.writeInt(this.index);
        }

        @Override
        public Tag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Type", this.type);
            tag.m_128405_("Index", this.index);
            return tag;
        }

        public NPCFeatureType<OutfitFeature> getType() {
            return (NPCFeatureType)((Object)ModNPCLooks.OUTFIT.get());
        }
    }
}

