/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public record SizeFeatureType(NumberProvider size) implements NPCFeatureHolder<SizeFeature>
{
    public static final Codec<SizeFeatureType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("size").forGetter(d -> d.size)).apply((Applicative)inst, SizeFeatureType::new));
    public static final float MIN = 0.2f;
    public static final float MAX = 10.0f;

    @Override
    public SizeFeature create(EntityNPCBase npc) {
        return new SizeFeature(this.size.m_142688_(RuneCraftory.createContext((LivingEntity)npc)));
    }

    @Override
    public NPCFeatureType<SizeFeature> getType() {
        return (NPCFeatureType)((Object)ModNPCLooks.SIZE.get());
    }

    public static class SizeFeature
    implements NPCFeature {
        public final float size;

        public SizeFeature(FriendlyByteBuf buf) {
            this(buf.readFloat());
        }

        public SizeFeature(Tag tag) {
            this(((FloatTag)tag).m_7057_());
        }

        public SizeFeature(float size) {
            this.size = Mth.m_14036_((float)size, (float)0.2f, (float)10.0f);
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buf) {
            buf.writeFloat(this.size);
        }

        @Override
        public Tag save() {
            return FloatTag.m_128566_((float)this.size);
        }

        public NPCFeatureType<SizeFeature> getType() {
            return (NPCFeatureType)((Object)ModNPCLooks.SIZE.get());
        }
    }
}

