/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.job;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;

public class BathhouseAttendant
extends NPCJob {
    public static final String BATH_ACTION = "runecraftory.npc.action.bath";
    public static final String BATH_ACTION_SUCCESS = "runecraftory.npc.action.bath.success";
    public static final String BATH_ACTION_FAIL = "runecraftory.npc.action.bath.fail";
    public static final String BATH_COST = "runecraftory.npc.shop.bath.cost";

    public BathhouseAttendant(NPCJob.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(EntityNPCBase npc, Player player, String action) {
        if (npc.canTrade() == ShopState.OPEN && action.equals(BATH_ACTION)) {
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> {
                int baths = d.getDailyUpdater().getBathCounter() + 1;
                int amount = 300 * baths + Math.max(0, baths - 1) * 100;
                if (d.useMoney(player, amount)) {
                    player.m_6352_((Component)new TranslatableComponent(BATH_ACTION_SUCCESS, new Object[]{player.m_7755_()}), Util.f_137441_);
                    player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BATH.get(), 1700, 0, false, true, false));
                    d.getDailyUpdater().increaseBathCounter();
                } else {
                    player.m_6352_((Component)new TranslatableComponent(BATH_ACTION_FAIL, new Object[]{player.m_7755_(), amount}), Util.f_137441_);
                }
            });
        }
    }

    @Override
    public Map<String, List<Component>> actions(EntityNPCBase entity, ServerPlayer player) {
        return Map.of(BATH_ACTION, List.of(new TranslatableComponent(BATH_COST, new Object[]{Platform.INSTANCE.getPlayerData((Player)player).map(d -> {
            int baths = d.getDailyUpdater().getBathCounter() + 1;
            return 300 * baths + Math.max(0, baths - 1) * 100;
        }).orElse(-1)})));
    }
}

