/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.job;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Cook
extends NPCJob {
    public static final String FORGE_BREAD_ACTION = "runecraftory.npc.action.bread.forge";
    public static final String ARMOR_BREAD_DESCRIPTION = "runecraftory.npc.action.bread.armor";
    public static final String CHEM_BREAD_SUCCESS = "runecraftory.npc.action.bread.chem";
    public static final String COOKING_BREAD_SUCCESS = "runecraftory.npc.action.bread.cooking";
    public static final String BREAD_ACTION_SUCCESS = "runecraftory.npc.action.bread.success";
    public static final String BREAD_ACTION_SUCCESS_GOOD = "runecraftory.npc.action.bread.success.good";
    public static final String BREAD_ACTION_FAIL = "runecraftory.npc.action.bread.fail";
    public static final String BREAD_COST = "runecraftory.npc.shop.bread.cost";
    public static final int BREAD_PRICE = 500;

    public Cook(NPCJob.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(EntityNPCBase npc, Player player, String action) {
        if (npc.updater.getBreadToBuy() <= 0) {
            return;
        }
        if (Platform.INSTANCE.getPlayerData(player).map(d -> !d.useMoney(player, 500)).orElse(true).booleanValue()) {
            player.m_6352_((Component)new TranslatableComponent(BREAD_ACTION_FAIL, new Object[]{player.m_7755_(), 500}), Util.f_137441_);
            return;
        }
        ItemStack bread = switch (action) {
            case ARMOR_BREAD_DESCRIPTION -> new ItemStack((ItemLike)ModItems.ARMOR_BREAD.get());
            case CHEM_BREAD_SUCCESS -> new ItemStack((ItemLike)ModItems.CHEMISTRY_BREAD.get());
            case COOKING_BREAD_SUCCESS -> new ItemStack((ItemLike)ModItems.COOKING_BREAD.get());
            default -> new ItemStack((ItemLike)ModItems.FORGING_BREAD.get());
        };
        int level = Mth.m_14165_((double)Math.abs(npc.m_21187_().nextGaussian() * 4.0));
        Cook.withLevel(bread, level);
        if (!player.m_36356_(bread)) {
            player.m_19983_(bread);
        }
        npc.updater.onBuyBread();
        if (level >= 7) {
            player.m_6352_((Component)new TranslatableComponent(BREAD_ACTION_SUCCESS_GOOD, new Object[]{player.m_7755_()}), Util.f_137441_);
        } else {
            player.m_6352_((Component)new TranslatableComponent(BREAD_ACTION_SUCCESS, new Object[]{player.m_7755_()}), Util.f_137441_);
        }
    }

    @Override
    public Map<String, List<Component>> actions(EntityNPCBase entity, ServerPlayer player) {
        int bread = entity.updater.getBreadToBuy();
        if (bread > 0) {
            TranslatableComponent comp = new TranslatableComponent(BREAD_COST, new Object[]{500, bread});
            return ImmutableMap.of((Object)FORGE_BREAD_ACTION, List.of(comp), (Object)ARMOR_BREAD_DESCRIPTION, List.of(comp), (Object)CHEM_BREAD_SUCCESS, List.of(comp), (Object)COOKING_BREAD_SUCCESS, List.of(comp));
        }
        return Map.of();
    }

    public static ItemStack withLevel(ItemStack stack, int level) {
        CompoundTag tag = ItemNBT.getItemNBT(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.m_128405_("ItemLevel", Mth.m_14045_((int)level, (int)1, (int)10));
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_("runecraftory", (Tag)tag);
        return stack;
    }
}

