/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.job;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.registry.ModPoiTypes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class NPCJob {
    public final boolean hasShop;
    public final boolean hasSchedule;
    public final boolean hasWorkSchedule;
    public final Supplier<PoiType> poiType;
    @Nullable
    public final Predicate<PoiType> predicate;
    private String translationKey;

    public NPCJob(Builder builder) {
        this.hasShop = builder.hasShop;
        this.hasSchedule = builder.hasSchedule;
        this.hasWorkSchedule = builder.hasWorkSchedule;
        this.poiType = builder.poiType;
        this.predicate = this.poiType != null ? (!builder.allowCashPOI || this.poiType == ModPoiTypes.CASH_REGISTER ? t -> this.poiType.get().m_27392_().test(t) : t -> this.poiType.get().m_27392_().test(t) || ((PoiType)ModPoiTypes.CASH_REGISTER.get()).m_27392_().test(t)) : null;
    }

    public boolean hasShop(EntityNPCBase npc, Player player) {
        return this.hasShop;
    }

    public void handleAction(EntityNPCBase npc, Player player, String action) {
    }

    public Map<String, List<Component>> actions(EntityNPCBase entity, ServerPlayer player) {
        return Map.of();
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = "npc.job." + String.valueOf(ModNPCJobs.getIDFrom(this));
        }
        return this.translationKey;
    }

    public static class Builder {
        private final Supplier<PoiType> poiType;
        private boolean allowCashPOI = true;
        private boolean hasShop = true;
        private boolean hasSchedule = true;
        private boolean hasWorkSchedule = true;

        public Builder(Supplier<PoiType> poiType) {
            this.poiType = Objects.requireNonNullElseGet(poiType, () -> () -> null);
        }

        public Builder ignoreCashRegisterPOI() {
            this.allowCashPOI = false;
            return this;
        }

        public Builder noShop() {
            this.hasShop = false;
            return this;
        }

        public Builder noSchedule() {
            this.hasSchedule = false;
            this.hasWorkSchedule = false;
            return this;
        }

        public Builder noWorkSchedule() {
            this.hasWorkSchedule = false;
            return this;
        }
    }
}

