/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.job;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Smith
extends NPCJob {
    public static final String BARN_ACTION = "runecraftory.npc.action.barn";
    public static final String BARN_ACTION_DESCRIPTION = "runecraftory.npc.action.barn.description";
    public static final String BARN_ACTION_SUCCESS = "runecraftory.npc.action.barn.success";
    public static final String BARN_ACTION_FAIL = "runecraftory.npc.action.barn.fail";
    public static final String BARN_COST = "runecraftory.npc.shop.barn.cost";
    public static final String BARN_COST_MAT = "runecraftory.npc.shop.barn.cost.mat";
    public static final String BARN_COST_FAIL = "runecraftory.npc.shop.barn.cost.fail";
    private static final IntUnaryOperator COST_FUNC = count -> {
        int clamped = Math.min(20, count + 1);
        return 1000 * clamped * clamped - Math.max(0, clamped - 1) * 2 * 1000;
    };
    private static final Function<Integer, Float> COST_FUNC_MAT_MULTIPLIER = count -> {
        int clamped = Math.min(10, count);
        return Float.valueOf(1.0f + (float)((int)Math.ceil((double)(clamped * clamped) * 0.5)) * 0.5f);
    };
    private static final Map<ItemPredicate, Integer> MATERIALS = ImmutableMap.of((Object)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_13182_).m_45077_(), (Object)32, (Object)ItemPredicate.Builder.m_45068_().m_204145_(RunecraftoryTags.COBBLESTONE).m_45077_(), (Object)64);

    public Smith(NPCJob.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(EntityNPCBase npc, Player player, String action) {
        if (npc.canTrade() == ShopState.OPEN && action.equals(BARN_ACTION)) {
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> {
                int amount = COST_FUNC.applyAsInt(d.getBoughtBarns());
                HashMap<ItemPredicate, List> stacks = new HashMap<ItemPredicate, List>();
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    for (ItemPredicate itemPredicate : MATERIALS.keySet()) {
                        if (!itemPredicate.m_45049_(stack)) continue;
                        stacks.computeIfAbsent(itemPredicate, k -> new ArrayList()).add(stack);
                    }
                }
                float multiplier = COST_FUNC_MAT_MULTIPLIER.apply(d.getBoughtBarns()).floatValue();
                boolean enough = MATERIALS.entrySet().stream().allMatch(p -> stacks.getOrDefault(p.getKey(), List.of()).stream().mapToInt(ItemStack::m_41613_).sum() >= (int)((float)((Integer)p.getValue()).intValue() * multiplier));
                if (enough && d.useMoney(player, amount)) {
                    player.m_6352_((Component)new TranslatableComponent(BARN_ACTION_SUCCESS, new Object[]{player.m_7755_()}), Util.f_137441_);
                    block2: for (Map.Entry entry : stacks.entrySet()) {
                        int needed = (int)((float)MATERIALS.get(entry.getKey()).intValue() * multiplier);
                        for (ItemStack stack : (List)entry.getValue()) {
                            if (needed > stack.m_41613_()) {
                                int count = stack.m_41613_();
                                stack.m_41764_(0);
                                needed -= count;
                                continue;
                            }
                            stack.m_41774_(needed);
                            continue block2;
                        }
                    }
                    if (!player.m_36356_(new ItemStack((ItemLike)ModItems.MONSTER_BARN.get()))) {
                        player.m_19983_(new ItemStack((ItemLike)ModItems.MONSTER_BARN.get()));
                    }
                    d.onBuyBarn();
                } else {
                    player.m_6352_((Component)new TranslatableComponent(BARN_ACTION_FAIL, new Object[]{player.m_7755_(), amount}), Util.f_137441_);
                }
            });
        }
    }

    @Override
    public Map<String, List<Component>> actions(EntityNPCBase entity, ServerPlayer player) {
        return Map.of(BARN_ACTION, Smith.getBarnActionComponent(player));
    }

    private static List<Component> getBarnActionComponent(ServerPlayer player) {
        return Platform.INSTANCE.getPlayerData((Player)player).map(d -> {
            Object[] obj = new Object[MATERIALS.size()];
            int i = 0;
            for (Map.Entry<ItemPredicate, Integer> e : MATERIALS.entrySet()) {
                obj[i] = (int)((float)e.getValue().intValue() * COST_FUNC_MAT_MULTIPLIER.apply(d.getBoughtBarns()).floatValue());
                ++i;
            }
            return List.of(new TranslatableComponent(BARN_COST, new Object[]{COST_FUNC.applyAsInt(d.getBoughtBarns())}), new TranslatableComponent(BARN_COST_MAT, obj));
        }).orElse(List.of(new TranslatableComponent(BARN_ACTION_FAIL)));
    }
}

