/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.utils;

import io.github.flemmli97.runecraftory.common.network.Packet;
import io.github.flemmli97.runecraftory.common.network.S2CBossbarInfoAdd;
import io.github.flemmli97.runecraftory.common.network.S2CBossbarInfoRemove;
import io.github.flemmli97.runecraftory.common.network.S2CBossbarMusicUpdate;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import org.jetbrains.annotations.Nullable;

public class RunecraftoryBossbar
extends ServerBossEvent {
    public final ResourceLocation type;
    private SoundEvent music;
    private UUID musicID;

    public RunecraftoryBossbar(@Nullable ResourceLocation type, Component name, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
        super(name, color, overlay);
        this.type = type;
    }

    public RunecraftoryBossbar setMusic(SoundEvent music) {
        if (this.music != music) {
            this.music = music;
            this.broadcast(false);
        }
        return this;
    }

    public RunecraftoryBossbar setMusicID(UUID uuid) {
        if (this.musicID == null || !this.musicID.equals(uuid)) {
            this.musicID = uuid;
            this.broadcast(false);
        }
        return this;
    }

    public UUID getMusicId() {
        return this.musicID != null ? this.musicID : this.m_18860_();
    }

    public void m_6543_(ServerPlayer player) {
        boolean contained = this.m_8324_().contains(player);
        super.m_6543_(player);
        if (!contained) {
            this.broadcast(false);
        }
    }

    public void m_6539_(ServerPlayer player) {
        if (this.m_8324_().contains(player)) {
            this.broadcast(true);
        }
        super.m_6539_(player);
    }

    public void removePlayerFading(ServerPlayer player) {
        if (this.m_8324_().contains(player)) {
            this.broadcast(true, false);
        }
        super.m_6539_(player);
    }

    public void m_8321_(boolean visible) {
        boolean prev = this.m_8323_();
        super.m_8321_(visible);
        if (visible != prev) {
            this.broadcast(!visible);
        }
    }

    public void m_142711_(float progress) {
        block2: {
            float prev;
            block3: {
                progress = Math.max(0.0f, progress);
                prev = this.f_146638_;
                super.m_142711_(progress);
                if (!this.m_8323_()) break block2;
                if (prev == 0.0f || progress != 0.0f) break block3;
                S2CBossbarMusicUpdate pkt = new S2CBossbarMusicUpdate(this.m_18860_(), this.getMusicId(), true);
                for (ServerPlayer serverPlayer : this.m_8324_()) {
                    Platform.INSTANCE.sendToClient(pkt, serverPlayer);
                }
                break block2;
            }
            if (prev != 0.0f || progress == 0.0f) break block2;
            S2CBossbarMusicUpdate pkt = new S2CBossbarMusicUpdate(this.m_18860_(), this.getMusicId(), false);
            for (ServerPlayer serverPlayer : this.m_8324_()) {
                Platform.INSTANCE.sendToClient(pkt, serverPlayer);
            }
        }
    }

    private void broadcast(boolean remove) {
        this.broadcast(remove, true);
    }

    private void broadcast(boolean remove, boolean immediate) {
        if (this.m_8323_()) {
            Packet pkt = remove ? new S2CBossbarInfoRemove(this.m_18860_(), immediate) : new S2CBossbarInfoAdd(this.m_18860_(), this.getMusicId(), this.type, this.music);
            for (ServerPlayer serverPlayer : this.m_8324_()) {
                Platform.INSTANCE.sendToClient(pkt, serverPlayer);
            }
        }
    }
}

