/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.events;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attackactions.NaiveBladeAttack;
import io.github.flemmli97.runecraftory.common.blocks.BlockMineral;
import io.github.flemmli97.runecraftory.common.blocks.Growable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolSickle;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.network.S2CDataPackSync;
import io.github.flemmli97.runecraftory.common.network.S2CEntityDataSyncAll;
import io.github.flemmli97.runecraftory.common.network.S2CSyncConfig;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.family.FamilyHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.LivingEntityAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EntityCalls {
    public static void joinPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (S2CDataPackSync.SyncedType type : S2CDataPackSync.SyncedType.values()) {
                Platform.INSTANCE.sendToClient(new S2CDataPackSync(type), serverPlayer);
            }
            Platform.INSTANCE.sendToClient(new S2CCalendar(WorldHandler.get(serverPlayer.m_20194_()).getCalendar()), serverPlayer);
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> {
                data.recalculateStats(serverPlayer, false);
                if (!data.starting) {
                    data.starting = true;
                    data.setMaxHealth(player, GeneralConfig.startingHealth, true);
                    player.m_21153_(player.m_21233_());
                }
            });
            QuestHandler.removeNPCQuestsFor(serverPlayer);
            Platform.INSTANCE.sendToClient(new S2CSyncConfig(), serverPlayer);
            FamilyHandler.get(serverPlayer.m_20194_()).getOrCreateEntry((Player)serverPlayer).updateName((Entity)player);
        }
    }

    public static void onResourceReloadEnd(MinecraftServer server) {
        for (S2CDataPackSync.SyncedType type : S2CDataPackSync.SyncedType.values()) {
            DataPackHandler.prepareResync(type);
            S2CDataPackSync pkt = new S2CDataPackSync(type);
            Platform.INSTANCE.sendToAll(pkt, server);
        }
    }

    public static void onPlayerLoad(ServerPlayer serverPlayer) {
        serverPlayer.m_20194_().m_6937_((Runnable)new TickTask(2, () -> {
            Set<WorldHandler.UnloadedPartyMember> party = WorldHandler.get(serverPlayer.m_20194_()).getUnloadedPartyMembersFor((Player)serverPlayer);
            party.forEach(p -> {
                GlobalPos pos = p.pos();
                ServerLevel level = serverPlayer.m_183503_();
                if (level.m_46472_() != p.pos().m_122640_()) {
                    level = serverPlayer.m_20194_().m_129880_(pos.m_122640_());
                }
                if (level != null) {
                    level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(pos.m_122646_()), 3, (Object)pos.m_122646_());
                }
            });
            party.clear();
        }));
        Set<UUID> toRemove = WorldHandler.get(serverPlayer.m_20194_()).removedPartyMembersFor((Player)serverPlayer);
        Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(d -> toRemove.forEach(d.party::removePartyMember));
        toRemove.clear();
    }

    public static void trackEntity(Player player, Entity target) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                Platform.INSTANCE.sendToClient(new S2CEntityDataSyncAll(living), serverPlayer);
            }
        }
    }

    public static void onLoadEntity(LivingEntity living) {
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            EntityCalls.onPlayerLoad(player);
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> Platform.INSTANCE.sendToClient(new S2CCapSync((PlayerData)data), player));
        }
    }

    public static void updateEquipment(LivingEntity entity, Map<EquipmentSlot, ItemStack> changed, ItemStack lastMainhandItem, Function<EquipmentSlot, ItemStack> lastArmor) {
        AttributeInstance inst;
        ItemStack off;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (changed.containsKey(slot)) continue;
            EntityCalls.reAddAttackDamage(entity, entity.m_6844_(slot), slot);
        }
        for (Map.Entry entry : changed.entrySet()) {
            if (((EquipmentSlot)entry.getKey()).m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack now = (ItemStack)entry.getValue();
            ItemStack last = lastArmor.apply((EquipmentSlot)entry.getKey());
            Platform.INSTANCE.getArmorEffects(last).ifPresent(d -> d.triggerEvent(last, e -> e.onRemove(entity, last)));
            Platform.INSTANCE.getArmorEffects(now).ifPresent(d -> d.triggerEvent(now, e -> e.onEquip(entity, now)));
        }
        boolean hasWeapon = ItemNBT.isWeapon(entity.m_21205_());
        float f = ItemUtils.getShieldEfficiency(entity);
        if (changed.containsKey(EquipmentSlot.MAINHAND) && !changed.containsKey(EquipmentSlot.OFFHAND)) {
            EntityCalls.recalcOffhandBonus(entity, entity.m_21206_(), f);
        }
        if ((off = changed.get(EquipmentSlot.OFFHAND)) != null) {
            EntityCalls.recalcOffhandBonus(entity, off, f);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EntityUtils.sendAttributesTo((LivingEntity)serverPlayer, serverPlayer);
        }
        if (!hasWeapon && (inst = entity.m_21051_(Attributes.f_22281_)) != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                inst.m_22120_(LibConstants.EQUIPMENT_MODIFIERS[slot.ordinal()]);
            }
        }
    }

    private static void reAddAttackDamage(LivingEntity entity, ItemStack stack, EquipmentSlot slot) {
        stack.m_41638_(slot).get((Object)Attributes.f_22281_).forEach(mod -> {
            AttributeInstance inst = entity.m_21051_(Attributes.f_22281_);
            if (inst != null) {
                inst.m_22130_(mod);
                inst.m_22118_(mod);
            }
        });
    }

    private static void recalcOffhandBonus(LivingEntity entity, ItemStack stack, float efficiency) {
        stack.m_41638_(EquipmentSlot.OFFHAND).forEach((att, mod) -> {
            AttributeInstance inst = entity.m_21051_(att);
            if (inst != null) {
                inst.m_22130_(mod);
                inst.m_22118_(new AttributeModifier(mod.m_22209_(), mod.m_22214_(), mod.m_22218_() * (double)efficiency, mod.m_22217_()));
            }
        });
    }

    public static boolean cancelLivingAttack(DamageSource source, Entity target, float amount) {
        LivingEntity living;
        Entity attacker = source.m_7639_();
        if (!source.m_19378_() && target instanceof Player) {
            PlayerData data;
            Player player = (Player)target;
            if (Platform.INSTANCE.getPlayerData(player).map(d -> d.getWeaponHandler().isInvulnerable((LivingEntity)player)).orElse(false).booleanValue()) {
                return true;
            }
            if (source.m_7640_() != null && amount > 0.0f && (data = (PlayerData)Platform.INSTANCE.getPlayerData(player).orElse(null)) != null && NaiveBladeAttack.canCounter(data.getWeaponHandler())) {
                data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)ModAttackActions.NAIVE_BLADE.get()), player.m_21205_(), null);
                return true;
            }
        }
        if (source instanceof CustomDamage || attacker instanceof Player) {
            return false;
        }
        if (attacker instanceof LivingEntity && (living = (LivingEntity)attacker).m_21205_().m_204117_(RunecraftoryTags.UPGRADABLE_HELD) && !living.m_6095_().m_204039_(RunecraftoryTags.HELD_WEAPON_EXEMPT)) {
            CombatUtils.mobAttack(living, target);
            return true;
        }
        return false;
    }

    public static boolean playerAttack(Player player, Entity target) {
        if (!player.f_19853_.f_46443_ && ItemNBT.isWeapon(player.m_21205_())) {
            CombatUtils.playerAttackWithItem(player, target, true, true);
            return true;
        }
        return false;
    }

    public static boolean playerAoeAttack(Player player, ItemStack stack, List<Entity> list) {
        if (ItemNBT.isWeapon(stack)) {
            for (int i = 0; i < list.size(); ++i) {
                CombatUtils.playerAttackWithItem(player, list.get(i), i == list.size() - 1, i == list.size() - 1);
            }
            return true;
        }
        return false;
    }

    public static boolean playerDeath(LivingEntity entity, DamageSource source) {
        if (!entity.f_19853_.f_46443_) {
            Object object;
            if (!source.m_19378_()) {
                Player player;
                ItemStack deathProt = ItemStack.f_41583_;
                for (ItemStack stack : entity.m_20158_()) {
                    if (stack.m_41720_() != ModItems.LAWN.get()) continue;
                    deathProt = stack;
                }
                if (deathProt.m_41619_() && entity instanceof Player) {
                    player = (Player)entity;
                    object = player.m_150109_().f_35974_.iterator();
                    while (object.hasNext()) {
                        ItemStack stack = (ItemStack)object.next();
                        if (stack.m_41720_() != ModItems.LAWN.get()) continue;
                        deathProt = stack;
                    }
                }
                if (!deathProt.m_41619_()) {
                    if (entity instanceof ServerPlayer) {
                        player = (ServerPlayer)entity;
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)deathProt.m_41720_()));
                        CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, deathProt);
                    }
                    entity.m_21153_(entity.m_21233_() * 0.33f);
                    entity.m_21219_();
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 100));
                    entity.f_19853_.m_7605_((Entity)entity, (byte)35);
                    deathProt.m_41774_(1);
                    return true;
                }
            }
            if (MobConfig.vanillaGiveXp && entity instanceof Mob) {
                Mob m = (Mob)entity;
                if (!(entity instanceof IBaseMob) && (object = source.m_7639_()) instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)object;
                    LevelCalc.addXP(attacker, (int)Math.log(m.m_21233_() + 1.0f) * 10, 0, 0, false);
                }
            }
        }
        return false;
    }

    public static void dropInventoryDeath(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getInv().dropItemsAt((LivingEntity)player));
            }
        }
    }

    public static void clone(Player origin, Player player, boolean death) {
        if (player instanceof ServerPlayer) {
            Platform.INSTANCE.getPlayerData(origin).ifPresent(data -> {
                if (death) {
                    data.useMoney(origin, (int)((double)data.getMoney() * 0.2));
                }
                Platform.INSTANCE.getPlayerData(player).ifPresent(newData -> newData.readFromNBT(data.writeToNBT(new CompoundTag(), origin, death), player));
            });
        }
    }

    public static void cropRightClickHarvest(Player player, BlockState state, BlockPos pos, InteractionHand hand) {
        Block block;
        if (!player.f_19853_.f_46443_ && (block = state.m_60734_()) instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_204117_(RunecraftoryTags.QUICKHARVEST_BYPASS)) {
                return;
            }
            if (crop.m_52307_(state)) {
                CropProperties props = CropUtils.getPropertiesFor(crop);
                CropUtils.harvestCropRightClick(state, player.f_19853_, pos, (Entity)player, player.m_21205_(), props, hand, null);
            }
        }
    }

    public static boolean onTryBonemeal(Level level, ItemStack stack, BlockState state, BlockPos pos, @Nullable Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos targetPos = null;
            boolean swing = false;
            if (state.m_60734_() instanceof Growable) {
                BlockPos below;
                CropProperties props = DataPackHandler.INSTANCE.cropManager().get(state.m_60734_().m_7397_((BlockGetter)level, pos, state).m_41720_());
                if (props != null && FarmlandHandler.isFarmBlock(level.m_8055_(below = pos.m_7495_()))) {
                    targetPos = below;
                }
                swing = !(state.m_60734_() instanceof BonemealableBlock);
            } else if (FarmlandHandler.isFarmBlock(state)) {
                targetPos = pos;
                swing = true;
            }
            if (targetPos != null) {
                BlockPos target = targetPos;
                if (player != null && swing) {
                    player.m_21011_(player.m_21206_().equals(stack) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, true);
                }
                FarmlandHandler.get(serverLevel.m_142572_()).getData(serverLevel, target).ifPresent(d -> {
                    if (d.canUseBonemeal()) {
                        d.applyBonemeal(serverLevel);
                        stack.m_41774_(1);
                        Platform.INSTANCE.sendToAll(new S2CTriggers(S2CTriggers.Type.FERTILIZER, target), level.m_142572_());
                    }
                });
                return true;
            }
        }
        return player == null && FarmlandHandler.isFarmBlock(state);
    }

    public static void updateLivingTick(LivingEntity entity) {
        Mob mob;
        boolean disabled;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> data.tick(player));
            if (GeneralConfig.disableHunger) {
                int food = EntityUtils.paralysed((LivingEntity)player) ? 6 : 14;
                player.m_36324_().m_38705_(food);
                player.m_36324_().m_38717_(0.0f);
            }
        }
        for (Player slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = entity.m_6844_((EquipmentSlot)slot)).m_41619_()) continue;
            Platform.INSTANCE.getArmorEffects(stack).ifPresent(d -> d.triggerEvent(stack, e -> e.onTick(entity, stack)));
        }
        if (entity instanceof Mob && (disabled = EntityUtils.isDisabled((LivingEntity)(mob = (Mob)entity))) && !mob.m_21573_().m_26571_()) {
            mob.m_21573_().m_26573_();
        }
    }

    public static boolean rootTick(LivingEntity entity) {
        if (entity instanceof Player) {
            return false;
        }
        if (Platform.INSTANCE.getEntityData(entity).map(EntityData::isStunned).orElse(false).booleanValue()) {
            ((LivingEntityAccessor)entity).tickEffectsManually();
            return true;
        }
        return false;
    }

    public static void foodHandling(LivingEntity entity, ItemStack stack) {
        if (!entity.f_19853_.f_46443_) {
            if (entity instanceof IBaseMob) {
                IBaseMob mob = (IBaseMob)entity;
                mob.applyFoodEffect(stack);
                return;
            }
            FoodProperties prop = DataPackHandler.INSTANCE.foodManager().get(stack.m_41720_());
            if (prop == null) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (stack.m_41614_()) {
                        Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                            LevelCalc.levelSkill(player, data, EnumSkills.EATING, 5.0f);
                            data.refreshRunePoints((Player)player, EntityUtils.getRPFromVanillaFood(stack));
                        });
                    }
                }
                return;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                    if (data.foodBuffDuration() <= 0) {
                        data.getDailyUpdater().onFoodEaten(player);
                    }
                    data.applyFoodEffect((Player)player, stack);
                    data.refreshRunePoints((Player)player, prop.getRPRegen() + (int)((double)(data.getMaxRunePoints() * prop.getRpPercentRegen()) * 0.01));
                });
            }
            Pair<Map<Attribute, Double>, Map<Attribute, Double>> map = ItemNBT.foodStats(stack);
            int healthGain = ((Map)map.getFirst()).getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
            EntityUtils.foodHealing(entity, healthGain);
            int healthPercent = ((Map)map.getSecond()).getOrDefault(ModAttributes.HEALTHGAIN.get(), 0.0).intValue();
            EntityUtils.foodHealing(entity, entity.m_21233_() * (float)healthPercent * 0.01f);
            if (prop.potionHeals() != null) {
                for (MobEffect mobEffect : prop.potionHeals()) {
                    entity.m_21195_(mobEffect);
                }
            }
            if (prop.potionApply() != null) {
                for (SimpleEffect simpleEffect : prop.potionApply()) {
                    entity.m_7292_(simpleEffect.create());
                }
            }
        }
    }

    public static void wakeUp(Player player) {
        if (GeneralConfig.healOnWakeUp && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player.m_5634_(player.m_21233_());
            Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(data -> {
                data.refreshRunePoints(player, data.getMaxRunePoints());
                LevelCalc.levelSkill(serverPlayer, data, EnumSkills.SLEEPING, 75.0f);
            });
            player.m_21195_((MobEffect)ModEffects.FATIGUE.get());
        }
    }

    public static boolean disableNatural(MobSpawnType spawnType, EntityType<?> entity) {
        if (MobConfig.disableNaturalSpawn) {
            return (spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.NATURAL) && entity != ModEntities.GATE.get();
        }
        return false;
    }

    public static float damageCalculation(LivingEntity entity, DamageSource source, float dmg) {
        float damage = CombatUtils.reduceDamageFromStats(entity, source, dmg);
        if (damage < 0.0f) {
            entity.m_5634_(-damage);
        } else if (damage > 1.0f && source != DamageSource.f_19317_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.DEFENCE, Math.min(7.0f, (float)(0.5 + Math.log((double)damage * 0.25))) * 1.5f));
        }
        return damage;
    }

    public static void postDamage(LivingEntity entity, DamageSource src, float amount) {
        LivingEntity living;
        float drainPercent;
        Entity attacker = src.m_7639_();
        if (attacker instanceof LivingEntity) {
            entity.m_21195_((MobEffect)ModEffects.SLEEP.get());
        }
        if (amount > 0.0f && attacker instanceof LivingEntity && (drainPercent = (float)CombatUtils.statusEffectValue(living = (LivingEntity)attacker, (Attribute)ModAttributes.DRAIN.get(), (Entity)entity)) > 0.0f) {
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.m_5634_(drainPercent * amount);
            } else {
                living.m_5634_(drainPercent * amount);
            }
        }
    }

    public static void onBlockBreak(ServerPlayer player, BlockState state, BlockPos pos) {
        if (state.m_60734_() instanceof CropBlock) {
            ModCriteria.HARVEST_CROP.trigger(player, state);
        }
        if (!player.m_36298_(state)) {
            return;
        }
        if (state.m_204336_(RunecraftoryTags.HAMMER_BREAKABLE)) {
            ItemToolHammer.onHammering(player, true);
        } else if (state.m_204336_(BlockTags.f_144282_)) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.MINING, state.m_60734_() instanceof BlockMineral ? 10.0f : 1.0f));
        }
        if (state.m_204336_(BlockTags.f_144280_)) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.LOGGING, 1.0f));
        }
        if (state.m_204336_(BlockTags.f_144281_) && !(player.m_21205_().m_41720_() instanceof ItemToolSickle)) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 1.0f));
        }
        if (state.m_60734_() instanceof BushBlock) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 0.5f));
        }
    }

    public static void onLootTableBlockGen(Player player, BlockEntity blockEntity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> LevelCalc.levelSkill(serverPlayer, data, EnumSkills.SEARCHING, 7.0f));
        }
    }

    public static boolean shouldPreventFarmlandTrample(Entity entity, LevelAccessor world) {
        return GeneralConfig.disableFarmlandTrample;
    }

    public static boolean onPlayerUseItem(Player player, InteractionHand hand) {
        return Platform.INSTANCE.getPlayerData(player).map(d -> d.getWeaponHandler().getCurrentAction() == ModAttackActions.NONE.get() || ItemStack.m_150942_((ItemStack)player.m_21120_(hand), (ItemStack)d.getWeaponHandler().get(DataKey.USED_WEAPON))).orElse(true);
    }
}

