/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.events;

import com.mojang.brigadier.CommandDispatcher;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.commands.RunecraftoryCommand;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.ModFeatures;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class WorldCalls {
    public static void command(CommandDispatcher<CommandSourceStack> dispatcher) {
        RunecraftoryCommand.reg(dispatcher);
    }

    public static void addFeatures(BiConsumer<GenerationStep.Decoration, Holder<PlacedFeature>> cons, Biome.BiomeCategory category) {
        switch (category) {
            case NETHER: {
                cons.accept(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PLACEDNETHERHERBFEATURE);
                for (Holder<PlacedFeature> holder : ModFeatures.PLACEDNETHERMINERALFEATURES) {
                    cons.accept(GenerationStep.Decoration.VEGETAL_DECORATION, holder);
                }
                break;
            }
            case THEEND: {
                cons.accept(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PLACEDENDHERBFEATURE);
                for (Holder<PlacedFeature> holder : ModFeatures.PLACEDMINERALFEATURES) {
                    cons.accept(GenerationStep.Decoration.VEGETAL_DECORATION, holder);
                }
                break;
            }
            default: {
                cons.accept(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.PLACEDHERBFEATURE);
                for (Holder<PlacedFeature> holder : ModFeatures.PLACEDMINERALFEATURES) {
                    cons.accept(GenerationStep.Decoration.VEGETAL_DECORATION, holder);
                }
            }
        }
    }

    public static void daily(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_46472_().equals(Level.f_46428_)) {
                WorldHandler.get(serverLevel.m_142572_()).update(serverLevel);
                FarmlandHandler.get(serverLevel.m_142572_()).tick(serverLevel);
            }
        }
    }

    public static boolean disableVanillaCrop(LevelAccessor level, BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            CropProperties prop = DataPackHandler.INSTANCE.cropManager().get(crop.m_7397_((BlockGetter)level, pos, state).m_41720_());
            return prop != null;
        }
        return false;
    }
}

