/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryShop
implements Container {
    public static final int SHOP_SIZE = 30;
    private final NonNullList<ItemStack> slots = NonNullList.m_122780_((int)30, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> shop;
    private int index;
    private ItemStack output = ItemStack.f_41583_;
    public final EntityNPCBase npc;

    public InventoryShop(EntityNPCBase npc, NonNullList<ItemStack> shop) {
        this.npc = npc;
        this.shop = shop;
        this.updateInv();
    }

    public int m_6643_() {
        return this.slots.size() + 1;
    }

    public boolean m_7983_() {
        if (!this.output.m_41619_()) {
            return false;
        }
        for (ItemStack itemstack : this.slots) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        if (index == 30) {
            return this.output;
        }
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (index == 30) {
            return this.output.m_41620_(count);
        }
        return ContainerHelper.m_18969_(this.slots, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        if (index == 30) {
            ItemStack stack = this.output.m_41777_();
            this.output = ItemStack.f_41583_;
            return stack;
        }
        return ContainerHelper.m_18966_(this.slots, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index == 30) {
            this.output = stack;
        } else {
            stack.m_41764_(this.m_6893_());
            this.slots.set(index, (Object)stack);
        }
    }

    public void m_6596_() {
        this.updateInv();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.slots.clear();
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return false;
    }

    public void next() {
        this.index = Math.min(this.shop.size() / 30, ++this.index);
        this.updateInv();
    }

    public void prev() {
        this.index = Math.max(0, --this.index);
        this.updateInv();
    }

    public boolean hasNext() {
        return this.index < this.shop.size() / 30;
    }

    public boolean hasPrev() {
        return this.index > 0;
    }

    private void updateInv() {
        NonNullList<ItemStack> list = this.shop;
        for (int i = 0; i < this.slots.size(); ++i) {
            int slot = i + 30 * this.index;
            ItemStack stack = ItemStack.f_41583_;
            if (slot < list.size()) {
                stack = (ItemStack)list.get(slot);
            }
            this.slots.set(i, (Object)stack);
        }
    }
}

