/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.blocks.tile.CraftingBlockEntity;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.crafting.SpecialSextupleRecipe;
import io.github.flemmli97.runecraftory.common.inventory.DummyInventory;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.inventory.container.CraftingOutputSlot;
import io.github.flemmli97.runecraftory.common.network.S2CCraftingRecipes;
import io.github.flemmli97.runecraftory.common.registry.ModContainer;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.mixin.AbstractContainerMenuAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ContainerCrafting
extends AbstractContainerMenu {
    private final PlayerContainerInv craftingInv;
    private final EnumCrafting type;
    private final DummyInventory outPutInv;
    private final CraftingBlockEntity tile;
    private final DataSlot rpCost;
    private List<SextupleRecipe> matchingRecipes;
    private List<Pair<Integer, ItemStack>> matchingRecipesClient = new ArrayList<Pair<Integer, ItemStack>>();
    private boolean updatedRecipes;
    private boolean init = true;
    private SextupleRecipe currentRecipe;

    public ContainerCrafting(int windowId, Inventory inv, FriendlyByteBuf data) {
        this(windowId, inv, ContainerCrafting.getTile(inv.f_35978_.f_19853_, data));
    }

    public ContainerCrafting(int windowID, Inventory playerInv, CraftingBlockEntity tile) {
        super((MenuType)ModContainer.CRAFTING_CONTAINER.get(), windowID);
        int i;
        this.outPutInv = new DummyInventory((Container)new SimpleContainer(2));
        this.craftingInv = PlayerContainerInv.create(this, tile.getInventory(), playerInv.f_35978_);
        this.tile = tile;
        this.type = tile.craftingType();
        this.m_38897_(new CraftingOutputSlot(this.outPutInv, this, this.craftingInv, 0, 116, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        for (i = 0; i < 3; ++i) {
            this.m_38897_(new Slot((Container)this.craftingInv, i, 20 + i * 18, 26));
            this.m_38897_(new Slot((Container)this.craftingInv, i + 3, 20 + i * 18, 44));
        }
        this.rpCost = DataSlot.m_39401_();
        this.m_38895_(this.rpCost);
        this.initCraftingMatrix(this.craftingInv);
        this.init = false;
    }

    public static List<SextupleRecipe> getRecipes(PlayerContainerInv inv, EnumCrafting type) {
        Player player = inv.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List recipes = serverPlayer.m_20194_().m_129894_().m_44056_(CraftingUtils.getType(type), (Container)inv, (Level)serverPlayer.m_183503_());
            recipes.sort(Comparator.comparingInt(SextupleRecipe::getCraftingLevel));
            return recipes;
        }
        return new ArrayList<SextupleRecipe>();
    }

    public static CraftingBlockEntity getTile(Level world, FriendlyByteBuf buffer) {
        BlockEntity blockEntity = world.m_7702_(buffer.m_130135_());
        if (blockEntity instanceof CraftingBlockEntity) {
            return (CraftingBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Expected tile entity of type TileCrafting but got " + String.valueOf(blockEntity));
    }

    public EnumCrafting craftingType() {
        return this.type;
    }

    private void initCraftingMatrix(Container inv) {
        if (inv == this.craftingInv) {
            this.updateCraftingOutput(true);
        }
    }

    public void updateCraftingOutput(boolean init) {
        if (this.craftingInv.getPlayer().f_19853_.f_46443_) {
            return;
        }
        if (this.craftingInv.refreshAndSet()) {
            this.matchingRecipes = ContainerCrafting.getRecipes(this.craftingInv, this.type);
            if (this.matchingRecipes.isEmpty()) {
                SpecialSextupleRecipe recipe;
                this.matchingRecipes = new ArrayList<SextupleRecipe>();
                switch (this.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ARMOR: 
                    case FORGE: {
                        SpecialSextupleRecipe specialSextupleRecipe = SpecialSextupleRecipe.SCRAP.get();
                        break;
                    }
                    case CHEM: {
                        SpecialSextupleRecipe specialSextupleRecipe = SpecialSextupleRecipe.OBJECT_X.get();
                        break;
                    }
                    case COOKING: {
                        SpecialSextupleRecipe specialSextupleRecipe = recipe = SpecialSextupleRecipe.FAILED_DISH.get();
                    }
                }
                if (recipe.matches(this.craftingInv, this.craftingInv.getPlayer().f_19853_)) {
                    this.matchingRecipes.add(recipe);
                }
            }
            this.updatedRecipes = true;
            if (!init) {
                this.tile.resetIndex();
            }
        }
        this.updateCraftingSlot();
    }

    private void updateCraftingSlot() {
        ItemStack clientOutput;
        ItemStack trueOutput;
        if (this.matchingRecipes != null && !this.matchingRecipes.isEmpty()) {
            if (this.updatedRecipes) {
                if (this.currentRecipe != null) {
                    int i;
                    for (i = this.matchingRecipes.size() - 1; i > 0 && !this.currentRecipe.equals(this.matchingRecipes.get(i)); --i) {
                    }
                    this.tile.setIndex(i);
                } else if (!this.init || this.tile.craftingIndex() >= this.matchingRecipes.size()) {
                    this.tile.resetIndex();
                }
            }
            this.currentRecipe = this.matchingRecipes.get(this.tile.craftingIndex());
            SextupleRecipe.RecipeOutput output = this.currentRecipe.getCraftingOutput(this.craftingInv);
            this.rpCost.m_6422_(CraftingUtils.craftingCost(this.type, Platform.INSTANCE.getPlayerData(this.craftingInv.getPlayer()).orElseThrow(EntityUtils::playerDataException), this.currentRecipe, output.bonusItems(), output.clientResult().m_41720_() != ModItems.UNKNOWN.get()));
            trueOutput = output.serverResult();
            clientOutput = output.clientResult();
        } else {
            trueOutput = ItemStack.f_41583_;
            clientOutput = ItemStack.f_41583_;
            this.rpCost.m_6422_(-1);
            this.currentRecipe = null;
        }
        this.outPutInv.m_6836_(0, trueOutput);
        this.outPutInv.m_6836_(1, clientOutput);
        Player player = this.craftingInv.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (this.updatedRecipes) {
                Platform.INSTANCE.getPlayerData((Player)player2).ifPresent(data -> this.sendCraftingRecipesToClient(player2, (PlayerData)data));
            }
            player2.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, clientOutput));
        }
        this.updatedRecipes = false;
    }

    public void sendCraftingRecipesToClient(ServerPlayer player, PlayerData data) {
        List<Pair<Integer, ItemStack>> clientData = IntStream.range(0, this.matchingRecipes.size()).mapToObj(i -> {
            SextupleRecipe recipe = this.matchingRecipes.get(i);
            return Pair.of((Object)i, (Object)(recipe instanceof SpecialSextupleRecipe || data.getRecipeKeeper().isUnlocked(recipe) ? this.matchingRecipes.get(i).m_8043_() : new ItemStack((ItemLike)ModItems.UNKNOWN.get())));
        }).toList();
        if (!this.init) {
            Platform.INSTANCE.sendToClient(new S2CCraftingRecipes(clientData, 0), player);
        } else {
            player.m_20194_().m_6937_((Runnable)new TickTask(1, () -> Platform.INSTANCE.sendToClient(new S2CCraftingRecipes(clientData, this.currentRecipe == null ? 0 : this.matchingRecipes.indexOf(this.currentRecipe)), player)));
        }
    }

    public SextupleRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void updateCurrentRecipeIndex(int id) {
        id = Mth.m_14045_((int)id, (int)0, (int)(this.matchingRecipes != null ? this.matchingRecipes.size() - 1 : 0));
        this.tile.setIndex(id);
        this.updateCraftingSlot();
    }

    public int rpCost() {
        return this.rpCost.m_6501_();
    }

    public void m_38946_() {
        int i;
        AbstractContainerMenuAccessor acc = (AbstractContainerMenuAccessor)((Object)this);
        for (i = 0; i < this.f_38839_.size(); ++i) {
            ItemStack itemStack;
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot instanceof CraftingOutputSlot) {
                CraftingOutputSlot outputSlot = (CraftingOutputSlot)slot;
                itemStack = outputSlot.getStackToSync();
            } else {
                itemStack = ((Slot)this.f_38839_.get(i)).m_7993_();
            }
            ItemStack itemStack2 = itemStack;
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemStack2).m_41777_());
            acc.doTriggerSlotListeners(i, itemStack2, (Supplier<ItemStack>)supplier);
            acc.doSynchronizeSlotToRemote(i, itemStack2, (Supplier<ItemStack>)supplier);
        }
        acc.doSynchronizeCarriedToRemote();
        for (i = 0; i < acc.getDataSlots().size(); ++i) {
            DataSlot dataSlot = acc.getDataSlots().get(i);
            int j = dataSlot.m_6501_();
            if (dataSlot.m_39409_()) {
                acc.doUpdateDataSlotListeners(i, j);
            }
            acc.doSynchronizeDataSlotToRemote(i, j);
        }
    }

    public void m_150429_() {
        int i;
        AbstractContainerMenuAccessor acc = (AbstractContainerMenuAccessor)((Object)this);
        for (i = 0; i < this.f_38839_.size(); ++i) {
            ItemStack itemStack;
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot instanceof CraftingOutputSlot) {
                CraftingOutputSlot outputSlot = (CraftingOutputSlot)slot;
                itemStack = outputSlot.getStackToSync();
            } else {
                itemStack = ((Slot)this.f_38839_.get(i)).m_7993_();
            }
            ItemStack itemStack2 = itemStack;
            this.m_150404_(i, itemStack2.m_41777_());
        }
        this.m_150422_(this.m_142621_());
        for (i = 0; i < acc.getDataSlots().size(); ++i) {
            acc.getRemoteDataSlots().set(i, acc.getDataSlots().get(i).m_6501_());
        }
        if (acc.getSynchronizer() != null) {
            acc.getSynchronizer().m_142589_((AbstractContainerMenu)this, acc.getRemoteSlots(), acc.getRemoteCarried(), acc.getRemoteDataSlots().toIntArray());
        }
    }

    public ItemStack m_7648_(Player player, int slotID) {
        if (!player.m_6084_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotID);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotID == 0) {
                itemstack1.m_41678_(player.f_19853_, player, itemstack1.m_41613_());
                Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.onCrafted(player));
                if (!this.m_38903_(itemstack1, 1, 37, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotID < 37 ? !this.m_38903_(itemstack1, 37, this.f_38839_.size(), false) : !this.m_38903_(itemstack1, 1, 37, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            if (slotID == 0) {
                player.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void m_6877_(Player entity) {
        super.m_6877_(entity);
    }

    public void m_6199_(Container inv) {
        if (inv == this.craftingInv) {
            this.updateCraftingOutput(false);
        }
        super.m_6199_(inv);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public List<Pair<Integer, ItemStack>> getMatchingRecipesClient() {
        return this.matchingRecipesClient;
    }

    public void setMatchingRecipesClient(List<Pair<Integer, ItemStack>> matchingRecipesClient) {
        this.matchingRecipesClient = matchingRecipesClient;
    }
}

