/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.inventory.DummyInventory;
import io.github.flemmli97.runecraftory.common.inventory.InventorySpells;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.registry.ModContainer;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ContainerInfoScreen
extends AbstractContainerMenu {
    public static final String TITLE = "runecraftory.container.info";
    public static final String TITLE_SUB = "runecraftory.container.info.sub";
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final boolean main;

    public ContainerInfoScreen(int windowId, final Inventory playerInventory, boolean main) {
        super(main ? (MenuType)ModContainer.INFO_CONTAINER.get() : (MenuType)ModContainer.INFO_SUB_CONTAINER.get(), windowId);
        this.main = main;
        final InventorySpells playerSpells = Platform.INSTANCE.getPlayerData(playerInventory.f_35978_).map(PlayerData::getInv).orElse(null);
        if (playerSpells == null) {
            return;
        }
        DummyInventory iinv = new DummyInventory(playerSpells){

            @Override
            public int m_6893_() {
                return 1;
            }

            @Override
            public boolean m_6542_(Player player) {
                return true;
            }
        };
        if (this.main) {
            for (int i = 0; i < 9; ++i) {
                this.m_38897_(new Slot((Container)playerInventory, i, 32 + i * 18, 175));
            }
            for (int y = 0; y < 3; ++y) {
                for (int i = 0; i < 9; ++i) {
                    this.m_38897_(new Slot((Container)playerInventory, i + (y + 1) * 9, 32 + i * 18, 117 + y * 18));
                }
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.m_38897_(new Slot((Container)playerInventory, 36 + (3 - k), 14, 13 + k * 18){

                public boolean m_5857_(ItemStack stack) {
                    return Platform.INSTANCE.canEquip(stack, equipmentslottype, (LivingEntity)playerInventory.f_35978_);
                }

                public int m_6641_() {
                    return 1;
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.m_20749_()]);
                }

                public boolean m_8010_(Player player) {
                    ItemStack itemstack = this.m_7993_();
                    return (itemstack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(player);
                }
            });
        }
        this.m_38897_(new Slot((Container)playerInventory, 40, 49, 85){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        for (int m = 0; m < 4; ++m) {
            this.m_38897_(new Slot(iinv, m, 84, 13 + m * 18){

                public boolean m_5857_(ItemStack stack) {
                    return playerSpells.m_7013_(this.f_40219_, stack);
                }
            });
        }
    }

    public static MenuProvider create() {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent(ContainerInfoScreen.TITLE);
            }

            public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
                return new ContainerInfoScreen(windowID, inv, true);
            }
        };
    }

    public static MenuProvider createSub() {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent(ContainerInfoScreen.TITLE_SUB);
            }

            public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
                return new ContainerInfoScreen(windowID, inv, false);
            }
        };
    }

    public ItemStack m_7648_(Player player, int slotID) {
        if (this.main) {
            ItemStack itemstack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(slotID);
            if (slot != null && slot.m_6657_()) {
                ItemStack itemstack1 = slot.m_7993_();
                itemstack = itemstack1.m_41777_();
                EquipmentSlot slotType = LivingEntity.m_147233_((ItemStack)itemstack);
                if (slotType.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(39 - slotType.m_20749_())).m_6657_()) {
                    int i = 39 - slotType.m_20749_();
                    if (!this.m_38903_(itemstack1, i, i + 1, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (slotType == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(40)).m_6657_()) {
                    if (!this.m_38903_(itemstack1, 40, 41, false)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    if (itemstack.m_41720_() instanceof ItemSpell && slotID < 41 && !this.m_38903_(itemstack1, 41, 45, false)) {
                        return ItemStack.f_41583_;
                    }
                    if (slotID >= 0 && slotID < 9 ? !this.m_38903_(itemstack1, 9, 36, false) : !this.m_38903_(itemstack1, 0, 36, false)) {
                        return ItemStack.f_41583_;
                    }
                }
                if (itemstack1.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(player, itemstack1);
                if (slotID == 0) {
                    player.m_36176_(itemstack1, false);
                }
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slot, int mode, ClickType type, Player player) {
        if (this.main) {
            super.m_150399_(slot, mode, type, player);
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

