/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.EnumShopResult;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShop;
import io.github.flemmli97.runecraftory.common.network.S2CShopResponses;
import io.github.flemmli97.runecraftory.common.registry.ModContainer;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ContainerShop
extends AbstractContainerMenu {
    private final InventoryShop invShop;
    private final DataSlot price;
    private final DataSlot next;
    private final DataSlot prev;

    public ContainerShop(int windowID, Inventory playerInv, FriendlyByteBuf buffer) {
        this(windowID, playerInv, ContainerShop.read(playerInv.f_35978_.f_19853_, buffer));
    }

    public ContainerShop(int windowID, Inventory playerInv, InventoryShop invShop) {
        super((MenuType)ModContainer.SHOP_CONTAINER.get(), windowID);
        this.invShop = invShop;
        if (this.invShop == null) {
            throw new IllegalStateException("Tried creating a shop container but shop inventory was null");
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.m_38897_(new Slot(this.invShop, x + y * 5, 13 + x * 21, 28 + y * 21){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }

                    public boolean m_8010_(Player player) {
                        return false;
                    }
                });
            }
        }
        this.m_38897_(new Slot(this.invShop, 30, 200, 144){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return false;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 13 + j * 18, 135 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 13 + k * 18, 193));
        }
        this.price = DataSlot.m_39401_();
        this.m_38895_(this.price);
        this.next = DataSlot.m_39401_();
        this.m_38895_(this.next);
        this.prev = DataSlot.m_39401_();
        this.m_38895_(this.prev);
        this.next.m_6422_(this.invShop.hasNext() ? 1 : 0);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        if (index <= 30) {
            return ItemStack.f_41583_;
        }
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack slotItem = slot.m_7993_();
        ItemStack slotCopy = slotItem.m_41777_();
        if (index < 58 ? !this.m_38903_(slotItem, 58, 67, false) : !this.m_38903_(slotItem, 31, 58, false)) {
            return ItemStack.f_41583_;
        }
        if (slotItem.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (slotItem.m_41613_() == slotCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return slotCopy;
    }

    public void m_150399_(int slot, int mouse, ClickType clickType, Player player) {
        if (slot > 30 || slot < 0) {
            super.m_150399_(slot, mouse, clickType, player);
            return;
        }
        if (slot == 30) {
            Slot shopOutput = this.m_38853_(30);
            if (shopOutput.m_6657_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EnumShopResult res = ItemUtils.buyItem(player, this.invShop.npc, shopOutput.m_7993_().m_41777_());
                TranslatableComponent txt = switch (res) {
                    default -> throw new IncompatibleClassChangeError();
                    case EnumShopResult.NOMONEY -> new TranslatableComponent("runecraftory.npc.shop.money.no");
                    case EnumShopResult.NOSPACE -> new TranslatableComponent("runecraftory.npc.shop.inventory.full");
                    case EnumShopResult.SUCCESS -> new TranslatableComponent("runecraftory.npc.shop.success");
                };
                Platform.INSTANCE.sendToClient(new S2CShopResponses((Component)txt), serverPlayer);
                if (res == EnumShopResult.SUCCESS) {
                    shopOutput.m_5852_(ItemStack.f_41583_);
                }
            }
            return;
        }
        if (clickType == ClickType.QUICK_MOVE || clickType == ClickType.PICKUP || clickType == ClickType.PICKUP_ALL) {
            int count;
            ItemStack clickedStack = this.m_38853_(slot).m_7993_();
            if (clickedStack.m_41619_()) {
                return;
            }
            Slot shopOutput = this.m_38853_(30);
            int n = count = clickType == ClickType.QUICK_MOVE ? 10 : 1;
            if (mouse == 1) {
                count = -count;
            }
            boolean changed = false;
            if (!shopOutput.m_6657_() || !ItemStack.m_150942_((ItemStack)clickedStack, (ItemStack)shopOutput.m_7993_())) {
                if (count > 0) {
                    ItemStack copy = clickedStack.m_41777_();
                    copy.m_41764_(count);
                    shopOutput.m_5852_(copy);
                    changed = true;
                }
            } else {
                shopOutput.m_7993_().m_41764_(Math.min(shopOutput.m_7993_().m_41741_() * 36, shopOutput.m_7993_().m_41613_() + count));
                changed = true;
            }
            if (changed) {
                if (shopOutput.m_6657_()) {
                    this.price.m_6422_(ItemUtils.getBuyPrice(shopOutput.m_7993_()) * shopOutput.m_7993_().m_41613_());
                } else {
                    this.price.m_6422_(0);
                }
            }
            this.m_38946_();
        }
    }

    public int getCurrentCost() {
        return this.price.m_6501_();
    }

    public EntityNPCBase getShopOwner() {
        return this.invShop.npc;
    }

    private static InventoryShop read(Level level, FriendlyByteBuf buf) {
        Entity entity = level.m_6815_(buf.readInt());
        if (entity instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)entity;
            NonNullList list = NonNullList.m_122779_();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                list.add((Object)((ItemStack)buf.m_130057_(ItemStack.f_41582_)));
            }
            return new InventoryShop(npc, (NonNullList<ItemStack>)list);
        }
        return null;
    }

    public void prev() {
        this.invShop.prev();
        this.m_38946_();
        this.next.m_6422_(this.invShop.hasPrev() ? 1 : 0);
    }

    public void next() {
        this.invShop.next();
        this.m_38946_();
        this.next.m_6422_(this.invShop.hasNext() ? 1 : 0);
    }

    public boolean hasNext() {
        return this.next.m_6501_() == 1;
    }

    public boolean hasPrev() {
        return this.prev.m_6501_() == 1;
    }
}

