/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.common.blocks.tile.UpgradingCraftingBlockEntity;
import io.github.flemmli97.runecraftory.common.inventory.DummyInventory;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.inventory.container.UpgradeOutputSlot;
import io.github.flemmli97.runecraftory.common.registry.ModContainer;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ContainerUpgrade
extends AbstractContainerMenu {
    private final PlayerContainerInv craftingInv;
    private final EnumCrafting type;
    private final DummyInventory outPutInv = new DummyInventory((Container)new SimpleContainer(1));
    private final DataSlot rpCost;

    public ContainerUpgrade(int windowId, Inventory inv, FriendlyByteBuf data) {
        this(windowId, inv, ContainerUpgrade.getTile(inv.f_35978_.f_19853_, data));
    }

    public ContainerUpgrade(int windowId, Inventory playerInv, UpgradingCraftingBlockEntity tile) {
        super((MenuType)ModContainer.UPGRADE_CONTAINER.get(), windowId);
        this.craftingInv = PlayerContainerInv.create(this, tile.getUpgradeInventory(), playerInv.f_35978_);
        this.type = tile.craftingType();
        this.m_38897_(new UpgradeOutputSlot(this.outPutInv, this, this.craftingInv, 0, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        this.m_38897_(new Slot(this.craftingInv, 0, 20, 35){

            public boolean m_5857_(ItemStack stack) {
                return this.f_40218_.m_7013_(0, stack);
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.craftingInv, 1, 56, 35){

            public boolean m_5857_(ItemStack stack) {
                return this.f_40218_.m_7013_(1, stack);
            }
        });
        this.rpCost = DataSlot.m_39401_();
        this.m_38895_(this.rpCost);
        this.updateOutput();
    }

    public static UpgradingCraftingBlockEntity getTile(Level world, FriendlyByteBuf buffer) {
        BlockEntity blockEntity = world.m_7702_(buffer.m_130135_());
        if (blockEntity instanceof UpgradingCraftingBlockEntity) {
            return (UpgradingCraftingBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Expected tile entity of type TileCrafting but got " + String.valueOf(blockEntity));
    }

    private void updateOutput() {
        if (this.craftingInv.getPlayer().f_19853_.f_46443_) {
            return;
        }
        int cost = CraftingUtils.upgradeCost(this.craftingType(), Platform.INSTANCE.getPlayerData(this.craftingInv.getPlayer()).orElseThrow(EntityUtils::playerDataException), this.craftingInv.m_8020_(0), this.craftingInv.m_8020_(1));
        if (cost >= 0) {
            this.outPutInv.m_6836_(0, CraftingUtils.getUpgradedStack(this.craftingInv.m_8020_(0), this.craftingInv.m_8020_(1), this.craftingType()));
        } else {
            this.outPutInv.m_6836_(0, ItemStack.f_41583_);
        }
        this.rpCost.m_6422_(cost);
    }

    public EnumCrafting craftingType() {
        return this.type;
    }

    public int rpCost() {
        return this.rpCost.m_6501_();
    }

    public ItemStack m_7648_(Player player, int slotID) {
        if (!player.m_6084_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotID);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotID == 0) {
                itemstack1.m_41678_(player.f_19853_, player, itemstack1.m_41613_());
                if (!this.m_38903_(itemstack1, 1, 37, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotID < 37 ? !this.m_38903_(itemstack1, 37, this.f_38839_.size(), false) : !this.m_38903_(itemstack1, 1, 37, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            if (slotID == 0) {
                player.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void m_6199_(Container inv) {
        if (inv == this.craftingInv) {
            this.updateOutput();
        }
        super.m_6199_(inv);
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

