/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CraftingOutputSlot
extends Slot {
    private final PlayerContainerInv ingredientInv;
    private final ContainerCrafting craftingContainer;
    private int amountCrafted;
    private final int id;

    public CraftingOutputSlot(Container output, ContainerCrafting container, PlayerContainerInv ingredientInv, int id, int x, int y) {
        super(output, id, x, y);
        this.ingredientInv = ingredientInv;
        this.craftingContainer = container;
        this.id = id;
    }

    public ItemStack getStackToSync() {
        return this.f_40218_.m_8020_(this.id + 1);
    }

    protected void m_7169_(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.m_5845_(stack);
    }

    protected void m_6405_(int amount) {
        super.m_6405_(amount);
        this.amountCrafted += amount;
    }

    protected void m_5845_(ItemStack stack) {
        Player player = this.ingredientInv.getPlayer();
        if (this.amountCrafted > 0) {
            stack.m_41678_(player.f_19853_, player, this.amountCrafted);
            Platform.INSTANCE.craftingEvent(player, stack, this.ingredientInv);
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.onCrafted(player));
        }
        this.amountCrafted = 0;
    }

    public void m_142406_(Player player, ItemStack stack) {
        NonNullList remaining;
        this.m_5845_(stack);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NonNullList nonNullList = remaining = this.craftingContainer.getCurrentRecipe() != null ? this.craftingContainer.getCurrentRecipe().m_7457_(this.ingredientInv) : NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
        if (this.craftingContainer.rpCost() >= 0) {
            Platform.INSTANCE.getPlayerData(player).ifPresent(data -> {
                data.decreaseRunePoints(player, this.craftingContainer.rpCost(), true);
                SextupleRecipe recipe = this.craftingContainer.getCurrentRecipe();
                if (recipe != null && !recipe.m_5598_() && !data.getRecipeKeeper().isUnlocked(recipe)) {
                    data.getRecipeKeeper().unlockRecipe(player, recipe);
                    this.craftingContainer.sendCraftingRecipesToClient(serverPlayer, (PlayerData)data);
                }
                switch (this.craftingContainer.craftingType()) {
                    case FORGE: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.FORGING, this.craftingContainer.getCurrentRecipe());
                        break;
                    }
                    case ARMOR: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.CRAFTING, this.craftingContainer.getCurrentRecipe());
                        break;
                    }
                    case CHEM: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.CHEMISTRY, this.craftingContainer.getCurrentRecipe());
                        break;
                    }
                    case COOKING: {
                        CraftingUtils.giveCraftingXPTo(serverPlayer, data, EnumSkills.COOKING, this.craftingContainer.getCurrentRecipe());
                    }
                }
            });
        }
        if (ItemNBT.usedLightOre(stack)) {
            ModCriteria.LIGHT_ORE.trigger(serverPlayer);
        }
        switch (this.craftingContainer.craftingType()) {
            case FORGE: {
                ModCriteria.FORGING.trigger(serverPlayer);
                break;
            }
            case ARMOR: {
                ModCriteria.CRAFTING.trigger(serverPlayer);
                break;
            }
            case CHEM: {
                ModCriteria.MEDICINE.trigger(serverPlayer);
                break;
            }
            case COOKING: {
                ModCriteria.COOKING.trigger(serverPlayer);
            }
        }
        boolean refreshRecipe = false;
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack itemstack = this.ingredientInv.m_8020_(i);
            ItemStack remainingStack = (ItemStack)remaining.get(i);
            if (!itemstack.m_41619_()) {
                this.ingredientInv.m_7407_(i, 1);
                itemstack = this.ingredientInv.m_8020_(i);
                if (itemstack.m_41619_()) {
                    refreshRecipe = true;
                }
            }
            if (remainingStack.m_41619_()) continue;
            if (itemstack.m_41619_()) {
                this.ingredientInv.m_6836_(i, remainingStack);
                continue;
            }
            if (ItemStack.m_41746_((ItemStack)itemstack, (ItemStack)remainingStack) && ItemStack.m_41658_((ItemStack)itemstack, (ItemStack)remainingStack)) {
                remainingStack.m_41769_(itemstack.m_41613_());
                this.ingredientInv.m_6836_(i, remainingStack);
                continue;
            }
            if (player.m_150109_().m_36054_(remainingStack)) continue;
            player.m_36176_(remainingStack, false);
        }
        if (refreshRecipe) {
            this.craftingContainer.m_6199_(this.ingredientInv);
        }
        super.m_142406_(player, stack);
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public ItemStack m_6201_(int amount) {
        if (this.m_6657_()) {
            this.amountCrafted += Math.min(amount, this.m_7993_().m_41613_());
        }
        return super.m_6201_(amount);
    }

    public boolean m_8010_(Player player) {
        if (!GeneralConfig.useRp) {
            return true;
        }
        return player.m_7500_() || Platform.INSTANCE.getPlayerData(player).map(data -> data.getMaxRunePoints() >= this.craftingContainer.rpCost()).orElse(false) != false;
    }
}

