/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.inventory.PlayerContainerInv;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerUpgrade;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class UpgradeOutputSlot
extends Slot {
    private final PlayerContainerInv ingredientInv;
    private final ContainerUpgrade container;
    private int amountCrafted;

    public UpgradeOutputSlot(Container output, ContainerUpgrade container, PlayerContainerInv ingredientInv, int id, int x, int y) {
        super(output, id, x, y);
        this.ingredientInv = ingredientInv;
        this.container = container;
    }

    protected void m_7169_(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.m_5845_(stack);
    }

    protected void m_6405_(int amount) {
        super.m_6405_(amount);
        this.amountCrafted += amount;
    }

    protected void m_5845_(ItemStack stack) {
        Player player = this.ingredientInv.getPlayer();
        if (this.amountCrafted > 0) {
            stack.m_41678_(player.f_19853_, player, this.amountCrafted);
            Platform.INSTANCE.craftingEvent(player, stack, this.ingredientInv);
        }
        this.amountCrafted = 0;
    }

    public void m_142406_(Player player, ItemStack stack) {
        this.m_5845_(stack);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack toUpgrade = this.ingredientInv.m_8020_(0);
        ItemStack material = this.ingredientInv.m_8020_(1);
        ModCriteria.UPGRADE_ITEM.trigger(serverPlayer);
        if (ItemNBT.getElement(toUpgrade) != ItemNBT.getElement(stack)) {
            ModCriteria.CHANGE_ELEMENT.trigger(serverPlayer);
        }
        Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(data -> {
            if (stack.m_41720_() instanceof ItemStaffBase && DataPackHandler.INSTANCE.itemStatManager().get(material.m_41720_()).map(s -> s.getTier1Spell() != null || s.getTier2Spell() != null || s.getTier3Spell() != null).orElse(false).booleanValue()) {
                ModCriteria.CHANGE_SPELL.trigger(serverPlayer);
            }
            data.decreaseRunePoints(player, this.container.rpCost(), true);
            switch (this.container.craftingType()) {
                case FORGE: {
                    CraftingUtils.giveUpgradeXPTo(serverPlayer, data, EnumSkills.FORGING, toUpgrade, material);
                    break;
                }
                case ARMOR: {
                    CraftingUtils.giveUpgradeXPTo(serverPlayer, data, EnumSkills.CRAFTING, toUpgrade, material);
                }
            }
        });
        ItemStack ing1 = this.ingredientInv.m_8020_(0);
        ItemStack ing2 = this.ingredientInv.m_8020_(1);
        if (!ing1.m_41619_()) {
            this.ingredientInv.m_7407_(0, 1);
            ing1 = this.ingredientInv.m_8020_(0);
        }
        if (!ing2.m_41619_()) {
            this.ingredientInv.m_7407_(1, 1);
            ing2 = this.ingredientInv.m_8020_(1);
        }
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (ing1.m_41619_() || ing2.m_41619_()) {
            this.container.m_6199_(this.ingredientInv);
        }
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public ItemStack m_6201_(int amount) {
        if (this.m_6657_()) {
            this.amountCrafted += Math.min(amount, this.m_7993_().m_41613_());
        }
        return super.m_6201_(amount);
    }

    public boolean m_8010_(Player player) {
        return CraftingUtils.canUpgrade(player, this.container.craftingType(), this.ingredientInv.m_8020_(0), this.ingredientInv.m_8020_(1)) && (player.m_7500_() || Platform.INSTANCE.getPlayerData(player).map(data -> data.getMaxRunePoints() >= this.container.rpCost()).orElse(false) != false);
    }
}

