/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class BabySpawnEgg
extends Item {
    public BabySpawnEgg(Item.Properties props) {
        super(props);
    }

    public static ItemStack createBabyFrom(EntityNPCBase baby, Component playerName, UUID father, UUID mother) {
        CompoundTag tag = baby.m_20240_(new CompoundTag());
        tag.m_128473_("Pos");
        tag.m_128473_("UUID");
        tag.m_128473_("Motion");
        tag.m_128473_("Rotation");
        ItemStack stack = new ItemStack((ItemLike)ModItems.NPC_BABY.get());
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_("EntityTag", (Tag)tag);
        stackTag.m_128379_("Boy", baby.isMale());
        stackTag.m_128379_("NeedsName", !baby.hasDataName());
        stackTag.m_128362_("Father", father);
        stackTag.m_128362_("Mother", mother);
        stackTag.m_128359_("PlayerName", Component.Serializer.m_130703_((Component)playerName));
        return stack;
    }

    public static boolean isBoy(ItemStack stack) {
        return !stack.m_41782_() || stack.m_41783_().m_128471_("Boy");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)(BabySpawnEgg.isBoy(stack) ? new TranslatableComponent("runecraftory.tooltip.baby.boy").m_130940_(ChatFormatting.BLUE) : new TranslatableComponent("runecraftory.tooltip.baby.girl").m_130940_(ChatFormatting.RED)));
        Component name = this.getPlayerName(stack);
        if (name != null) {
            tooltipComponents.add((Component)new TranslatableComponent("runecraftory.tooltip.baby.owner", new Object[]{name}).m_130940_(ChatFormatting.GOLD));
        }
    }

    public Component getPlayerName(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null && compoundTag.m_128441_("PlayerName")) {
            try {
                MutableComponent component = Component.Serializer.m_130701_((String)compoundTag.m_128461_("PlayerName"));
                if (component != null) {
                    return component;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Component getEntityName(ItemStack stack) {
        return stack.m_41788_() ? stack.m_41786_() : null;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.m_43722_();
        BlockPos blockpos = ctx.m_8083_();
        Direction direction = ctx.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_142300_(direction);
        Entity e = this.spawnEntity((ServerLevel)world, ctx.m_43723_(), stack, blockpos1, MobSpawnType.SPAWN_EGG, true, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (e != null) {
            stack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult raytraceresult = BabySpawnEgg.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        BlockPos blockpos = raytraceresult.m_82425_();
        if (!(world.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (world.m_7966_(player, blockpos) && player.m_36204_(blockpos, raytraceresult.m_82434_(), stack)) {
            Entity e = this.spawnEntity((ServerLevel)world, player, stack, blockpos, MobSpawnType.SPAWN_EGG, true, true, false);
            if (e != null) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private Entity spawnEntity(ServerLevel world, Player player, ItemStack stack, BlockPos pos, MobSpawnType reason, boolean forgeCheck, boolean updateLocation, boolean doCollisionOffset) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        EntityType type = (EntityType)ModEntities.NPC.get();
        Component customName = this.getEntityName(stack);
        if (customName == null && tag.m_128471_("NeedsName")) {
            if (player != null) {
                player.m_6352_((Component)new TranslatableComponent("runecraftory.npc.spawn.name.missing"), Util.f_137441_);
            }
            return null;
        }
        Entity e = type.m_20655_(world, tag, null, player, pos, reason, updateLocation, doCollisionOffset);
        if (e instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)e;
            if (forgeCheck && EventCalls.INSTANCE.specialSpawnCall((Mob)e, (Level)world, (float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_(), null, reason)) {
                return null;
            }
            npc.tryUpdateName(customName);
            npc.getFamily().setFather(tag.m_128342_("Father"));
            npc.getFamily().setMother(tag.m_128342_("Mother"));
            world.m_47205_(e);
            return e;
        }
        return null;
    }
}

