/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.consumables;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumCrafting;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.crafting.ForgingRecipe;
import io.github.flemmli97.runecraftory.common.crafting.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemDualBladeBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemGloveBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemHammerBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemLongSwordBase;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpearBase;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemRecipeBread
extends Item {
    private final EnumCrafting type;

    public ItemRecipeBread(EnumCrafting type, Item.Properties props) {
        super(props);
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        block5: {
            block4: {
                ServerPlayer player;
                if (living instanceof ServerPlayer) {
                    player = (ServerPlayer)living;
                    int amount = Math.max(1, ItemNBT.itemLevel(stack) / 3);
                    Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                        HashMap grouped = new HashMap();
                        player.m_20194_().m_129894_().m_44013_(CraftingUtils.getType(this.type)).stream().filter(r -> ItemRecipeBread.canUnlockRecipe(r, data, this.getSkill())).forEach(r -> grouped.computeIfAbsent(Pair.of((Object)r.m_8043_().m_41720_(), (Object)r.getCraftingLevel()), k -> new ArrayList()).add(r));
                        ArrayList unlocked = new ArrayList();
                        grouped.entrySet().stream().sorted(Comparator.comparingInt(p -> (Integer)((Pair)p.getKey()).getSecond())).limit(amount).forEach(r -> unlocked.addAll((Collection)r.getValue()));
                        data.getRecipeKeeper().unlockRecipes((Player)player, unlocked);
                        if (unlocked.isEmpty()) {
                            player.m_6352_((Component)new TranslatableComponent("runecraftory.misc.recipe.eat.fail"), Util.f_137441_);
                        }
                    });
                }
                level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
                if (!(living instanceof Player)) break block4;
                player = (Player)living;
                if (player.m_150110_().f_35937_) break block5;
            }
            stack.m_41774_(1);
        }
        return stack;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    private EnumSkills getSkill() {
        return switch (this.type) {
            case EnumCrafting.FORGE -> EnumSkills.FORGING;
            case EnumCrafting.ARMOR -> EnumSkills.CRAFTING;
            case EnumCrafting.CHEM -> EnumSkills.CHEMISTRY;
            default -> EnumSkills.COOKING;
        };
    }

    private static boolean canUnlockRecipe(SextupleRecipe r, PlayerData data, EnumSkills skill) {
        if (r instanceof ForgingRecipe) {
            boolean weaponSkillCheck = true;
            Item res = r.m_8043_().m_41720_();
            if (res instanceof ItemLongSwordBase) {
                weaponSkillCheck = r.getCraftingLevel() - data.getSkillLevel(EnumSkills.LONGSWORD).getLevel() <= 5;
            } else if (res instanceof ItemDualBladeBase) {
                weaponSkillCheck = r.getCraftingLevel() - data.getSkillLevel(EnumSkills.DUAL).getLevel() <= 5;
            } else if (res instanceof SwordItem) {
                weaponSkillCheck = r.getCraftingLevel() - data.getSkillLevel(EnumSkills.SHORTSWORD).getLevel() <= 5;
            } else if (res instanceof ItemSpearBase) {
                weaponSkillCheck = r.getCraftingLevel() - data.getSkillLevel(EnumSkills.SPEAR).getLevel() <= 5;
            } else if (res instanceof ItemHammerBase || res instanceof AxeItem) {
                weaponSkillCheck = r.getCraftingLevel() - data.getSkillLevel(EnumSkills.HAMMERAXE).getLevel() <= 5;
            } else if (res instanceof ItemGloveBase) {
                weaponSkillCheck = r.getCraftingLevel() - data.getSkillLevel(EnumSkills.FIST).getLevel() <= 5;
            }
            return weaponSkillCheck && !data.getRecipeKeeper().isUnlocked(r) && r.getCraftingLevel() - data.getSkillLevel(skill).getLevel() <= 5;
        }
        return !data.getRecipeKeeper().isUnlocked(r) && r.getCraftingLevel() - data.getSkillLevel(skill).getLevel() <= 5;
    }
}

