/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.creative;

import io.github.flemmli97.runecraftory.common.blocks.tile.BossSpawnerBlockEntity;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.items.creative.RuneCraftoryEggItem;
import io.github.flemmli97.runecraftory.common.network.S2CSpawnEggScreen;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EnsembleEggItem
extends SpawnEgg {
    public EnsembleEggItem(Supplier<? extends EntityType<?>> type, int primary, int secondary, Item.Properties props) {
        super(type, primary, secondary, props);
    }

    public boolean onEntitySpawned(Entity e, ItemStack stack, Player player) {
        if (e instanceof EnsembleMonsters) {
            EnsembleMonsters mob = (EnsembleMonsters)e;
            mob.setLevel(RuneCraftoryEggItem.getMobLevel(stack));
        }
        return super.onEntitySpawned(e, stack, player);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        InteractionResultHolder res = super.m_7203_(world, player, hand);
        if (res.m_19089_() == InteractionResult.PASS) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Platform.INSTANCE.sendToClient(new S2CSpawnEggScreen(hand), serverPlayer);
            }
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        return res;
    }

    public InteractionResult onBlockUse(ItemStack stack, BlockPos pos, BlockState state, @Nullable BlockEntity tile) {
        if (tile instanceof BossSpawnerBlockEntity) {
            ((BossSpawnerBlockEntity)tile).setEntity(this.m_43228_(stack.m_41783_()));
            return InteractionResult.SUCCESS;
        }
        return super.onBlockUse(stack, pos, state, tile);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)new TranslatableComponent("runecraftory.tooltip.item.spawn").m_130940_(ChatFormatting.GOLD));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

