/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.creative;

import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import io.github.flemmli97.tenshilib.common.item.AnimationDebugger;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ItemDebug
extends AnimationDebugger
implements IExtendedWeapon {
    private static final String ITEM_MODE = "runecraftory:debug_mode";

    public ItemDebug(Item.Properties props) {
        super(props);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, components, isAdvanced);
        components.add((Component)new TranslatableComponent("runecraftory.item.creative.tooltip").m_130940_(ChatFormatting.DARK_RED));
        components.add((Component)new TranslatableComponent("runecraftory.item.creative.tooltip.mode", new Object[]{new TranslatableComponent(this.getCurrentMode((ItemStack)stack).translationKey).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.DARK_RED));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (this.getCurrentMode(player.m_21120_(hand)) == Mode.ANIMATION) {
            return super.m_7203_(level, player, hand);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int lvl = LevelCalc.levelFromPos(serverLevel, Vec3.m_82512_((Vec3i)context.m_8083_()), LevelCalc.playersAround((EntityGetter)serverLevel, Vec3.m_82512_((Vec3i)context.m_8083_()), 256.0));
            context.m_43723_().m_6352_((Component)new TextComponent("GateLevel at pos: " + lvl), Util.f_137441_);
            FarmlandHandler.get(serverLevel.m_142572_()).getData(serverLevel, context.m_8083_()).ifPresent(d -> context.m_43723_().m_6352_((Component)new TextComponent(d.toStringFull()), Util.f_137441_));
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        if (this.getCurrentMode(stack) == Mode.ANIMATION) {
            return super.m_6880_(stack, player, target, usedHand);
        }
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                mob.m_7023_(new Vec3(0.0, 0.0, 5.0));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, player, target, usedHand);
    }

    public float getRange(LivingEntity entity, ItemStack stack) {
        return 4.0f;
    }

    public boolean onServerSwing(LivingEntity entity, ItemStack stack) {
        ServerPlayer player;
        ItemStack main = entity.m_21205_();
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_6144_() && stack == main) {
            this.changeMode(stack);
        }
        return false;
    }

    private void changeMode(ItemStack stack) {
        CompoundTag compound = new CompoundTag();
        if (stack.m_41782_()) {
            compound = stack.m_41783_();
        }
        Mode mode = this.getCurrentMode(stack);
        compound.m_128405_(ITEM_MODE, (mode.ordinal() + 1) % Mode.values().length);
        compound.m_128473_("tenshilib:saved_entity");
        compound.m_128473_("tenshilib:animation");
        stack.m_41751_(compound);
    }

    private Mode getCurrentMode(ItemStack stack) {
        return stack.m_41782_() ? Mode.values()[stack.m_41783_().m_128451_(ITEM_MODE)] : Mode.DEFAULT;
    }

    private static enum Mode {
        DEFAULT("runecraftory.item.creative.tooltip.mode.default"),
        ANIMATION("runecraftory.item.creative.tooltip.mode.animation");

        private final String translationKey;

        private Mode(String translationKey) {
            this.translationKey = translationKey;
        }
    }
}

