/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.creative;

import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.items.creative.RuneCraftoryEggItem;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NPCSpawnEgg
extends RuneCraftoryEggItem {
    public static final String NPC_ID = "NPCId";
    public static final String NPC_SHOP = "Shop";

    public NPCSpawnEgg(Supplier<? extends EntityType<? extends Mob>> type, Item.Properties props) {
        super(type, 4532232, 8211477, props);
    }

    public boolean addToDefaultSpawneggs() {
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)new TranslatableComponent("runecraftory.tooltip.item.npc").m_130940_(ChatFormatting.GOLD));
        tooltipComponents.add((Component)new TranslatableComponent(NPCSpawnEgg.getJob(stack).getTranslationKey()).m_130940_(ChatFormatting.AQUA));
    }

    @Override
    public boolean onEntitySpawned(Entity e, ItemStack stack, Player player) {
        if (e instanceof EntityNPCBase) {
            NPCData data;
            EntityNPCBase npc = (EntityNPCBase)e;
            ResourceLocation id = NPCSpawnEgg.getNpcID(stack);
            if (id != null && (data = DataPackHandler.INSTANCE.npcDataManager().get(id)) != null) {
                npc.setNPCData(data, false);
                return super.onEntitySpawned(e, stack, player);
            }
            NPCJob job = NPCSpawnEgg.getJob(stack);
            if (job != ModNPCJobs.NONE.getSecond()) {
                npc.randomizeData(job, true);
            }
        }
        return super.onEntitySpawned(e, stack, player);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            if (!world.f_46443_) {
                NPCSpawnEgg.next(stack);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public static NPCJob getJob(ItemStack stack) {
        NPCJob job = (NPCJob)ModNPCJobs.NONE.getSecond();
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NPC_SHOP)) {
            job = ModNPCJobs.getFromID(new ResourceLocation(stack.m_41783_().m_128461_(NPC_SHOP)));
        }
        return job;
    }

    public static void setNpcID(ItemStack stack, ResourceLocation id) {
        CompoundTag tag = stack.m_41784_();
        if (id == null) {
            tag.m_128473_(NPC_ID);
        } else {
            tag.m_128359_(NPC_ID, id.toString());
        }
    }

    public static ResourceLocation getNpcID(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NPC_ID)) {
            return new ResourceLocation(stack.m_41783_().m_128461_(NPC_ID));
        }
        return null;
    }

    public static void next(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        List<NPCJob> jobs = ModNPCJobs.allJobs();
        NPCJob current = NPCSpawnEgg.getJob(stack);
        tag.m_128359_(NPC_SHOP, ModNPCJobs.getIDFrom(jobs.get((jobs.indexOf(current) + 1) % jobs.size())).toString());
    }
}

