/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemStatIncrease
extends Item {
    private final Stat stat;

    public ItemStatIncrease(Stat stat, Item.Properties properties) {
        super(properties);
        this.stat = stat;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        boolean shrink = true;
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
            level.m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_11772_, SoundSource.PLAYERS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
            this.increaseStat(stack, level, (Player)serverPlayer);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, stack);
            if (serverPlayer.m_7500_()) {
                shrink = false;
            }
        }
        if (shrink) {
            stack.m_41774_(1);
        }
        return stack;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    private void increaseStat(ItemStack stack, Level level, Player player) {
        Platform.INSTANCE.getPlayerData(player).ifPresent(data -> {
            switch (this.stat) {
                case LEVEL: {
                    data.addXp(player, (float)LevelCalc.xpAmountForLevelUp(data.getPlayerLevel().getLevel()) - data.getPlayerLevel().getXp());
                    break;
                }
                case STR: 
                case INT: 
                case VIT: 
                case HP: {
                    data.increaseStatBonus(player, this.stat);
                }
            }
        });
    }

    public static enum Stat {
        LEVEL,
        HP,
        STR,
        INT,
        VIT;

    }
}

