/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class ItemToolAxe
extends AxeItem
implements IItemUsable {
    public final EnumToolTier tier;

    public ItemToolAxe(EnumToolTier tier, Item.Properties props) {
        super(ItemTiers.TIER, 0.0f, 0.0f, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
        Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.LOGGING, 1.0f));
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.tier == EnumToolTier.PLATINUM ? Rarity.EPIC : Rarity.COMMON;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return ImmutableMultimap.of();
    }
}

