/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityCustomFishingHook;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemToolFishingRod
extends FishingRodItem
implements IItemUsable {
    public final EnumToolTier tier;

    public ItemToolFishingRod(EnumToolTier tier, Item.Properties props) {
        super(props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.tier.getTierLevel() != 0 && Platform.INSTANCE.getEntityData((LivingEntity)player).map(d -> d.fishingHook == null).orElse(false).booleanValue()) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        this.throwRod(world, (LivingEntity)player, itemstack, 0);
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.m_5776_());
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0) {
            int useTime = (stack.m_41779_() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
            int charge = Math.min(useTime, this.tier.getTierLevel());
            this.throwRod(world, entity, stack, charge);
            entity.m_6674_(entity.m_7655_());
        }
        super.m_5551_(stack, world, entity, timeLeft);
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.tier == EnumToolTier.PLATINUM ? Rarity.EPIC : Rarity.COMMON;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    protected void throwRod(Level level, LivingEntity entity, ItemStack itemStack, int charge) {
        EntityCustomFishingHook hook = Platform.INSTANCE.getEntityData(entity).map(d -> d.fishingHook).orElse(null);
        if (hook != null) {
            if (!level.f_46443_) {
                hook.retract(itemStack);
            }
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
            level.m_151545_((Entity)entity, GameEvent.f_157814_, (Entity)entity);
        } else {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
            if (!level.f_46443_) {
                int speed = EnchantmentHelper.m_44916_((ItemStack)itemStack);
                int luck = EnchantmentHelper.m_44904_((ItemStack)itemStack);
                hook = new EntityCustomFishingHook(level, entity, speed + this.tier.getTierLevel(), luck, charge);
                hook.setElement(ItemNBT.getElement(itemStack));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    hook.attackHandlingPlayer(() -> player.m_36335_().m_41521_(itemStack.m_41720_(), 0.0f) <= 0.0f, () -> player.m_36335_().m_41524_(itemStack.m_41720_(), Mth.m_14165_((double)(20.0 * ItemNBT.attackSpeedModifier((LivingEntity)player)))));
                }
                level.m_7967_((Entity)hook);
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            level.m_151545_((Entity)entity, GameEvent.f_157813_, (Entity)entity);
        }
    }
}

