/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.action.ToolUseData;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemToolHammer
extends PickaxeItem
implements IItemUsable {
    public final EnumToolTier tier;

    public ItemToolHammer(EnumToolTier tier, Item.Properties props) {
        super(ItemTiers.TIER, 0, 0.0f, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
    }

    public static void onHammering(ServerPlayer player, boolean level) {
        if (ItemToolHammer.getUseRPFlag(player.m_21205_())) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                LevelCalc.useRP((Player)player, data, 5.0f, true, 0.0f, true, EnumSkills.MINING);
                if (level) {
                    LevelCalc.levelSkill(player, data, EnumSkills.MINING, 10.0f);
                }
            });
        }
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (this.tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx, false);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.tier.getTierLevel() != 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return super.m_6813_(stack, level, state, pos, miningEntity);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                int useTime = data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.TOOL_HAMMER_USE.get())), false) ? data.getWeaponHandler().get(DataKey.TOOL_DATA).charge() : (stack.m_41779_() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
                int range = Math.min(useTime, this.tier.getTierLevel());
                BlockHitResult result = ItemToolHammer.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (range == 0) {
                    if (result != null) {
                        this.useOnBlock(new UseOnContext((Player)entity, entity.m_7655_(), result), false);
                    }
                } else {
                    data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.TOOL_HAMMER_USE.get())), stack);
                    data.getWeaponHandler().store(DataKey.TOOL_DATA, new ToolUseData((HitResult)result, range));
                }
            });
        }
        super.m_5551_(stack, world, entity, timeLeft);
    }

    public static void setDontUseRPFlagTemp(ItemStack stack, boolean flag) {
        if (flag) {
            stack.m_41784_().m_128379_("RFInUseFlag", true);
        } else {
            stack.m_41784_().m_128473_("RFInUseFlag");
            if (stack.m_41783_().m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    private static boolean getUseRPFlag(ItemStack stack) {
        if (stack.m_41782_()) {
            return !stack.m_41784_().m_128471_("RFInUseFlag");
        }
        return true;
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.tier == EnumToolTier.PLATINUM ? Rarity.EPIC : Rarity.COMMON;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    private InteractionResult useOnBlock(UseOnContext ctx, boolean canHammer) {
        Player player = ctx.m_43723_();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = ctx.m_43722_();
        HammerState state = this.hammer((ServerLevel)ctx.m_43725_(), ctx.m_8083_(), stack, (LivingEntity)ctx.m_43723_(), canHammer);
        if (state != HammerState.FAIL) {
            ItemToolHammer.setDontUseRPFlagTemp(stack, false);
            ItemToolHammer.onHammering(player2, state == HammerState.BREAK);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HammerState hammer(ServerLevel world, BlockPos pos, ItemStack stack, LivingEntity entity, boolean canHammer) {
        if (entity instanceof Player && !((Player)entity).m_36204_(pos.m_142300_(Direction.UP), Direction.UP, stack)) {
            return HammerState.FAIL;
        }
        BlockState state = world.m_8055_(pos);
        if (canHammer && state.m_204336_(RunecraftoryTags.HAMMER_BREAKABLE)) {
            if (!(entity instanceof ServerPlayer)) return world.m_7740_(pos, true, (Entity)entity, 3) ? HammerState.BREAK : HammerState.FAIL;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!((ServerPlayer)entity).f_8941_.m_9280_(pos)) return HammerState.FAIL;
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(pos, world.m_8055_(pos)));
            return HammerState.BREAK;
        }
        if (!state.m_204336_(RunecraftoryTags.HAMMER_FLATTENABLE) || world.m_8055_(pos.m_7494_()).m_60767_() != Material.f_76296_ || !world.m_46597_(pos, Block.m_49897_((BlockState)state, (BlockState)Blocks.f_50493_.m_49966_(), (Level)world, (BlockPos)pos))) return HammerState.FAIL;
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return HammerState.FLATTEN;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public static enum HammerState {
        FAIL,
        BREAK,
        FLATTEN;

    }
}

