/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemToolHoe
extends HoeItem
implements IItemUsable {
    public final EnumToolTier tier;

    public ItemToolHoe(EnumToolTier tier, Item.Properties props) {
        super(ItemTiers.TIER, 0, 0.0f, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
        ItemToolHoe.onHoeUse(player);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.tier.getTierLevel() != 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int useTime = (stack.m_41779_() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
            int range = Math.min(useTime, this.tier.getTierLevel());
            BlockHitResult result = ItemToolHoe.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (range == 0) {
                if (result != null) {
                    this.useOnBlock(new UseOnContext((Player)player, entity.m_7655_(), result));
                }
            } else {
                BlockPos pos = entity.m_142538_().m_7495_();
                if (result != null && result.m_6662_() != HitResult.Type.MISS) {
                    pos = result.m_82425_();
                }
                Function<BlockPos, BlockHitResult> hit = bh -> new BlockHitResult(Vec3.m_82512_((Vec3i)bh), Direction.UP, bh, false);
                int amount = (int)BlockPos.m_121990_((BlockPos)pos.m_142082_(-range, 0, -range), (BlockPos)pos.m_142082_(range, 0, range)).filter(p -> this.hoeBlock(new UseOnContext((Player)player, entity.m_7655_(), (BlockHitResult)hit.apply(p.m_7949_())))).count();
                if (amount > 0) {
                    Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                        LevelCalc.useRP((Player)player, data, 0.0f, true, (float)range * 17.5f, true, EnumSkills.FARMING);
                        LevelCalc.levelSkill(player, data, EnumSkills.FARMING, range * 15);
                        LevelCalc.levelSkill(player, data, EnumSkills.EARTH, range * 2);
                    });
                }
            }
        }
        super.m_5551_(stack, world, entity, timeLeft);
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.tier == EnumToolTier.PLATINUM ? Rarity.EPIC : Rarity.COMMON;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (this.tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult useOnBlock(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        if (this.hoeBlock(ctx)) {
            this.onBlockBreak((ServerPlayer)ctx.m_43723_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean hoeBlock(UseOnContext ctx) {
        BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_());
        Pair tille = (Pair)f_41332_.get(state.m_60734_());
        if (tille != null && ((Predicate)tille.getFirst()).test(ctx)) {
            ((Consumer)tille.getSecond()).accept(ctx);
            if (ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60713_(Blocks.f_50093_)) {
                ctx.m_43725_().m_7731_(ctx.m_8083_(), Blocks.f_50093_.m_49966_(), 11);
            }
            ctx.m_43725_().m_5594_(null, ctx.m_8083_(), SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.1f);
            return true;
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public static void onHoeUse(ServerPlayer player) {
        Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
            LevelCalc.useRP((Player)player, data, 3.0f, true, 0.0f, true, EnumSkills.FARMING, EnumSkills.EARTH);
            LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 3.0f);
            LevelCalc.levelSkill(player, data, EnumSkills.EARTH, 1.5f);
        });
    }
}

