/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemToolSickle
extends DiggerItem
implements IItemUsable {
    public final EnumToolTier tier;

    public ItemToolSickle(EnumToolTier tier, Item.Properties props) {
        super(0.0f, 0.0f, ItemTiers.TIER, RunecraftoryTags.SICKLE_EFFECTIVE, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
        Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
            LevelCalc.useRP((Player)player, data, 2.0f, true, 0.0f, true, EnumSkills.FARMING, EnumSkills.WIND);
            LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 3.0f);
            LevelCalc.levelSkill(player, data, EnumSkills.WIND, 2.0f);
        });
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13078_)) {
            return this.f_40980_;
        }
        return super.m_8102_(stack, state);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
            if (this.m_8102_(stack, state) == this.f_40980_) {
                Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(data -> {
                    LevelCalc.levelSkill(serverPlayer, data, EnumSkills.FARMING, 3.0f);
                    LevelCalc.levelSkill(serverPlayer, data, EnumSkills.WIND, 2.0f);
                });
            }
        }
        return super.m_6813_(stack, level, state, pos, entityLiving);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (this.tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.m_21120_(usedHand);
        if (this.tier.getTierLevel() != 0) {
            player.m_6672_(usedHand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int useTime = (stack.m_41779_() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
            int range = Math.min(useTime, this.tier.getTierLevel()) + 2;
            BlockHitResult result = ItemToolSickle.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (range == 0) {
                if (result != null) {
                    this.useOnBlock(new UseOnContext((Player)player, entity.m_7655_(), result));
                }
            } else {
                int amount;
                BlockPos pos = entity.m_142538_();
                if (result != null && result.m_6662_() != HitResult.Type.MISS) {
                    pos = result.m_82425_();
                }
                if ((amount = (int)BlockPos.m_121990_((BlockPos)pos.m_142082_(-range, 0, -range), (BlockPos)pos.m_142082_(range, 0, range)).filter(p -> this.sickleUse(player.m_183503_(), p.m_7949_(), stack, entity)).count()) > 0) {
                    Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                        LevelCalc.useRP((Player)player, data, range * 10, true, 0.0f, true, EnumSkills.FARMING);
                        LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 3.5f);
                        LevelCalc.levelSkill(player, data, EnumSkills.WIND, 2.5f);
                    });
                }
            }
        }
        super.m_5551_(stack, level, entity, timeLeft);
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.tier == EnumToolTier.PLATINUM ? Rarity.EPIC : Rarity.COMMON;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    private InteractionResult useOnBlock(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = ctx.m_43722_();
        if (this.sickleUse(serverLevel, ctx.m_8083_(), stack, (LivingEntity)ctx.m_43723_())) {
            this.onBlockBreak((ServerPlayer)ctx.m_43723_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean sickleUse(ServerLevel level, BlockPos pos, ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_36204_(pos.m_142300_(Direction.UP), Direction.UP, stack)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_204336_(RunecraftoryTags.SICKLE_DESTROYABLE)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (serverPlayer.f_8941_.m_9280_(pos)) {
                    level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(pos, level.m_8055_(pos)));
                    return true;
                }
            } else {
                return level.m_7740_(pos, true, (Entity)entity, 3);
            }
        }
        return false;
    }
}

