/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumToolTier;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemToolWateringCan
extends TieredItem
implements IItemUsable {
    private final EnumToolTier tier;

    public ItemToolWateringCan(EnumToolTier tier, Item.Properties props) {
        super(ItemTiers.TIER, props);
        this.tier = tier;
    }

    public int chargeAmount() {
        return this.tier.getTierLevel();
    }

    @Override
    public boolean hasCooldown() {
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.FARM;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
        Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
            LevelCalc.useRP((Player)player, data, 2.0f, true, 0.0f, true, EnumSkills.FARMING, EnumSkills.WATER);
            LevelCalc.levelSkill(player, data, EnumSkills.FARMING, 4.0f);
            LevelCalc.levelSkill(player, data, EnumSkills.WATER, 1.0f);
        });
    }

    public int maxWater() {
        return switch (this.tier) {
            case EnumToolTier.IRON -> GeneralConfig.ironWateringCanWater;
            case EnumToolTier.SILVER -> GeneralConfig.silverWateringCanWater;
            case EnumToolTier.GOLD -> GeneralConfig.goldWateringCanWater;
            case EnumToolTier.PLATINUM -> GeneralConfig.platinumWateringCanWater;
            default -> GeneralConfig.scrapWateringCanWater;
        };
    }

    public int getWater(ItemStack stack) {
        return stack.m_41784_().m_128451_("Water");
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            int chargeTime = ItemUtils.getChargeTime(entity, this.tier);
            if (duration > 0 && duration / chargeTime <= this.chargeAmount() && duration % chargeTime == 0) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (this.tier.getTierLevel() == 0) {
            return this.useOnBlock(ctx);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult ray = ItemToolWateringCan.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack itemstack = player.m_21120_(hand);
        BlockState state = world.m_8055_(ray.m_82425_());
        if (state.m_60819_().m_76152_() == Fluids.f_76193_) {
            itemstack.m_41784_().m_128405_("Water", this.maxWater());
            world.m_7731_(ray.m_82425_(), state.m_60819_().m_76188_(), 3);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        if (this.tier.getTierLevel() != 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return (int)((float)this.getWater(stack) / (float)this.maxWater() * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)this.getWater(stack) / (float)this.maxWater());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (this.tier.getTierLevel() != 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int useTime = (stack.m_41779_() - timeLeft - 1) / ItemUtils.getChargeTime(entity, this.tier);
            int range = Math.min(useTime, this.tier.getTierLevel());
            BlockHitResult result = ItemToolWateringCan.m_41435_((Level)world, (Player)((Player)entity), (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (range == 0) {
                if (result != null) {
                    this.useOnBlock(new UseOnContext((Player)entity, entity.m_7655_(), result));
                }
            } else {
                int amount;
                BlockPos pos = entity.m_142538_().m_7495_();
                if (result != null && result.m_6662_() != HitResult.Type.MISS) {
                    pos = result.m_82425_();
                }
                if ((amount = (int)BlockPos.m_121990_((BlockPos)pos.m_142082_(-range, -1, -range), (BlockPos)pos.m_142082_(range, 0, range)).filter(p -> this.moisten((ServerLevel)world, p.m_7949_(), stack, entity)).count()) > 0) {
                    Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                        LevelCalc.useRP((Player)player, data, 0.0f, true, (float)range * 17.5f, true, EnumSkills.FARMING);
                        LevelCalc.levelSkill(player, data, EnumSkills.FARMING, range * 10);
                        LevelCalc.levelSkill(player, data, EnumSkills.WATER, range * 3);
                    });
                }
            }
        }
        super.m_5551_(stack, world, entity, timeLeft);
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.tier == EnumToolTier.PLATINUM ? Rarity.EPIC : Rarity.COMMON;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    private InteractionResult useOnBlock(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        if (this.moisten((ServerLevel)ctx.m_43725_(), pos, stack, (LivingEntity)player) || this.moisten((ServerLevel)ctx.m_43725_(), pos.m_7495_(), stack, (LivingEntity)player)) {
            this.onBlockBreak((ServerPlayer)ctx.m_43723_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean moisten(ServerLevel world, BlockPos pos, ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player && !((Player)entity).m_36204_(pos.m_142300_(Direction.UP), Direction.UP, stack)) {
            return false;
        }
        boolean creative = !(entity instanceof Player) || ((Player)entity).m_7500_();
        BlockState state = world.m_8055_(pos);
        int water = this.getWater(stack);
        if ((creative || water > 0) && state.m_204336_(RunecraftoryTags.FARMLAND) && (Integer)state.m_61143_((Property)FarmBlock.f_53243_) != 7) {
            FarmlandHandler.waterLand(world, pos, state);
            if (!creative) {
                stack.m_41783_().m_128405_("Water", water - 1);
            }
            return true;
        }
        return false;
    }
}

