/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.items.BigWeapon;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemAxeBase
extends AxeItem
implements IItemUsable,
IAOEWeapon,
BigWeapon {
    private static final Vec3[] PARTICLE_DIRECTION = ItemAxeBase.generateParticleDir(2);

    public ItemAxeBase(Item.Properties props) {
        super(ItemTiers.TIER, 0.0f, 0.0f, props);
    }

    public boolean resetAttackStrength(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean swingWeapon(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean onServerSwing(LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.HAXE;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
        Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.LOGGING, 1.0f));
    }

    public float getRange(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_RANGE.get());
    }

    public float getWidth(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_WIDTH.get());
    }

    public boolean doSweepingAttack() {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            if (duration == ItemUtils.getChargeTime(entity)) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        boolean canCharge = Platform.INSTANCE.getPlayerData(player).map(data -> (data.getSkillLevel(EnumSkills.HAMMERAXE).getLevel() >= 5 || player.m_7500_()) && data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE_USE.get())))).orElse(false);
        if (canCharge) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (!world.f_46443_ && stack.m_41779_() - timeLeft - 1 >= ItemUtils.getChargeTime(entity)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE_USE.get())), stack));
                return;
            }
            if (ItemAxeBase.performRightClickAction(stack, entity, this.getRange(entity, stack), 0.7f)) {
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12316_, entity.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public static void delayedRightClickAction(LivingEntity entity, ItemStack stack) {
        double reach = CombatUtils.getRange(entity, 0.0);
        S2CScreenShake.sendAround((Entity)entity, 16.0, 4, 3.0f);
        if (ItemAxeBase.performRightClickAction(stack, entity, reach, 0.7f) && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.HAMMERAXE, 5.0f));
        }
    }

    public static boolean performRightClickAction(ItemStack stack, LivingEntity entity, double range, float knockback) {
        Collection<LivingEntity> list = ItemAxeBase.getEntitiesIn(entity, range, null);
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11892_, entity.m_5720_(), 1.0f, 0.4f);
        Vec3 pos = entity.m_20182_().m_82520_(0.0, -1.0, 0.0);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (Vec3 dir : PARTICLE_DIRECTION) {
            Vec3 scaled = dir.m_82490_(0.5);
            mut.m_122178_(Mth.m_14107_((double)(pos.m_7096_() + dir.m_7096_())), Mth.m_14107_((double)pos.m_7098_()), Mth.m_14107_((double)(pos.m_7094_() + dir.m_7094_())));
            BlockState blockState = entity.f_19853_.m_8055_((BlockPos)mut);
            if (blockState.m_60799_() == RenderShape.INVISIBLE) continue;
            ((ServerLevel)entity.m_183503_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), entity.m_20185_() + dir.m_7096_(), entity.m_20186_() + 0.1, entity.m_20189_() + dir.m_7094_(), 0, (double)((float)scaled.m_7096_()), 1.5, (double)((float)scaled.m_7094_()), 1.0);
        }
        if (!list.isEmpty()) {
            Supplier<CustomDamage.Builder> base = () -> new CustomDamage.Builder((Entity)entity).element(ItemNBT.getElement(stack)).knock(CustomDamage.KnockBackType.UP).knockAmount(knockback).hurtResistant(5);
            boolean success = false;
            double damagePhys = CombatUtils.getAttributeValue((Entity)entity, Attributes.f_22281_) * 1.1;
            for (Entity entity2 : list) {
                if (!CombatUtils.damageWithFaintAndCrit((Entity)entity, entity2, base.get(), damagePhys, stack)) continue;
                success = true;
            }
            return success;
        }
        return false;
    }

    public static Collection<LivingEntity> getEntitiesIn(LivingEntity entity, double reach, Predicate<LivingEntity> pred) {
        double incHalf = Math.asin(0.5 / reach) * 57.2957763671875;
        float minYRot = 0.0f;
        float maxYRot = 360.0f;
        AABB aabb = new AABB(-0.5, -0.15, 0.0, 0.5, 1.15, reach);
        int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
        float inc = (maxYRot - minYRot) / (float)rotationSteps;
        HashSet<LivingEntity> entities = new HashSet<LivingEntity>();
        Predicate<LivingEntity> predicate = e -> entity.m_20202_() != e && (pred == null || pred.test((LivingEntity)e));
        for (int steps = 0; steps <= rotationSteps; ++steps) {
            float yRot = minYRot + inc * (float)steps;
            OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, 0.0f, entity.m_20182_());
            entities.addAll(RayTraceUtils.getEntitiesIn((LivingEntity)entity, (OrientedBoundingBox)obb, (boolean)true, (EntityTypeTest)EntityTypeTest.m_156916_(LivingEntity.class), predicate));
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)entity);
        }
        return entities;
    }

    private static Vec3[] generateParticleDir(int range) {
        Vec3[] arr = new Vec3[(2 * range + 1) * (2 * range + 1) - 1];
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (x == 0 && z == 0) continue;
                arr[i] = new Vec3((double)x, 0.0, (double)z).m_82541_().m_82490_(1.2);
                ++i;
            }
        }
        return arr;
    }
}

