/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.api.item.IDualWeapon;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemGloveBase
extends Item
implements IItemUsable,
IDualWeapon,
IAOEWeapon {
    public ItemGloveBase(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public boolean resetAttackStrength(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean swingWeapon(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean onServerSwing(LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.GLOVES.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.GLOVE;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
    }

    public float getRange(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_RANGE.get());
    }

    public float getWidth(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_WIDTH.get());
    }

    public boolean doSweepingAttack() {
        return false;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            if (duration == ItemUtils.getChargeTime(entity)) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        boolean canCharge = Platform.INSTANCE.getPlayerData(player).map(data -> (data.getSkillLevel(EnumSkills.FIST).getLevel() >= 5 || player.m_7500_()) && data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.GLOVE_USE.get())))).orElse(false);
        if (canCharge) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (stack.m_41779_() - timeLeft - 1 >= ItemUtils.getChargeTime(entity)) {
                Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.GLOVE_USE.get())), stack));
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public ItemStack offHandStack(LivingEntity entity) {
        return Platform.INSTANCE.getEntityData(entity).map(d -> d.getGloveOffHand(entity.m_21205_())).orElse(entity.m_21205_());
    }
}

