/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.items.BigWeapon;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemAxeBase;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemHammerBase
extends PickaxeItem
implements IItemUsable,
IAOEWeapon,
BigWeapon {
    public ItemHammerBase(Item.Properties props) {
        super(ItemTiers.TIER, 0, 0.0f, props);
    }

    public boolean resetAttackStrength(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean swingWeapon(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean onServerSwing(LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.HAXE;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
    }

    public float getRange(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_RANGE.get());
    }

    public float getWidth(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_WIDTH.get());
    }

    public boolean doSweepingAttack() {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            if (duration == ItemUtils.getChargeTime(entity)) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        boolean canCharge = Platform.INSTANCE.getPlayerData(player).map(data -> (data.getSkillLevel(EnumSkills.HAMMERAXE).getLevel() >= 5 || player.m_7500_()) && data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE_USE.get())))).orElse(false);
        if (canCharge) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (!world.f_46443_ && stack.m_41779_() - timeLeft - 1 >= ItemUtils.getChargeTime(entity)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.HAMMER_AXE_USE.get())), stack));
                return;
            }
            if (ItemAxeBase.performRightClickAction(stack, entity, this.getRange(entity, stack), 0.7f)) {
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12316_, entity.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }
}

