/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.api.enums.EnumWeaponType;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.common.items.BigWeapon;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemLongSwordBase
extends SwordItem
implements IItemUsable,
IAOEWeapon,
BigWeapon {
    public ItemLongSwordBase(Item.Properties props) {
        super(ItemTiers.TIER, 0, 0.0f, props);
    }

    public boolean resetAttackStrength(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean swingWeapon(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public boolean onServerSwing(LivingEntity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).ifPresent(d -> d.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.LONG_SWORD.get())), stack));
            return false;
        }
        return true;
    }

    @Override
    public EnumWeaponType getWeaponType() {
        return EnumWeaponType.LONGSWORD;
    }

    @Override
    public void onBlockBreak(ServerPlayer player) {
    }

    public float getRange(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_RANGE.get());
    }

    public float getWidth(LivingEntity entity, ItemStack stack) {
        return (float)entity.m_21133_((Attribute)ModAttributes.ATTACK_WIDTH.get());
    }

    public boolean doSweepingAttack() {
        return false;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.m_41779_() - remainingUseDuration;
            if (duration == ItemUtils.getChargeTime(entity)) {
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12218_, player.m_5720_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        boolean canCharge = Platform.INSTANCE.getPlayerData(player).map(data -> (data.getSkillLevel(EnumSkills.LONGSWORD).getLevel() >= 5 || player.m_7500_()) && data.getWeaponHandler().canExecuteAction((AttackAction)((Object)((Object)ModAttackActions.LONGSWORD_USE.get())))).orElse(false);
        if (canCharge) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (!world.f_46443_ && stack.m_41779_() - timeLeft - 1 >= ItemUtils.getChargeTime(entity)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> data.getWeaponHandler().doWeaponAttack((AttackAction)((Object)((Object)ModAttackActions.LONGSWORD_USE.get())), stack));
                return;
            }
            if (ItemLongSwordBase.performRightClickAction(stack, entity, 0.0)) {
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, entity.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    public static void delayedRightClickAction(LivingEntity entity, ItemStack stack) {
        ServerPlayer player;
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, entity.m_5720_(), 1.0f, 1.0f);
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            player.m_36346_();
        }
        if (ItemLongSwordBase.performRightClickAction(stack, entity, 0.0) && entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> LevelCalc.levelSkill(player, data, EnumSkills.LONGSWORD, 7.0f));
        }
    }

    public static boolean performRightClickAction(ItemStack stack, LivingEntity entity, double range) {
        Collection<LivingEntity> list = CombatUtils.EntityAttack.circleTargets(entity.m_146908_() - 60.0f, entity.m_146908_() + 60.0f, (float)range).apply(entity, null);
        if (!list.isEmpty()) {
            Supplier<CustomDamage.Builder> base = () -> new CustomDamage.Builder((Entity)entity).element(ItemNBT.getElement(stack)).knock(CustomDamage.KnockBackType.UP).knockAmount(1.0f).hurtResistant(10);
            boolean success = false;
            double damagePhys = CombatUtils.getAttributeValue((Entity)entity, Attributes.f_22281_) * 1.2;
            for (LivingEntity e : list) {
                if (!CombatUtils.damageWithFaintAndCrit((Entity)entity, (Entity)e, base.get(), damagePhys, stack)) continue;
                success = true;
            }
            return success;
        }
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return ImmutableMultimap.of();
    }
}

